#ifndef OMG_DDS_TOPIC_TOPIC_MODULE_HPP_
#define OMG_DDS_TOPIC_TOPIC_MODULE_HPP_

/* Copyright 2010, Object Management Group, Inc.
 * Copyright 2010, PrismTech, Corp.
 * Copyright 2010, Real-Time Innovations, Inc.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// This file is an omnibus header for the topic module of the DDS API.

// --- TopicDescription Base Classes: --- //
#include <dds/topic/TopicDescription.hpp>
#include <dds/topic/AnyTopicDescription.hpp>

// --- Topic: --- //
#include <dds/topic/qos/TopicQos.hpp>
#include <dds/topic/TopicListener.hpp>
#include <dds/topic/AnyTopicListener.hpp>
#include <dds/topic/Topic.hpp>
#include <dds/topic/AnyTopic.hpp>

// -- Content-Based Topic Descriptions: --- //
#include <dds/topic/ContentFilteredTopic.hpp>
#include <dds/topic/MultiTopic.hpp>

// --- Built-in (Discovery) Topic Data Types: --- //
#include <dds/topic/BuiltinTopicKey.hpp>
#include <dds/topic/BuiltinTopic.hpp>

// --- Search Functions: --- //
#include <dds/topic/discover.hpp>
#include <dds/topic/find.hpp>
#include <dds/topic/parent.hpp>

// --- Miscellaneous: --- //
#include <dds/topic/TopicInstance.hpp>


#endif /* OMG_DDS_TOPIC_TOPIC_MODULE_HPP_ */
