package com.thalesgroup.marte.rapidrma.export.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.database.AlgorithmKind;
import com.thalesgroup.marte.rapidrma.database.AnalysisKind;
import com.thalesgroup.marte.rapidrma.database.Database;
import com.thalesgroup.marte.rapidrma.database.PriorityKind;
import com.thalesgroup.marte.rapidrma.database.PriorityMappingKind;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: DatabaseHelper.java,v 1.7 2008/06/16 13:56:12 sdemathieu Exp $
 */

/**
 * This class provides utilties to serialize RapidRMA database information into
 * a file.
 * 
 * @author Sbastien Demathieu (Thales Research & Technology)
 * @version 1.0 - 26/07/07
 */
public class DatabaseHelper extends RapidRMAHelper{

	
	/**
	 * References a RapidRMA database.
	 */
	private Database _database;
	
	/**
	 * DatabaseHelper default constructor.
	 * 
	 * @param database
	 *            the RapidRMA database
	 */
	public DatabaseHelper(Database database, String genDir) {
		super(database.getName());
		_database=database;
		try {
			setGenerationDirectory(genDir);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Creates a RapidRMA file from a database.
	 * 
	 * @param database
	 *            the RapidRMA database
	 * @throws Exception
	 *             if file creation fails
	 */
	private void createDatabase() throws Exception {

		File file = new File(RMAFormat.FILENAME);
		FileOutputStream out = new FileOutputStream(file);
		PrintWriter writer = new PrintWriter(out,true);
		
		RMAFormat rmaFormat = new RMAFormat();
		String[] values = new String[rmaFormat.length()];

		// algorithm.choice
		if (_database.getAlgorithm().equals(AlgorithmKind.RM_PCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "rm+pcp";
		} else if (_database.getAlgorithm()
				.equals(AlgorithmKind.RM_BIP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "rm+bip";
		} else if (_database.getAlgorithm().equals(
				AlgorithmKind.RM_DASPCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "rm+das";
		} else if (_database.getAlgorithm()
				.equals(AlgorithmKind.DM_PCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "dm+pcp";
		} else if (_database.getAlgorithm()
				.equals(AlgorithmKind.DM_BIP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "dm+bip";
		} else if (_database.getAlgorithm().equals(
				AlgorithmKind.DM_DASPCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "dm+das";
		} else if (_database.getAlgorithm().equals(
				AlgorithmKind.CYCLIC_EXECUTIVE_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "cyclic.executive";
		} else if (_database.getAlgorithm().equals(
				AlgorithmKind.ROSA_RM_PCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "rm+pcp+rosa";
		} else if (_database.getAlgorithm().equals(
				AlgorithmKind.ROSA_DM_PCP_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ALGO_)] = RMAFormat.ALGORITHM_CHOICE_LABEL+ "dm+pcp+rosa";
		}

		// task.graph.size.height
		values[rmaFormat.getNum(RapidRMAKeywords._HEIGH)] = RMAFormat.TASK_GRAPH_SIZE_HEIGHT_LABEL+ _database.getTaskGraphSize();

		// priority.choice
		if (_database.getPrority().equals(PriorityKind.DEFAULT_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._PRIO_)] = RMAFormat.PRIORITY_CHOICE_LABEL+ "default";
		} else {
			values[rmaFormat.getNum(RapidRMAKeywords._PRIO_)] = RMAFormat.PRIORITY_CHOICE_LABEL+ "user.specified";
		}

		// system.name
		values[rmaFormat.getNum(RapidRMAKeywords._SYST_)] = RMAFormat.SYSTEM_NAME_LABEL+ _database.getName();

		// priority.mapping.choice
		if (_database.getPriorityMapping().equals(
				PriorityMappingKind.DEFAULT_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._P_MAP)] = RMAFormat.PRIORITY_MAPPING_CHOICE_LABEL+ "default";			
		} else {
			values[rmaFormat.getNum(RapidRMAKeywords._P_MAP)] = RMAFormat.PRIORITY_MAPPING_CHOICE_LABEL+ "user.specified";	
		}

		// task.graph.size.width
		values[rmaFormat.getNum(RapidRMAKeywords._WIDTH)] = RMAFormat.TASK_GRAPH_SIZE_WIDTH_LABEL+ _database.getTaskGraphSize();

		// analysis.choice
		if (_database.getAnalysis().equals(AnalysisKind.SINGLE_NODE_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ANALY)] = RMAFormat.ANALYSIS_CHOICE_LABEL+ "single.node";
		} else if (_database.getAnalysis().equals(
				AnalysisKind.MULTIPLE_NODE_LITERAL)) {
			values[rmaFormat.getNum(RapidRMAKeywords._ANALY)] = RMAFormat.ANALYSIS_CHOICE_LABEL+ "multiple.node";
		} else {
			values[rmaFormat.getNum(RapidRMAKeywords._ANALY)] = RMAFormat.ANALYSIS_CHOICE_LABEL+ "endtoend";
		}
		rmaFormat.write(values,writer);
		writer.close();
	}
	
	public void create() {
		try {
			Log.verboseMessage(Activator.PLUGIN_ID,"Database file");
			createDatabase();
		}
		catch (Exception exception) {
			Log.errorMessage(Activator.PLUGIN_ID,"Problem in creating DatabaseHelper",exception);
		}
	}
}
