/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: ExportAction.java,v 1.6 2008/06/16 13:56:12 sdemathieu Exp $
 */

package com.thalesgroup.marte.rapidrma.export.actions;

import java.io.File;

import javax.swing.JFileChooser;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.database.Database;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * Our sample action implements workbench action delegate. The action proxy will
 * be created by the workbench and shown in the UI. When the user tries to use
 * the action, this delegate will be created and execution will be delegated to
 * it.
 * 
 * @author Sbastien Demathieu (Thales Research & Technology)
 * @version 1.0 - 26/07/07
 */
public class ExportAction implements IWorkbenchWindowActionDelegate {
	
	/**
	 * Activation of the possibility to run the generation
	 */
	//private boolean active = false;
	
	/**
	 * Directory in which the files will be generated
	 */
	private String generationDirectory=".\\";

	/**
	 * The related workbench window.
	 */
	private IWorkbenchWindow window;

	/**
	 * The root of the RapidRMA model to export.
	 */
	private Database database;

	/**
	 * ExportAction default constructor.
	 */
	public ExportAction() {
	}

	/**
	 * The action has been activated. The argument of the method represents the
	 * 'real' action sitting in the workbench UI.
	 * 
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		if (database != null) {
			
			String path = SelectionGetter.getPath();
			generationDirectory = (path==null)?".//":path;
			
			System.out.println(SelectionGetter.getPath());
			
			JFileChooser dirChoice = new JFileChooser(generationDirectory);
			dirChoice.setDialogTitle("Select directory in which RapidRMA files will be generated");
			dirChoice.setApproveButtonText("Select directory");
			dirChoice.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				
			if (dirChoice.showOpenDialog(null)== JFileChooser.APPROVE_OPTION) {
				try {
					setGenerationDirectory(dirChoice.getSelectedFile().getAbsolutePath());
					
					Log.verboseMessage(Activator.PLUGIN_ID,"RapidRMA files generation for database "+database.getName());

					/* Creates the database file */
					DatabaseHelper dbHelper = new DatabaseHelper(database,generationDirectory);
					dbHelper.create();

					/* Creates the resource graph file */
					ResourceHelper resHelper = new ResourceHelper(database.getName(), database.getResource());
					resHelper.create();

					/* Creates the task graph file */
					TaskHelper tHelper = new TaskHelper(database.getName(),database.getTask());
					tHelper.create();

				}
				catch (Exception e) {
					System.out.println(e);
				}
			}
			else {
				System.out.println("Generation cancelled");
			}
		} 
		else {
			MessageDialog.openInformation(window.getShell(),
					"Export error",
					"Select a RapidRMA database before generation.");
		}
	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection struct = (IStructuredSelection) selection;
			if (struct.getFirstElement() instanceof Database) {
				Object first = (Database) struct.getFirstElement();
				database = (Database) first;
			} 
			else {
				database = null;
			}
		}
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
		//updateUIState();
	}
	
	/**
	 * Changes the directory where files will be generated 
	 */
	protected void setGenerationDirectory(String genDir) throws Exception {
		if (!genDir.endsWith("\\")) {
			genDir=genDir+"\\";
		}
		try {
			File checkDirFile = new File(genDir);
			if (!checkDirFile.exists()) {
				checkDirFile.mkdir();
				generationDirectory=genDir;
			}
			else if (checkDirFile.isDirectory()) {
				generationDirectory=genDir;
			}
			else {
				throw new Exception("Invalid directory");
			}
		}
		catch (Exception e){
			e.printStackTrace();
		}
	}

	/*public void updateUIState() {

		IWorkbench workbench = PlatformUI.getWorkbench();
		
		// 1. Le menu tout en haut
		Menu menu = workbench.getActiveWorkbenchWindow().getShell().getMenuBar();
		org.eclipse.swt.widgets.MenuItem[] menu_items = menu.getItems();
		
		for (org.eclipse.swt.widgets.MenuItem item : menu_items) {
			if(item.getText().equals("&RapidRMA")) {
				
				Menu mmenu = item.getMenu();
				for (org.eclipse.swt.widgets.MenuItem mitem : mmenu.getItems()) {
					if(mitem.getText().equals("&Export to RapidRMA")) {
						mitem.setEnabled(active);
					}
					
				}
			}
		}
		
		// 2. Le menu version joli dessins
		
		
	}*/
}