package com.thalesgroup.marte.rapidrma.export.actions;


/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class RGFormat extends RapidRMAFormat{
	
	static String EXTENSION = "rg";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "." + EXTENSION;
	static String SCHEMA_FILENAME = RapidRMAFormat.PROJECT_NAME + ".schema";
	
	/**
	 * RGFormat default constructor.
	 * 
	 */
	public RGFormat() {
		RapidRMAField[] format = new RapidRMAField[14];
		format[0] = new RapidRMAField(0,"DataSet ID","string","DataSet ID,Variant.STRING,-1,-1,");
		format[1] = new RapidRMAField(1,"Index","int","Index,Variant.INT,-1,-1,");
		format[2] = new RapidRMAField(2,"Resource ID","string","Resource ID,Variant.STRING,-1,-1,");
		format[3] = new RapidRMAField(3,"Resource Name","string","Resource Name,Variant.STRING,-1,-1,");
		format[4] = new RapidRMAField(4,"RESOURCE_TYPE","string","RESOURCE_TYPE,Variant.STRING,-1,-1,");
		format[5] = new RapidRMAField(5,"Free Node","boolean","Free Node,Variant.BOOLEAN,-1,-1,");
		format[6] = new RapidRMAField(6,"NODE","string","NODE,Variant.STRING,-1,-1,");
		format[7] = new RapidRMAField(7,"Node ID","string","Node ID,Variant.STRING,-1,-1,");
		format[8] = new RapidRMAField(8,"Acquisition Time","int","Acquisition Time,Variant.INT,-1,-1,");
		format[9] = new RapidRMAField(9,"Deacquisition Time","int","Deacquisition Time,Variant.INT,-1,-1,");
		format[10] = new RapidRMAField(10,"Context Switch Rate","int","Context Switch Rate,Variant.INT,-1,-1,");
		format[11] = new RapidRMAField(11,"Processing Rate","float","Processing Rate,Variant.FLOAT,-1,-1,");
		format[12] = new RapidRMAField(12,"Priority Direction","int","Priority Direction,Variant.INT,-1,-1,");
		format[13] = new RapidRMAField(13,"Comments","string","Comments,Variant.STRING,-1,-1,");
		
		this.initFields(format);
	}
	
	protected String getSchemaFilename() {
		return SCHEMA_FILENAME;
	}
}
