package com.thalesgroup.marte.rapidrma.export.actions;


/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class RG_PM_Format extends RapidRMAFormat{

	static String CATEGORY = "pm";
	static String EXTENSION = "rgX";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "-" + CATEGORY + "." + EXTENSION;
	static String SCHEMA_FILENAME = RapidRMAFormat.PROJECT_NAME + "-"+ CATEGORY + ".schema";
	
	/**
	 * RG_PM_Format default constructor.
	 * 
	 */
	public RG_PM_Format() {
		RapidRMAField[] format = new RapidRMAField[5];
		format[0] = new RapidRMAField(0,"Index","int","Index,Variant.INT,-1,-1,");
		format[1] = new RapidRMAField(1,"ID","string","ID,Variant.STRING,-1,-1,");
		format[2] = new RapidRMAField(2,"Resource ID","string","Resource ID,Variant.STRING,-1,-1,");
		format[3] = new RapidRMAField(3,"Start Time","int","Start Time,Variant.INT,-1,-1,");
		format[4] = new RapidRMAField(4,"End Time","int","End Time,Variant.INT,-1,-1,");
		this.initFields(format);
	}
	
	protected String getSchemaFilename() {
		return SCHEMA_FILENAME;
	}
}
