package com.thalesgroup.marte.rapidrma.export.actions;


/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 03/08/2007
 */
public class RMAFormat extends RapidRMAFormat{

	static String EXTENSION = "rma";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "." + EXTENSION;
	
	public static String ALGORITHM_CHOICE_LABEL = "algorithm.choice=";
	public static String TASK_GRAPH_SIZE_HEIGHT_LABEL = "task.graph.size.height=";
	public static String PRIORITY_CHOICE_LABEL = "priority.choice=";
	public static String SYSTEM_NAME_LABEL = "system.name=";
	public static String PRIORITY_MAPPING_CHOICE_LABEL = "priority.mapping.choice=";
	public static String TASK_GRAPH_SIZE_WIDTH_LABEL = "task.graph.size.width=";
	public static String ANALYSIS_CHOICE_LABEL = "analysis.choice=";
	
	/**
	 * RGFormat default constructor.
	 * 
	 */
	public RMAFormat() {
		SEPARATOR = "\n";
		RapidRMAField[] format = new RapidRMAField[7];
		format[0] = new RapidRMAField(0,"algorithm.choice","other","");
		format[1] = new RapidRMAField(1,"task.graph.size.height","other","");
		format[2] = new RapidRMAField(2,"priority.choice","other","");
		format[3] = new RapidRMAField(3,"system.name","other","");
		format[4] = new RapidRMAField(4,"priority.mapping.choice","other","");
		format[5] = new RapidRMAField(5,"task.graph.size.width","other","");
		format[6] = new RapidRMAField(6,"analysis.choice","other","");
		
		this.initFields(format);
	}
	
	protected String getSchemaFilename() {
		return null;
	}

}
