package com.thalesgroup.marte.rapidrma.export.actions;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the fields used in RapidRMA files
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/07
 */
public class RapidRMAField {
	
	String DELIMITER = "\"";
	
	static final String DEFAULT_NAME = "";
	static final String DEFAULT_TYPE = "string";
	static final String DEFAULT_DESCRIPTION = "";
	static final String DEFAULT_VALUE = "";
	
	protected String keyword = "";
	protected int num = 0;
	protected String name = RapidRMAField.DEFAULT_NAME;
	protected String type = RapidRMAField.DEFAULT_TYPE;
	protected String description = RapidRMAField.DEFAULT_DESCRIPTION;
	protected String value = RapidRMAField.DEFAULT_VALUE;
	
	/**
	 * RapidRMAField full constructor.
	 * 
	 */
	public RapidRMAField(int num, String name, String type, String description) {
		this.num = num;
		if (name==null) {
			this.name = RapidRMAField.DEFAULT_NAME;
		}
		else {
			this.name = name;
			this.keyword = RapidRMAKeywords.getKeyword(name);
			if (this.keyword==null) {
				Log.errorMessage(Activator.PLUGIN_ID,"Keyword not described for "+name);
			}
		}
		if (type==null) {
			Log.errorMessage(Activator.PLUGIN_ID,"Field type not initialized");
			this.type = RapidRMAField.DEFAULT_TYPE;
		}
		else {
			this.type = type;
		}
		if (description==null){
			this.type = RapidRMAField.DEFAULT_DESCRIPTION;
		}
		else {
			this.description = description;
		}
	}
	
	public void setDelimiter(String D) {
		DELIMITER = D;
	}
	
	public void setValue(String value) {
		if (value==null) {
			Log.warningMessage(Activator.PLUGIN_ID,"Field value not initialized : "+this.name);
			this.value = RapidRMAField.DEFAULT_VALUE;
		}
		else {
			this.value = value;
		}
	}
	
	public String getName() {
		return name;
	}
	
	public String getDescription() {
		return description;
	}

	public String toString() {
		if (type=="string") {
			if (value==null) {
				return DELIMITER+""+DELIMITER;
			}
			else {
				return DELIMITER+value+DELIMITER;
			}
		}
		else if (type=="int"){
			if (value == null || value=="") {
				return("0");
			}
			return value;
		}
		else if (type=="float"){
			if (value == null || value=="") {
				return("0.0");
			}
			return value;
		}
		else if (type=="boolean") {
			if (value == null || value=="") {
				return("false");
			}
			return value;
		}
		else if (type=="other") {
			if (value == null || value=="") {
				return("");
			}
			return value;
		}
		else {
			Log.errorMessage(Activator.PLUGIN_ID,"Field type is not correct");
			return "ERROR";
		}
	}

}
