package com.thalesgroup.marte.rapidrma.export.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
abstract public class RapidRMAFormat {
	
	String SEPARATOR = ",";
	String DELIMITER = "\"";

	static String PROJECT_NAME = RapidRMAHelper._generationDirectory + RapidRMAHelper._projectName;
	
	protected RapidRMAField[] fields;

	/**
	 * RapidRMAFormat default constructor.
	 * 
	 */
	public RapidRMAFormat() {
	}

	abstract protected String getSchemaFilename();
	
	public void initFields(RapidRMAField[] fields) {
		this.fields = new RapidRMAField[fields.length];
		for (int i=0;i<fields.length;i++) {
			if (fields[i]==null) {
				Log.errorMessage(Activator.PLUGIN_ID,"Field not defined for rank "+i);
			}
			else {
				this.fields[fields[i].num] = fields[i];
				this.fields[fields[i].num].setDelimiter(DELIMITER);
			}
		}
		if (getSchemaFilename()!=null) {
			generateSchema(getSchemaFilename());
		}
	}
	
	public int length() {
		if (fields==null) {
			Log.errorMessage(Activator.PLUGIN_ID,"RapidRMAFormat.length() Fields not already initialized");
			return 0;
		}
		return fields.length;
	}
	
	public int getNum(String keyword) {
		if (fields==null) {
			Log.errorMessage(Activator.PLUGIN_ID,"RapidRMAFormat.getNum(String keyword) Fields not already initialized");
			return 0;
		}
		else {
			for(int i=0;i<fields.length;i++) {
				if (fields[i].keyword==keyword) {
					return fields[i].num;
				}
			}
			Log.errorMessage(Activator.PLUGIN_ID,"Keyword not found : "+keyword);
			return 0;
		}
	}
	
	public void setFields(String[] values) {
		if (values.length == fields.length) {
			for (int i=0;i<fields.length;i++) {
				fields[i].setValue(values[i]);
			}
		}
		else {
			Log.errorMessage(Activator.PLUGIN_ID,"The fields length is not corresponding to the description : "+this.description());
		}
			
	}
	
	/**
	 * Description of the format
	 */
	public String description() {
		String result = "FORMAT : ";
		for (int i=0;i<fields.length;i++) {
			result = result+fields[i].getName();
			if (i<fields.length-1) {
				result = result + SEPARATOR;
			}
		}
		return result;		
	}

	public String toString() {
		String result = "";
		for (int i=0;i<fields.length;i++) {
			result = result+fields[i].toString();
			if (i<fields.length-1) {
				result = result + SEPARATOR;
			}
		}
		return result;
	}
	
	public void write(PrintWriter writer) {
		writer.print(this.toString());
		writer.println();
	}
	
	public void write(String[] values,PrintWriter writer) {
		this.setFields(values);
		this.write(writer);
	}
	
	public void generateSchema(String filename) {
		try {
			File file = new File(filename);
			FileOutputStream out = new FileOutputStream(file);
			PrintWriter writer = new PrintWriter(out);
			writer.println("[]");
			writer.println("FILETYPE = VARYING");
			writer.println("FILEFORMAT = Encoded");
			writer.println("ENCODING = Cp1252");
			writer.println("DELIMITER = "+DELIMITER);
			writer.println("SEPARATOR = "+SEPARATOR);
			for (int i=0;i<fields.length;i++) {
				writer.println("FIELD"+fields[i].num+" = "+fields[i].description);
			}
			writer.close();
			
		}
		catch (Exception exception) {
			Log.errorMessage(Activator.PLUGIN_ID,"Problem generating Schema",exception);
		}
	}

}
