package com.thalesgroup.marte.rapidrma.export.actions;

import java.util.Hashtable;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 * 
 */

/**
 * This class is a Hastable to recover elements ids
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/07
 */
public class RapidRMAHashtable extends Hashtable {

	static final long serialVersionUID = 0;
	private String id;
	
	/**
	 * RapidRMAHashtable constructor.
	 * 
	 */
	public RapidRMAHashtable(String name) {
		super();
		id=name;
	}

	public Object put(Object key,Object element) {
		if (key!=null) {
			Log.debugMessage(Activator.PLUGIN_ID,id+" Hashtable put : "+key.toString()+" --> "+element.toString());
			return super.put(key,element);
		}
		else {
			Log.errorMessage(Activator.PLUGIN_ID,"Trying to insert an element with a null key");
			return null;
		}
	}
	
	public Object get(Object key) {
		if (key!=null) {
			Log.debugMessage(Activator.PLUGIN_ID,id+" Hashtable get : "+key.toString());
			return super.get(key);
		}
		else {
			Log.errorMessage(Activator.PLUGIN_ID,"Research in hashtable "+id+" with a null key");
			return null;
		}
	}
}