package com.thalesgroup.marte.rapidrma.export.actions;

import java.io.File;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 * 
 */

/**
 * This class is an abstract class to provide utilties to serialize RapidRMA database information into
 * a file.
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 30/07/07
 */
public abstract class RapidRMAHelper {
	

	/**
	 * Hashtable
	 */
	static protected RapidRMAHashtable _idTable;
	
	/**
	 * Project name
	 */
	static protected String _projectName="";
	
	/**
	 * Directory of generation
	 */
	static protected String _generationDirectory=".\\";

	/**
	 * RapidRMAHelper constructor.
	 * 
	 * @param database
	 *            the RapidRMA database
	 */
	public RapidRMAHelper(String name) {
		_projectName = name;
	}
	

	/**
	 * Changes the directory where files will be generated 
	 */
	protected void setGenerationDirectory(String genDir) throws Exception {
		try {
			File checkDirFile = new File(genDir);
			if (!checkDirFile.exists()) {
				checkDirFile.mkdir();
				RapidRMAHelper._generationDirectory=genDir;
			}
			else if (checkDirFile.isDirectory()) {
				RapidRMAHelper._generationDirectory=genDir;
			}
			else {
				throw new Exception("Invalid directory");
			}
		}
		catch (Exception exception){
			Log.errorMessage(Activator.PLUGIN_ID,"The directory can not be set",exception);
		}
	}
	
	/**
	 * Creation of an Hashtable if it does not already exists
	 */
	protected void validHashtable() {
		if (RapidRMAHelper._idTable==null) {
			RapidRMAHelper._idTable=new RapidRMAHashtable("Global");
		}
	}
	
	/**
	 * Create the related RapidRMA files
	 */
	abstract void create();
}