package com.thalesgroup.marte.rapidrma.export.actions;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;


/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe used keywords
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class RapidRMAKeywords{
	
	public static String ERROR_ = "ERROR_";

	public static String _ALGO_ = "_ALGO_";
	public static String _HEIGH = "_HEIGH";
	public static String _PRIO_ = "_PRIO";
	public static String _SYST_ = "_SYST_";
	public static String _P_MAP = "_P_MAP";
	public static String _WIDTH = "_WIDTH";
	public static String _ANALY = "_ANALY";
	
	public static String INDEX_ = "INDEX_";
	public static String ID____ = "ID____";
	public static String RES_ID = "RES_ID";
	public static String STARTT = "STARTT";
	public static String END_T_ = "END_T_";
	public static String NODEID = "NODEID";
	public static String A_NODE = "A_NODE";
	public static String CRESID = "CRESID";
	public static String DATAID = "DATAID";
	public static String R_NAME = "R_NAME";
	public static String R_TYPE = "R_TYPE";
	public static String F_NODE = "F_NODE";
	public static String NODE__ = "NODE__";
	public static String ACQ_T_ = "ACQ_T_";
	public static String DEACQT = "DEACQT";
	public static String CSRATE = "CSRATE";
	public static String P_RATE = "P_RATE";
	public static String PRIO_D = "PRIO_D";
	public static String COMMEN = "COMMEN";
	public static String TASKID = "TASKID";
	public static String T_NAME = "T_NAME";
	public static String PERIOD = "PERIOD";
	public static String P_SELE = "P_SELE";
	public static String P_MIN_ = "P_MIN_";
	public static String P_MAX_ = "P_MAX_";
	public static String P_AVG_ = "P_AVG_";
	public static String AOWORK = "A_WORK";
	public static String AOWSEL = "AOWSEL";
	public static String AOWMIN = "AOWMIN";
	public static String AOWMAX = "AOWMAX";
	public static String AOWAVG = "AOWAVG";
	public static String READYT = "READYT";
	public static String R_DEAD = "R_DEAD";
	public static String DROPDL = "DROPDL";
	public static String PHASE_ = "PHASE_";
	public static String PRIO__ = "PRIO__";
	public static String NW_QOS = "NW_QOS";
	public static String A_RES_ = "A_RES_";
	public static String DLTYPE = "DLTYPE";
	public static String INST__ = "INST__";
	public static String T_SERV = "T_SERV";
	public static String XCOORD = "XCOORD";
	public static String YCOORD = "YCOORD";
	public static String R_DATA = "R_DATA";
	public static String N_NAME = "N_NAME";
	public static String WORK__ = "WORK__";
	public static String DEADID = "DEADID";
	public static String DEAD__ = "DEAD__";
	public static String PREDID = "PREDID";
	public static String SUCCID = "SUCCID";
	public static String DEPEND = "DEPEND";
	public static String SERVID = "SERVID";
	public static String S_NAME = "S_NAME";
	public static String EXEC_B = "EXEC_B";
	public static String S_TYPE = "S_TYPE";
	public static String SERV_Q = "SERV_Q";
	public static String PHNAME = "PHNAME";
	public static String PCOFFP = "PCOFFP";
	public static String AOW_HN = "AOW_HN";
	public static String AOWCOP = "AOWCOP";
	public static String SCCREQ = "SCCREQ";
	
	private static int NB = 71;
	private static boolean INITIALIZED = false;
	private static RapidRMAKeyword[] keywords;
	
	private static void init() {
		keywords = new RapidRMAKeyword[RapidRMAKeywords.NB];
		keywords[0] = new RapidRMAKeyword(ERROR_,"ERROR");
		keywords[1] = new RapidRMAKeyword(INDEX_,"Index");
		keywords[2] = new RapidRMAKeyword(RES_ID,"Resource ID");
		keywords[3] = new RapidRMAKeyword(R_NAME,"Resource Name");
		keywords[4] = new RapidRMAKeyword(R_TYPE,"RESOURCE_TYPE");
		keywords[5] = new RapidRMAKeyword(F_NODE,"Free Node");
		keywords[6] = new RapidRMAKeyword(NODE__,"NODE");
		keywords[7] = new RapidRMAKeyword(NODEID,"Node ID");
		keywords[8] = new RapidRMAKeyword(ACQ_T_,"Acquisition Time");
		keywords[9] = new RapidRMAKeyword(DEACQT,"Deacquisition Time");
		keywords[10] = new RapidRMAKeyword(CSRATE,"Context Switch Rate");
		keywords[11] = new RapidRMAKeyword(P_RATE,"Processing Rate");
		keywords[12] = new RapidRMAKeyword(PRIO_D,"Priority Direction");
		keywords[13] = new RapidRMAKeyword(COMMEN,"Comments");
		keywords[14] = new RapidRMAKeyword(TASKID,"Task ID");
		keywords[15] = new RapidRMAKeyword(T_NAME,"Task Name");
		keywords[16] = new RapidRMAKeyword(PERIOD,"Period");
		keywords[17] = new RapidRMAKeyword(P_SELE,"Period Selection");
		keywords[18] = new RapidRMAKeyword(P_MIN_,"Period Min");
		keywords[19] = new RapidRMAKeyword(P_MAX_,"Period Max");
		keywords[20] = new RapidRMAKeyword(P_AVG_,"Period Avg");
		keywords[21] = new RapidRMAKeyword(PHNAME,"Period Histogram Name");
		keywords[22] = new RapidRMAKeyword(PCOFFP,"Period Cut Off Percentage");
		keywords[23] = new RapidRMAKeyword(AOWORK,"Amount Of Work");
		keywords[24] = new RapidRMAKeyword(AOWSEL,"Amount Of Work Selection");
		keywords[25] = new RapidRMAKeyword(AOWMIN,"Amount Of Work Min");
		keywords[26] = new RapidRMAKeyword(AOWMAX,"Amount Of Work Max");
		keywords[27] = new RapidRMAKeyword(AOWAVG,"Amount Of Work Avg");
		keywords[28] = new RapidRMAKeyword(AOW_HN,"Amount Of Work Histogram Name");
		keywords[29] = new RapidRMAKeyword(AOWCOP,"Amount Of Work Cut Off Percentage");
		keywords[30] = new RapidRMAKeyword(READYT,"Ready Time");
		keywords[31] = new RapidRMAKeyword(R_DEAD,"Relative Deadline");
		keywords[32] = new RapidRMAKeyword(DROPDL,"Drop Deadline");
		keywords[33] = new RapidRMAKeyword(PHASE_,"Phase");
		keywords[34] = new RapidRMAKeyword(PRIO__,"Priority");
		keywords[35] = new RapidRMAKeyword(NW_QOS,"Network QoS");
		keywords[36] = new RapidRMAKeyword(A_RES_,"Active Resource");
		keywords[37] = new RapidRMAKeyword(DLTYPE,"Deadline Type");
		keywords[38] = new RapidRMAKeyword(INST__,"Instances");
		keywords[39] = new RapidRMAKeyword(T_SERV,"Task Server");
		keywords[40] = new RapidRMAKeyword(SCCREQ,"Spare Capacity Calc Required");
		keywords[41] = new RapidRMAKeyword(XCOORD,"X Coord");
		keywords[42] = new RapidRMAKeyword(YCOORD,"Y Coord");
		keywords[43] = new RapidRMAKeyword(DATAID,"DataSet ID");
		keywords[44] = new RapidRMAKeyword(A_NODE,"Accessed Node");
		keywords[45] = new RapidRMAKeyword(_ALGO_,"algorithm.choice");
		keywords[46] = new RapidRMAKeyword(_HEIGH,"task.graph.size.height");
		keywords[47] = new RapidRMAKeyword(_PRIO_,"priority.choice");
		keywords[48] = new RapidRMAKeyword(_SYST_,"system.name");
		keywords[49] = new RapidRMAKeyword(_P_MAP,"priority.mapping.choice");
		keywords[50] = new RapidRMAKeyword(_WIDTH,"task.graph.size.width");
		keywords[51] = new RapidRMAKeyword(_ANALY,"analysis.choice");
		keywords[52] = new RapidRMAKeyword(R_DATA,"Resources Dataset");
		keywords[53] = new RapidRMAKeyword(N_NAME,"Node Name");
		keywords[54] = new RapidRMAKeyword(PREDID,"Predecessor Task ID");
		keywords[55] = new RapidRMAKeyword(SUCCID,"Successor Task ID");
		keywords[56] = new RapidRMAKeyword(DEPEND,"Dependentp");
		keywords[57] = new RapidRMAKeyword(NODE__,"Node");
		keywords[58] = new RapidRMAKeyword(ID____,"ID");
		keywords[59] = new RapidRMAKeyword(WORK__,"Work");
		keywords[60] = new RapidRMAKeyword(STARTT,"Start Time");
		keywords[61] = new RapidRMAKeyword(END_T_,"End Time");
 		keywords[62] = new RapidRMAKeyword(SERVID,"Server ID");
		keywords[63] = new RapidRMAKeyword(S_NAME,"Server Name");
		keywords[64] = new RapidRMAKeyword(EXEC_B,"Execution Budget");
		keywords[65] = new RapidRMAKeyword(S_TYPE,"Server Type");
		keywords[66] = new RapidRMAKeyword(SERV_Q,"Server Queuing");
		keywords[67] = new RapidRMAKeyword(CRESID,"Conflicting Resource ID");
		keywords[68] = new RapidRMAKeyword(DEADID,"Deadline ID");
		keywords[69] = new RapidRMAKeyword(DEAD__,"Deadline");
		keywords[70] = new RapidRMAKeyword(R_DEAD,"Rel Deadline");
/*
		keywords[71] = new RapidRMAKeyword(,"");
		keywords[72] = new RapidRMAKeyword(,"");
		keywords[73] = new RapidRMAKeyword(,"");
		keywords[74] = new RapidRMAKeyword(,"");
		keywords[75] = new RapidRMAKeyword(,"");
		keywords[76] = new RapidRMAKeyword(,"");
		keywords[77] = new RapidRMAKeyword(,"");
		keywords[78] = new RapidRMAKeyword(,"");
		keywords[79] = new RapidRMAKeyword(,"");
		keywords[80] = new RapidRMAKeyword(,"");
		keywords[81] = new RapidRMAKeyword(,"");
		keywords[82] = new RapidRMAKeyword(,"");
		keywords[83] = new RapidRMAKeyword(,"");
		keywords[84] = new RapidRMAKeyword(,"");
		keywords[85] = new RapidRMAKeyword(,"");
		keywords[86] = new RapidRMAKeyword(,"");
		keywords[87] = new RapidRMAKeyword(,"");
		keywords[88] = new RapidRMAKeyword(,"");
		keywords[89] = new RapidRMAKeyword(,"");
		keywords[90] = new RapidRMAKeyword(,"");
		keywords[91] = new RapidRMAKeyword(,"");
		keywords[92] = new RapidRMAKeyword(,"");
		keywords[93] = new RapidRMAKeyword(,"");
		keywords[94] = new RapidRMAKeyword(,"");
		keywords[95] = new RapidRMAKeyword(,"");
		keywords[96] = new RapidRMAKeyword(,"");
		keywords[97] = new RapidRMAKeyword(,"");
		keywords[98] = new RapidRMAKeyword(,"");
		keywords[99] = new RapidRMAKeyword(,"");
*/
		
	}
	
	public static String getKeyword(String name) {
		if (!RapidRMAKeywords.INITIALIZED) {
			Log.verboseMessage(Activator.PLUGIN_ID,"Keywords database initialization");
			RapidRMAKeywords.init();
			RapidRMAKeywords.INITIALIZED = true;
		}
		for (int i=0;i<RapidRMAKeywords.NB;i++) {
			if (keywords[i].isRapidRMAKeyword(name)) {
				return keywords[i].getKeyword();
			}
		}
		return null;
	}

}
