/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 */

package com.thalesgroup.marte.rapidrma.export.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Listens to changes that happen to the Eclipse section.
 */
public class SelectionGetter implements ISelectionListener {

	/**
	 * Default path for the selection
	 */
	private static String path = null;
	
	/**
	 * Callback invoked by Eclipse upon selection change
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (selection instanceof ITreeSelection){
			ITreeSelection treeSelection = (ITreeSelection) selection;
			Object firstElement = treeSelection.getFirstElement();
			if (firstElement instanceof IContainer){
				IContainer container = (IContainer) firstElement;
				IPath p = container.getLocation();
				if(p != null){
					path = p.toString();
				}
			}
		}
	}

	/**
	 * Returns the path for the selection
	 */
	public static String getPath() {
		return path;
	}
}
