package com.thalesgroup.marte.rapidrma.export.actions;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class TGFormat extends RapidRMAFormat{

	static String EXTENSION = "tg";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "." + EXTENSION;
	static String SCHEMA_FILENAME = RapidRMAFormat.PROJECT_NAME + "-" + EXTENSION + ".schema";
		
	/**
	 * TGFormat default constructor.
	 * 
	 */
	public TGFormat() {
		RapidRMAField[] format = new RapidRMAField[31];
		format[0] = new RapidRMAField(0,"Index","int","Index,Variant.INT,-1,-1,");
		format[1] = new RapidRMAField(1,"Task ID","string","Task ID,Variant.STRING,-1,-1,");
		format[2] = new RapidRMAField(2,"Task Name","string","Task Name,Variant.STRING,-1,-1,");
		format[3] = new RapidRMAField(3,"Period","string","Period,Variant.STRING,-1,-1,");
		format[4] = new RapidRMAField(4,"Period Selection","string","Period Selection,Variant.STRING,-1,-1,");
		format[5] = new RapidRMAField(5,"Period Min","int","Period Min,Variant.INT,-1,-1,");
		format[6] = new RapidRMAField(6,"Period Max","boolean","Period Max,Variant.INT,-1,-1,");
		format[7] = new RapidRMAField(7,"Period Avg","int","Period Avg,Variant.INT,-1,-1,");
		format[8] = new RapidRMAField(8,"Period Histogram Name","string","Period Histogram Name,Variant.STRING,-1,-1,");
		format[9] = new RapidRMAField(9,"Period Cut Off Percentage","int","Period Cut Off Percentage,Variant.INT,-1,-1,");
		format[10] = new RapidRMAField(10,"Amount Of Work","string","Amount Of Work,Variant.STRING,-1,-1,");
		format[11] = new RapidRMAField(11,"Amount Of Work Selection","string","Amount Of Work Selection,Variant.STRING,-1,-1,");
		format[12] = new RapidRMAField(12,"Amount Of Work Min","int","Amount Of Work Min,Variant.INT,-1,-1,");
		format[13] = new RapidRMAField(13,"Amount Of Work Max","int","Amount Of Work Max,Variant.INT,-1,-1,");
		format[14] = new RapidRMAField(14,"Amount Of Work Avg","int","Amount Of Work Avg,Variant.INT,-1,-1,");
		format[15] = new RapidRMAField(15,"Amount Of Work Histogram Name","string","Amount Of Work Histogram Name,Variant.STRING,-1,-1,");
		format[16] = new RapidRMAField(16,"Amount Of Work Cut Off Percentage","int","Amount Of Work Cut Off Percentage,Variant.INT,-1,-1,");
		format[17] = new RapidRMAField(17,"Ready Time","int","Ready Time,Variant.INT,-1,-1,");
		format[18] = new RapidRMAField(18,"Relative Deadline","int","Relative Deadline,Variant.INT,-1,-1,");
		format[19] = new RapidRMAField(19,"Drop Deadline","int","Drop Deadline,Variant.INT,-1,-1,");
		format[20] = new RapidRMAField(20,"Phase","int","Phase,Variant.INT,-1,-1,");
		format[21] = new RapidRMAField(21,"Priority","int","Priority,Variant.INT,-1,-1,");
		format[22] = new RapidRMAField(22,"Network QoS","int","Network QoS,Variant.INT,-1,-1,");
		format[23] = new RapidRMAField(23,"Active Resource","string","Active Resource,Variant.STRING,-1,-1,");
		format[24] = new RapidRMAField(24,"Deadline Type","string","Deadline Type,Variant.STRING,-1,-1,");
		format[25] = new RapidRMAField(25,"Instances","int","Instances,Variant.INT,-1,-1,");
		format[26] = new RapidRMAField(26,"Task Server","string","Task Server,Variant.STRING,-1,-1,");
		format[27] = new RapidRMAField(27,"Comments","string","Comments,Variant.STRING,-1,-1,");
		format[28] = new RapidRMAField(28,"Spare Capacity Calc Required","boolean","Spare Capacity Calc Required,Variant.BOOLEAN,-1,-1,");
		format[29] = new RapidRMAField(29,"X Coord","int","X Coord,Variant.INT,-1,-1,");
		format[30] = new RapidRMAField(30,"Y Coord","int","Y Coord,Variant.INT,-1,-1,");
		
		this.initFields(format);
	}
	
	protected String getSchemaFilename() {
		return SCHEMA_FILENAME;
	}}
