package com.thalesgroup.marte.rapidrma.export.actions;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class TG_ID_Format extends RapidRMAFormat{

	static String CATEGORY = "id";
	static String EXTENSION = "tgX";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "-" + CATEGORY + "." + EXTENSION;
	static String SCHEMA_FILENAME = RapidRMAFormat.PROJECT_NAME + "-"+ CATEGORY + ".schema";
	
	/**
	 * TG_ID_Format default constructor.
	 * 
	 */
	public TG_ID_Format() {
		RapidRMAField[] format = new RapidRMAField[8];
		format[0] = new RapidRMAField(0,"Index","int","Index,Variant.INT,-1,-1,");
		format[1] = new RapidRMAField(1,"Task ID","string","Task ID,Variant.STRING,-1,-1,");
		format[2] = new RapidRMAField(2,"Deadline ID","string","Deadline ID,Variant.STRING,-1,-1,");
		format[3] = new RapidRMAField(3,"Work","int","Work,Variant.INT,-1,-1,");
		format[4] = new RapidRMAField(4,"Start Time","int","Start Time,Variant.INT,-1,-1,");
		format[5] = new RapidRMAField(5,"End Time","int","End Time,Variant.INT,-1,-1,");
		format[6] = new RapidRMAField(6,"Deadline","int","Deadline,Variant.INT,-1,-1,");
		format[7] = new RapidRMAField(7,"Rel Deadline","int","Rel Deadline,Variant.INT,-1,-1,");
		this.initFields(format);
	}
	
	protected String getSchemaFilename() {
		return SCHEMA_FILENAME;
	}
}
