package com.thalesgroup.marte.rapidrma.export.actions;

/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 */

/**
 * This class is used to describe the RapidRMA files format
 * 
 * @author Eric MAES (Thales Research & Technology)
 * @version 1.0 - 02/08/2007
 */
public class TG_PS_Format extends RapidRMAFormat{

	static String CATEGORY = "ps";
	static String EXTENSION = "tgX";
	static String FILENAME = RapidRMAFormat.PROJECT_NAME + "-" + CATEGORY + "." + EXTENSION;
	static String SCHEMA_FILENAME = RapidRMAFormat.PROJECT_NAME + "-"+ CATEGORY + ".schema";
	
	/**
	 * TG_PS_Format default constructor.
	 * 
	 */
	public TG_PS_Format() {
		RapidRMAField[] format = new RapidRMAField[14];
		format[0] = new RapidRMAField(0,"Index","int","Index,Variant.INT,-1,-1,");
		format[1] = new RapidRMAField(1,"Server ID","string","Server ID,Variant.STRING,-1,-1,");
		format[2] = new RapidRMAField(2,"Server Name","string","Server Name,Variant.STRING,-1,-1,");
		format[3] = new RapidRMAField(3,"Period","int","Period,Variant.INT,-1,-1,");
		format[4] = new RapidRMAField(4,"Execution Budget","int","Execution Budget,Variant.INT,-1,-1,");
		format[5] = new RapidRMAField(5,"Relative Deadline","int","Relative Deadline,Variant.INT,-1,-1,");
		format[6] = new RapidRMAField(6,"Phase","int","Phase,Variant.INT,-1,-1,");
		format[7] = new RapidRMAField(7,"Priority","int","Priority,Variant.INT,-1,-1,");
		format[8] = new RapidRMAField(8,"Active Resource","string","Active Resource,Variant.STRING,-1,-1,");
		format[9] = new RapidRMAField(9,"Server Type","string","Server Type,Variant.STRING,-1,-1,");
		format[10] = new RapidRMAField(10,"Server Queuing","string","Server Queuing,Variant.STRING,-1,-1,");
		format[11] = new RapidRMAField(11,"Spare Capacity Calc Required","boolean","Spare Capacity Calc Required,Variant.BOOLEAN,-1,-1,");
		format[12] = new RapidRMAField(12,"X Coord","int","X Coord,Variant.INT,-1,-1,");
		format[13] = new RapidRMAField(13,"Y Coord","int","Y Coord,Variant.INT,-1,-1,");
		this.initFields(format);
	}

	protected String getSchemaFilename() {
		return SCHEMA_FILENAME;
	}
}
