/** 
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 **/

package com.thalesgroup.marte2rapidrma.popup.actions;

import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * Uses ATL to check the well-formedness of MARTE models before triggering the transformation
 */
public class RapidRMACheck implements IObjectActionDelegate {

	/**
	 * ATL file default path
	 */
	private static final URL TRANSFO_URL = RapidRMACheck.class.getResource("/ATL/RapidRMACheck.asm");
	
	/**
	 * Selected file descriptor
	 */
	private IFile selectedFile;
	
	/**
	 * RapidRMACheck default constructor
	 */
	public RapidRMACheck() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		try {
			Log.verboseMessage(Activator.PLUGIN_ID,"MARTE Check model");
			if (TRANSFO_URL==null) {
				Log.errorMessage(Activator.PLUGIN_ID,"Invalid ATL File", new Exception());
			}
			else {
				new ProgressMonitorDialog(new Shell()).run(true, false, new RapidRMACheckTransform(TRANSFO_URL,selectedFile));
			}
		}
		catch (Exception e) {
			Log.errorMessage(Activator.PLUGIN_ID, "Error while checking the model", e);
		}
		Log.demoMessage(Activator.PLUGIN_ID, "Checking of the MARTE RSA model "+selectedFile.getName());
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		try {
			selectedFile = (IFile) ((TreeSelection) selection).getFirstElement();
		}
		catch (Exception e) {
			Log.errorMessage(Activator.PLUGIN_ID, "Error in file selection", e);
		}
	}

}
