/** 
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 **/

package com.thalesgroup.marte2rapidrma.popup.actions;

import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.thalesgroup.java.log.Log;
import com.thalesgroup.marte.rapidrma.export.Activator;

/**
 * Uses ATL to transform MARTE models into RapidRMA models
 */
public class RapidRMAExport implements IObjectActionDelegate {

	/**
	 * ATL transformation default URL
	 */
	private static final URL TRANSFO_URL = RapidRMAExport.class.getResource("/ATL/MARTE2RapidRMA.asm");
	
	/**
	 * Selected file descriptor
	 */
	private IFile selectedFile;
	
	/**
	 * RapidRMAExport default onstructor.
	 */
	public RapidRMAExport() {
		super();
	}

	/**
	 * Sets the active Workbench part
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * Executes the transformation
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		run();
	}

	/**
	 * Executes the transformation
	 */
	public void run() {
		try {
			Log.verboseMessage(Activator.PLUGIN_ID,"MARTE Export");
			if (TRANSFO_URL==null) {
				Log.errorMessage(Activator.PLUGIN_ID,"Invalid ATL File", new Exception());
			}
			else {
				new ProgressMonitorDialog(new Shell()).run(true, false, new MARTE2RapidRMATransform(TRANSFO_URL,selectedFile,selectedFile.getLocation().removeLastSegments(1).toString()));
				selectedFile.getParent().refreshLocal(1, null);
			}
		}
		catch (Exception e) {
			Log.errorMessage(Activator.PLUGIN_ID, "Error while transformation of the model", e);
		}
		Log.demoMessage(Activator.PLUGIN_ID, "Transformation of the MARTE RSA model "+selectedFile.getName()+" to the RapidRMA model "+selectedFile.getLocation().toString()+".rapidRMA OK");
	}

	/**
	 * Callback triggered when the selection gets changed
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		try {
			selectedFile = (IFile) ((TreeSelection) selection).getFirstElement();
		}
		catch (Exception e) {
			Log.errorMessage(Activator.PLUGIN_ID, "Error in file selection", e);
		}
	}
}
