/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ChoiceSpecification.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Choice Specification</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.ChoiceSpecification#getChoiceAttribute <em>Choice Attribute</em>}</li>
 *   <li>{@link VSL.ChoiceSpecification#getChosenAlternative <em>Chosen Alternative</em>}</li>
 *   <li>{@link VSL.ChoiceSpecification#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getChoiceSpecification()
 * @model
 * @generated
 */
public interface ChoiceSpecification extends ValueSpecification {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Choice Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Choice Attribute</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Choice Attribute</em>' reference.
	 * @see #setChoiceAttribute(Property)
	 * @see VSL.VSLPackage#getChoiceSpecification_ChoiceAttribute()
	 * @model
	 * @generated
	 */
	Property getChoiceAttribute();

	/**
	 * Sets the value of the '{@link VSL.ChoiceSpecification#getChoiceAttribute <em>Choice Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Choice Attribute</em>' reference.
	 * @see #getChoiceAttribute()
	 * @generated
	 */
	void setChoiceAttribute(Property value);

	/**
	 * Returns the value of the '<em><b>Chosen Alternative</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Chosen Alternative</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Chosen Alternative</em>' attribute.
	 * @see #setChosenAlternative(String)
	 * @see VSL.VSLPackage#getChoiceSpecification_ChosenAlternative()
	 * @model dataType="org.eclipse.uml2.uml.String" derived="true"
	 * @generated
	 */
	String getChosenAlternative();

	/**
	 * Sets the value of the '{@link VSL.ChoiceSpecification#getChosenAlternative <em>Chosen Alternative</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Chosen Alternative</em>' attribute.
	 * @see #getChosenAlternative()
	 * @generated
	 */
	void setChosenAlternative(String value);

	/**
	 * Returns the value of the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value</em>' containment reference.
	 * @see #setValue(ValueSpecification)
	 * @see VSL.VSLPackage#getChoiceSpecification_Value()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getValue();

	/**
	 * Sets the value of the '{@link VSL.ChoiceSpecification#getValue <em>Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value</em>' containment reference.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(ValueSpecification value);

} // ChoiceSpecification