/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ChoiceType.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.emf.common.util.EList;

import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Choice Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.ChoiceType#getDefaultAttribute <em>Default Attribute</em>}</li>
 *   <li>{@link VSL.ChoiceType#getChoiceAttributes <em>Choice Attributes</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getChoiceType()
 * @model
 * @generated
 */
public interface ChoiceType extends CompositeType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Default Attribute</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Attribute</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Attribute</em>' containment reference.
	 * @see #setDefaultAttribute(Property)
	 * @see VSL.VSLPackage#getChoiceType_DefaultAttribute()
	 * @model containment="true"
	 * @generated
	 */
	Property getDefaultAttribute();

	/**
	 * Sets the value of the '{@link VSL.ChoiceType#getDefaultAttribute <em>Default Attribute</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Attribute</em>' containment reference.
	 * @see #getDefaultAttribute()
	 * @generated
	 */
	void setDefaultAttribute(Property value);

	/**
	 * Returns the value of the '<em><b>Choice Attributes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.uml2.uml.Property}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Choice Attributes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Choice Attributes</em>' containment reference list.
	 * @see VSL.VSLPackage#getChoiceType_ChoiceAttributes()
	 * @model type="org.eclipse.uml2.uml.Property" containment="true"
	 * @generated
	 */
	EList getChoiceAttributes();

} // ChoiceType