/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: IntervalSpecification.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Interval Specification</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.IntervalSpecification#isIsLowerOpen <em>Is Lower Open</em>}</li>
 *   <li>{@link VSL.IntervalSpecification#isIsUpperOpen <em>Is Upper Open</em>}</li>
 *   <li>{@link VSL.IntervalSpecification#getMin <em>Min</em>}</li>
 *   <li>{@link VSL.IntervalSpecification#getMax <em>Max</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getIntervalSpecification()
 * @model
 * @generated
 */
public interface IntervalSpecification extends ValueSpecification {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Is Lower Open</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Lower Open</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Lower Open</em>' attribute.
	 * @see #setIsLowerOpen(boolean)
	 * @see VSL.VSLPackage#getIntervalSpecification_IsLowerOpen()
	 * @model dataType="org.eclipse.uml2.uml.Boolean"
	 * @generated
	 */
	boolean isIsLowerOpen();

	/**
	 * Sets the value of the '{@link VSL.IntervalSpecification#isIsLowerOpen <em>Is Lower Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Lower Open</em>' attribute.
	 * @see #isIsLowerOpen()
	 * @generated
	 */
	void setIsLowerOpen(boolean value);

	/**
	 * Returns the value of the '<em><b>Is Upper Open</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Upper Open</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Upper Open</em>' attribute.
	 * @see #setIsUpperOpen(boolean)
	 * @see VSL.VSLPackage#getIntervalSpecification_IsUpperOpen()
	 * @model dataType="org.eclipse.uml2.uml.Boolean"
	 * @generated
	 */
	boolean isIsUpperOpen();

	/**
	 * Sets the value of the '{@link VSL.IntervalSpecification#isIsUpperOpen <em>Is Upper Open</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Upper Open</em>' attribute.
	 * @see #isIsUpperOpen()
	 * @generated
	 */
	void setIsUpperOpen(boolean value);

	/**
	 * Returns the value of the '<em><b>Min</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Min</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Min</em>' containment reference.
	 * @see #setMin(ValueSpecification)
	 * @see VSL.VSLPackage#getIntervalSpecification_Min()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getMin();

	/**
	 * Sets the value of the '{@link VSL.IntervalSpecification#getMin <em>Min</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Min</em>' containment reference.
	 * @see #getMin()
	 * @generated
	 */
	void setMin(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>Max</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Max</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Max</em>' containment reference.
	 * @see #setMax(ValueSpecification)
	 * @see VSL.VSLPackage#getIntervalSpecification_Max()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getMax();

	/**
	 * Sets the value of the '{@link VSL.IntervalSpecification#getMax <em>Max</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max</em>' containment reference.
	 * @see #getMax()
	 * @generated
	 */
	void setMax(ValueSpecification value);

} // IntervalSpecification