/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ObsCallExpression.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Obs Call Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.ObsCallExpression#getObservation <em>Observation</em>}</li>
 *   <li>{@link VSL.ObsCallExpression#getOccurIndexExpr <em>Occur Index Expr</em>}</li>
 *   <li>{@link VSL.ObsCallExpression#getConditionExpr <em>Condition Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getObsCallExpression()
 * @model
 * @generated
 */
public interface ObsCallExpression extends ValueSpecification {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Observation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Observation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Observation</em>' reference.
	 * @see #setObservation(Observation)
	 * @see VSL.VSLPackage#getObsCallExpression_Observation()
	 * @model required="true"
	 * @generated
	 */
	Observation getObservation();

	/**
	 * Sets the value of the '{@link VSL.ObsCallExpression#getObservation <em>Observation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Observation</em>' reference.
	 * @see #getObservation()
	 * @generated
	 */
	void setObservation(Observation value);

	/**
	 * Returns the value of the '<em><b>Occur Index Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Occur Index Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Occur Index Expr</em>' containment reference.
	 * @see #setOccurIndexExpr(ValueSpecification)
	 * @see VSL.VSLPackage#getObsCallExpression_OccurIndexExpr()
	 * @model containment="true"
	 * @generated
	 */
	ValueSpecification getOccurIndexExpr();

	/**
	 * Sets the value of the '{@link VSL.ObsCallExpression#getOccurIndexExpr <em>Occur Index Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Occur Index Expr</em>' containment reference.
	 * @see #getOccurIndexExpr()
	 * @generated
	 */
	void setOccurIndexExpr(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>Condition Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Condition Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Condition Expr</em>' containment reference.
	 * @see #setConditionExpr(ValueSpecification)
	 * @see VSL.VSLPackage#getObsCallExpression_ConditionExpr()
	 * @model containment="true"
	 * @generated
	 */
	ValueSpecification getConditionExpr();

	/**
	 * Sets the value of the '{@link VSL.ObsCallExpression#getConditionExpr <em>Condition Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition Expr</em>' containment reference.
	 * @see #getConditionExpr()
	 * @generated
	 */
	void setConditionExpr(ValueSpecification value);

} // ObsCallExpression