/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: TupleItemValue.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Tuple Item Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.TupleItemValue#getItemValue <em>Item Value</em>}</li>
 *   <li>{@link VSL.TupleItemValue#getTupleItemName <em>Tuple Item Name</em>}</li>
 *   <li>{@link VSL.TupleItemValue#getTupleAttribute <em>Tuple Attribute</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getTupleItemValue()
 * @model
 * @generated
 */
public interface TupleItemValue extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Item Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Item Value</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Item Value</em>' containment reference.
	 * @see #setItemValue(ValueSpecification)
	 * @see VSL.VSLPackage#getTupleItemValue_ItemValue()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ValueSpecification getItemValue();

	/**
	 * Sets the value of the '{@link VSL.TupleItemValue#getItemValue <em>Item Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Item Value</em>' containment reference.
	 * @see #getItemValue()
	 * @generated
	 */
	void setItemValue(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>Tuple Item Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Tuple Item Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tuple Item Name</em>' attribute.
	 * @see #setTupleItemName(String)
	 * @see VSL.VSLPackage#getTupleItemValue_TupleItemName()
	 * @model dataType="org.eclipse.uml2.uml.String" derived="true"
	 * @generated
	 */
	String getTupleItemName();

	/**
	 * Sets the value of the '{@link VSL.TupleItemValue#getTupleItemName <em>Tuple Item Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tuple Item Name</em>' attribute.
	 * @see #getTupleItemName()
	 * @generated
	 */
	void setTupleItemName(String value);

	/**
	 * Returns the value of the '<em><b>Tuple Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Tuple Attribute</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tuple Attribute</em>' reference.
	 * @see #setTupleAttribute(Property)
	 * @see VSL.VSLPackage#getTupleItemValue_TupleAttribute()
	 * @model required="true"
	 * @generated
	 */
	Property getTupleAttribute();

	/**
	 * Sets the value of the '{@link VSL.TupleItemValue#getTupleAttribute <em>Tuple Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tuple Attribute</em>' reference.
	 * @see #getTupleAttribute()
	 * @generated
	 */
	void setTupleAttribute(Property value);

} // TupleItemValue