/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: Variable.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Variable</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.Variable#getInitExpression <em>Init Expression</em>}</li>
 *   <li>{@link VSL.Variable#getDirection <em>Direction</em>}</li>
 *   <li>{@link VSL.Variable#getDataTypeName <em>Data Type Name</em>}</li>
 *   <li>{@link VSL.Variable#getContext <em>Context</em>}</li>
 *   <li>{@link VSL.Variable#getDatatype <em>Datatype</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getVariable()
 * @model
 * @generated
 */
public interface Variable extends Expression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Init Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Init Expression</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Init Expression</em>' containment reference.
	 * @see #setInitExpression(ValueSpecification)
	 * @see VSL.VSLPackage#getVariable_InitExpression()
	 * @model containment="true"
	 * @generated
	 */
	ValueSpecification getInitExpression();

	/**
	 * Sets the value of the '{@link VSL.Variable#getInitExpression <em>Init Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Init Expression</em>' containment reference.
	 * @see #getInitExpression()
	 * @generated
	 */
	void setInitExpression(ValueSpecification value);

	/**
	 * Returns the value of the '<em><b>Direction</b></em>' attribute.
	 * The literals are from the enumeration {@link VSL.VariableDirectionKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Direction</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Direction</em>' attribute.
	 * @see VSL.VariableDirectionKind
	 * @see #setDirection(VariableDirectionKind)
	 * @see VSL.VSLPackage#getVariable_Direction()
	 * @model
	 * @generated
	 */
	VariableDirectionKind getDirection();

	/**
	 * Sets the value of the '{@link VSL.Variable#getDirection <em>Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Direction</em>' attribute.
	 * @see VSL.VariableDirectionKind
	 * @see #getDirection()
	 * @generated
	 */
	void setDirection(VariableDirectionKind value);

	/**
	 * Returns the value of the '<em><b>Data Type Name</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Data Type Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Type Name</em>' attribute.
	 * @see #setDataTypeName(String)
	 * @see VSL.VSLPackage#getVariable_DataTypeName()
	 * @model default="" dataType="org.eclipse.uml2.uml.String" derived="true"
	 * @generated
	 */
	String getDataTypeName();

	/**
	 * Sets the value of the '{@link VSL.Variable#getDataTypeName <em>Data Type Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Data Type Name</em>' attribute.
	 * @see #getDataTypeName()
	 * @generated
	 */
	void setDataTypeName(String value);

	/**
	 * Returns the value of the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Context</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Context</em>' reference.
	 * @see #setContext(ExpressionContext)
	 * @see VSL.VSLPackage#getVariable_Context()
	 * @model
	 * @generated
	 */
	ExpressionContext getContext();

	/**
	 * Sets the value of the '{@link VSL.Variable#getContext <em>Context</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context</em>' reference.
	 * @see #getContext()
	 * @generated
	 */
	void setContext(ExpressionContext value);

	/**
	 * Returns the value of the '<em><b>Datatype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Datatype</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Datatype</em>' reference.
	 * @see #setDatatype(DataType)
	 * @see VSL.VSLPackage#getVariable_Datatype()
	 * @model
	 * @generated
	 */
	DataType getDatatype();

	/**
	 * Sets the value of the '{@link VSL.Variable#getDatatype <em>Datatype</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Datatype</em>' reference.
	 * @see #getDatatype()
	 * @generated
	 */
	void setDatatype(DataType value);

} // Variable