/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VariableCallExpression.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL;

import org.eclipse.uml2.uml.Expression;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Variable Call Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link VSL.VariableCallExpression#getVariable <em>Variable</em>}</li>
 *   <li>{@link VSL.VariableCallExpression#getDefiningVariable <em>Defining Variable</em>}</li>
 * </ul>
 * </p>
 *
 * @see VSL.VSLPackage#getVariableCallExpression()
 * @model
 * @generated
 */
public interface VariableCallExpression extends Expression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Variable</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Variable</em>' attribute.
	 * @see #setVariable(String)
	 * @see VSL.VSLPackage#getVariableCallExpression_Variable()
	 * @model dataType="org.eclipse.uml2.uml.String" derived="true"
	 * @generated
	 */
	String getVariable();

	/**
	 * Sets the value of the '{@link VSL.VariableCallExpression#getVariable <em>Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Variable</em>' attribute.
	 * @see #getVariable()
	 * @generated
	 */
	void setVariable(String value);

	/**
	 * Returns the value of the '<em><b>Defining Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Defining Variable</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Defining Variable</em>' reference.
	 * @see #setDefiningVariable(Variable)
	 * @see VSL.VSLPackage#getVariableCallExpression_DefiningVariable()
	 * @model required="true" derived="true"
	 * @generated
	 */
	Variable getDefiningVariable();

	/**
	 * Sets the value of the '{@link VSL.VariableCallExpression#getDefiningVariable <em>Defining Variable</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Defining Variable</em>' reference.
	 * @see #getDefiningVariable()
	 * @generated
	 */
	void setDefiningVariable(Variable value);

} // VariableCallExpression