/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ChoiceSpecificationImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.impl.ValueSpecificationImpl;

import VSL.ChoiceSpecification;
import VSL.VSLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Choice Specification</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.ChoiceSpecificationImpl#getChoiceAttribute <em>Choice Attribute</em>}</li>
 *   <li>{@link VSL.impl.ChoiceSpecificationImpl#getChosenAlternative <em>Chosen Alternative</em>}</li>
 *   <li>{@link VSL.impl.ChoiceSpecificationImpl#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ChoiceSpecificationImpl extends ValueSpecificationImpl implements ChoiceSpecification {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getChoiceAttribute() <em>Choice Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChoiceAttribute()
	 * @generated
	 * @ordered
	 */
	protected Property choiceAttribute = null;

	/**
	 * The default value of the '{@link #getChosenAlternative() <em>Chosen Alternative</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChosenAlternative()
	 * @generated
	 * @ordered
	 */
	protected static final String CHOSEN_ALTERNATIVE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getChosenAlternative() <em>Chosen Alternative</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChosenAlternative()
	 * @generated
	 * @ordered
	 */
	protected String chosenAlternative = CHOSEN_ALTERNATIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification value = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChoiceSpecificationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.CHOICE_SPECIFICATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property getChoiceAttribute() {
		if (choiceAttribute != null && choiceAttribute.eIsProxy()) {
			InternalEObject oldChoiceAttribute = (InternalEObject)choiceAttribute;
			choiceAttribute = (Property)eResolveProxy(oldChoiceAttribute);
			if (choiceAttribute != oldChoiceAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE, oldChoiceAttribute, choiceAttribute));
			}
		}
		return choiceAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property basicGetChoiceAttribute() {
		return choiceAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setChoiceAttribute(Property newChoiceAttribute) {
		Property oldChoiceAttribute = choiceAttribute;
		choiceAttribute = newChoiceAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE, oldChoiceAttribute, choiceAttribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getChosenAlternative() {
		return chosenAlternative;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setChosenAlternative(String newChosenAlternative) {
		String oldChosenAlternative = chosenAlternative;
		chosenAlternative = newChosenAlternative;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_SPECIFICATION__CHOSEN_ALTERNATIVE, oldChosenAlternative, chosenAlternative));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetValue(ValueSpecification newValue, NotificationChain msgs) {
		ValueSpecification oldValue = value;
		value = newValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_SPECIFICATION__VALUE, oldValue, newValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(ValueSpecification newValue) {
		if (newValue != value) {
			NotificationChain msgs = null;
			if (value != null)
				msgs = ((InternalEObject)value).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.CHOICE_SPECIFICATION__VALUE, null, msgs);
			if (newValue != null)
				msgs = ((InternalEObject)newValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.CHOICE_SPECIFICATION__VALUE, null, msgs);
			msgs = basicSetValue(newValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.CHOICE_SPECIFICATION__VALUE, newValue, newValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VSLPackage.CHOICE_SPECIFICATION__VALUE:
				return basicSetValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE:
				if (resolve) return getChoiceAttribute();
				return basicGetChoiceAttribute();
			case VSLPackage.CHOICE_SPECIFICATION__CHOSEN_ALTERNATIVE:
				return getChosenAlternative();
			case VSLPackage.CHOICE_SPECIFICATION__VALUE:
				return getValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE:
				setChoiceAttribute((Property)newValue);
				return;
			case VSLPackage.CHOICE_SPECIFICATION__CHOSEN_ALTERNATIVE:
				setChosenAlternative((String)newValue);
				return;
			case VSLPackage.CHOICE_SPECIFICATION__VALUE:
				setValue((ValueSpecification)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE:
				setChoiceAttribute((Property)null);
				return;
			case VSLPackage.CHOICE_SPECIFICATION__CHOSEN_ALTERNATIVE:
				setChosenAlternative(CHOSEN_ALTERNATIVE_EDEFAULT);
				return;
			case VSLPackage.CHOICE_SPECIFICATION__VALUE:
				setValue((ValueSpecification)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.CHOICE_SPECIFICATION__CHOICE_ATTRIBUTE:
				return choiceAttribute != null;
			case VSLPackage.CHOICE_SPECIFICATION__CHOSEN_ALTERNATIVE:
				return CHOSEN_ALTERNATIVE_EDEFAULT == null ? chosenAlternative != null : !CHOSEN_ALTERNATIVE_EDEFAULT.equals(chosenAlternative);
			case VSLPackage.CHOICE_SPECIFICATION__VALUE:
				return value != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (chosenAlternative: ");
		result.append(chosenAlternative);
		result.append(')');
		return result.toString();
	}

} //ChoiceSpecificationImpl