/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: ObsCallExpressionImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.ObsCallExpression;
import VSL.VSLPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.ValueSpecification;

import org.eclipse.uml2.uml.internal.impl.ValueSpecificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Obs Call Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.ObsCallExpressionImpl#getObservation <em>Observation</em>}</li>
 *   <li>{@link VSL.impl.ObsCallExpressionImpl#getOccurIndexExpr <em>Occur Index Expr</em>}</li>
 *   <li>{@link VSL.impl.ObsCallExpressionImpl#getConditionExpr <em>Condition Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ObsCallExpressionImpl extends ValueSpecificationImpl implements ObsCallExpression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getObservation() <em>Observation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObservation()
	 * @generated
	 * @ordered
	 */
	protected Observation observation = null;

	/**
	 * The cached value of the '{@link #getOccurIndexExpr() <em>Occur Index Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOccurIndexExpr()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification occurIndexExpr = null;

	/**
	 * The cached value of the '{@link #getConditionExpr() <em>Condition Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditionExpr()
	 * @generated
	 * @ordered
	 */
	protected ValueSpecification conditionExpr = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ObsCallExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.OBS_CALL_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Observation getObservation() {
		if (observation != null && observation.eIsProxy()) {
			InternalEObject oldObservation = (InternalEObject)observation;
			observation = (Observation)eResolveProxy(oldObservation);
			if (observation != oldObservation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION, oldObservation, observation));
			}
		}
		return observation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Observation basicGetObservation() {
		return observation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObservation(Observation newObservation) {
		Observation oldObservation = observation;
		observation = newObservation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION, oldObservation, observation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getOccurIndexExpr() {
		return occurIndexExpr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOccurIndexExpr(ValueSpecification newOccurIndexExpr, NotificationChain msgs) {
		ValueSpecification oldOccurIndexExpr = occurIndexExpr;
		occurIndexExpr = newOccurIndexExpr;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR, oldOccurIndexExpr, newOccurIndexExpr);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOccurIndexExpr(ValueSpecification newOccurIndexExpr) {
		if (newOccurIndexExpr != occurIndexExpr) {
			NotificationChain msgs = null;
			if (occurIndexExpr != null)
				msgs = ((InternalEObject)occurIndexExpr).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR, null, msgs);
			if (newOccurIndexExpr != null)
				msgs = ((InternalEObject)newOccurIndexExpr).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR, null, msgs);
			msgs = basicSetOccurIndexExpr(newOccurIndexExpr, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR, newOccurIndexExpr, newOccurIndexExpr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueSpecification getConditionExpr() {
		return conditionExpr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConditionExpr(ValueSpecification newConditionExpr, NotificationChain msgs) {
		ValueSpecification oldConditionExpr = conditionExpr;
		conditionExpr = newConditionExpr;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR, oldConditionExpr, newConditionExpr);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConditionExpr(ValueSpecification newConditionExpr) {
		if (newConditionExpr != conditionExpr) {
			NotificationChain msgs = null;
			if (conditionExpr != null)
				msgs = ((InternalEObject)conditionExpr).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR, null, msgs);
			if (newConditionExpr != null)
				msgs = ((InternalEObject)newConditionExpr).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR, null, msgs);
			msgs = basicSetConditionExpr(newConditionExpr, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR, newConditionExpr, newConditionExpr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR:
				return basicSetOccurIndexExpr(null, msgs);
			case VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR:
				return basicSetConditionExpr(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION:
				if (resolve) return getObservation();
				return basicGetObservation();
			case VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR:
				return getOccurIndexExpr();
			case VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR:
				return getConditionExpr();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION:
				setObservation((Observation)newValue);
				return;
			case VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR:
				setOccurIndexExpr((ValueSpecification)newValue);
				return;
			case VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR:
				setConditionExpr((ValueSpecification)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION:
				setObservation((Observation)null);
				return;
			case VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR:
				setOccurIndexExpr((ValueSpecification)null);
				return;
			case VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR:
				setConditionExpr((ValueSpecification)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.OBS_CALL_EXPRESSION__OBSERVATION:
				return observation != null;
			case VSLPackage.OBS_CALL_EXPRESSION__OCCUR_INDEX_EXPR:
				return occurIndexExpr != null;
			case VSLPackage.OBS_CALL_EXPRESSION__CONDITION_EXPR:
				return conditionExpr != null;
		}
		return super.eIsSet(featureID);
	}

} //ObsCallExpressionImpl