/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: PropertyCallExpressionImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.PropertyCallExpression;
import VSL.VSLPackage;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.Property;

import org.eclipse.uml2.uml.internal.impl.ExpressionImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Property Call Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link VSL.impl.PropertyCallExpressionImpl#getDefiningProperty <em>Defining Property</em>}</li>
 *   <li>{@link VSL.impl.PropertyCallExpressionImpl#getProperty <em>Property</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PropertyCallExpressionImpl extends ExpressionImpl implements PropertyCallExpression {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached value of the '{@link #getDefiningProperty() <em>Defining Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefiningProperty()
	 * @generated
	 * @ordered
	 */
	protected Property definingProperty = null;

	/**
	 * The default value of the '{@link #getProperty() <em>Property</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperty()
	 * @generated
	 * @ordered
	 */
	protected static final String PROPERTY_EDEFAULT = "";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyCallExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return VSLPackage.Literals.PROPERTY_CALL_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property getDefiningProperty() {
		if (definingProperty != null && definingProperty.eIsProxy()) {
			InternalEObject oldDefiningProperty = (InternalEObject)definingProperty;
			definingProperty = (Property)eResolveProxy(oldDefiningProperty);
			if (definingProperty != oldDefiningProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
			}
		}
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Property basicGetDefiningProperty() {
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefiningProperty(Property newDefiningProperty) {
		Property oldDefiningProperty = definingProperty;
		definingProperty = newDefiningProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProperty() {
		// TODO: implement this method to return the 'Property' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProperty(String newProperty) {
		// TODO: implement this method to set the 'Property' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY:
				if (resolve) return getDefiningProperty();
				return basicGetDefiningProperty();
			case VSLPackage.PROPERTY_CALL_EXPRESSION__PROPERTY:
				return getProperty();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY:
				setDefiningProperty((Property)newValue);
				return;
			case VSLPackage.PROPERTY_CALL_EXPRESSION__PROPERTY:
				setProperty((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY:
				setDefiningProperty((Property)null);
				return;
			case VSLPackage.PROPERTY_CALL_EXPRESSION__PROPERTY:
				setProperty(PROPERTY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VSLPackage.PROPERTY_CALL_EXPRESSION__DEFINING_PROPERTY:
				return definingProperty != null;
			case VSLPackage.PROPERTY_CALL_EXPRESSION__PROPERTY:
				return PROPERTY_EDEFAULT == null ? getProperty() != null : !PROPERTY_EDEFAULT.equals(getProperty());
		}
		return super.eIsSet(featureID);
	}

} //PropertyCallExpressionImpl