/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSLFactoryImpl.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.impl;

import VSL.*;

import com.thalesgroup.marte.vsl.VSLDate;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class VSLFactoryImpl extends EFactoryImpl implements VSLFactory {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static VSLFactory init() {
		try {
			VSLFactory theVSLFactory = (VSLFactory)EPackage.Registry.INSTANCE.getEFactory("MARTE::VSL"); 
			if (theVSLFactory != null) {
				return theVSLFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new VSLFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VSLFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case VSLPackage.SUBTYPE: return createSubtype();
			case VSLPackage.BOUNDED_SUBTYPE: return createBoundedSubtype();
			case VSLPackage.COMPOSITE_TYPE: return createCompositeType();
			case VSLPackage.INTERVAL_TYPE: return createIntervalType();
			case VSLPackage.COLLECTION_TYPE: return createCollectionType();
			case VSLPackage.TUPLE_TYPE: return createTupleType();
			case VSLPackage.CHOICE_TYPE: return createChoiceType();
			case VSLPackage.ENUMERATION_SPECIFICATION: return createEnumerationSpecification();
			case VSLPackage.LITERAL_REAL: return createLiteralReal();
			case VSLPackage.LITERAL_DATE_TIME: return createLiteralDateTime();
			case VSLPackage.LITERAL_DEFAULT: return createLiteralDefault();
			case VSLPackage.VARIABLE_CALL_EXPRESSION: return createVariableCallExpression();
			case VSLPackage.VARIABLE: return createVariable();
			case VSLPackage.EXPRESSION_CONTEXT: return createExpressionContext();
			case VSLPackage.PROPERTY_CALL_EXPRESSION: return createPropertyCallExpression();
			case VSLPackage.OPERATION_CALL_EXPRESSION: return createOperationCallExpression();
			case VSLPackage.CONDITIONAL_EXPRESSION: return createConditionalExpression();
			case VSLPackage.INTERVAL_SPECIFICATION: return createIntervalSpecification();
			case VSLPackage.TUPLE_SPECIFICATION: return createTupleSpecification();
			case VSLPackage.TUPLE_ITEM_VALUE: return createTupleItemValue();
			case VSLPackage.CHOICE_SPECIFICATION: return createChoiceSpecification();
			case VSLPackage.COLLECTION_SPECIFICATION: return createCollectionSpecification();
			case VSLPackage.OBS_CALL_EXPRESSION: return createObsCallExpression();
			case VSLPackage.TIME_EXPRESSION: return createTimeExpression();
			case VSLPackage.INSTANT_EXPRESSION: return createInstantExpression();
			case VSLPackage.DURATION_EXPRESSION: return createDurationExpression();
			case VSLPackage.JITTER_EXPRESSION: return createJitterExpression();
			case VSLPackage.INSTANT_INTERVAL_SPECIFICATION: return createInstantIntervalSpecification();
			case VSLPackage.DURATION_INTERVAL_SPECIFICATION: return createDurationIntervalSpecification();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case VSLPackage.VARIABLE_DIRECTION_KIND:
				return createVariableDirectionKindFromString(eDataType, initialValue);
			case VSLPackage.DATE_TIME:
				return createDateTimeFromString(eDataType, initialValue);
			case VSLPackage.REAL:
				return createRealFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case VSLPackage.VARIABLE_DIRECTION_KIND:
				return convertVariableDirectionKindToString(eDataType, instanceValue);
			case VSLPackage.DATE_TIME:
				return convertDateTimeToString(eDataType, instanceValue);
			case VSLPackage.REAL:
				return convertRealToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Subtype createSubtype() {
		SubtypeImpl subtype = new SubtypeImpl();
		return subtype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BoundedSubtype createBoundedSubtype() {
		BoundedSubtypeImpl boundedSubtype = new BoundedSubtypeImpl();
		return boundedSubtype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompositeType createCompositeType() {
		CompositeTypeImpl compositeType = new CompositeTypeImpl();
		return compositeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalType createIntervalType() {
		IntervalTypeImpl intervalType = new IntervalTypeImpl();
		return intervalType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionType createCollectionType() {
		CollectionTypeImpl collectionType = new CollectionTypeImpl();
		return collectionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TupleType createTupleType() {
		TupleTypeImpl tupleType = new TupleTypeImpl();
		return tupleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ChoiceType createChoiceType() {
		ChoiceTypeImpl choiceType = new ChoiceTypeImpl();
		return choiceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationSpecification createEnumerationSpecification() {
		EnumerationSpecificationImpl enumerationSpecification = new EnumerationSpecificationImpl();
		return enumerationSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralReal createLiteralReal() {
		LiteralRealImpl literalReal = new LiteralRealImpl();
		return literalReal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralDateTime createLiteralDateTime() {
		LiteralDateTimeImpl literalDateTime = new LiteralDateTimeImpl();
		return literalDateTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralDefault createLiteralDefault() {
		LiteralDefaultImpl literalDefault = new LiteralDefaultImpl();
		return literalDefault;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariableCallExpression createVariableCallExpression() {
		VariableCallExpressionImpl variableCallExpression = new VariableCallExpressionImpl();
		return variableCallExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variable createVariable() {
		VariableImpl variable = new VariableImpl();
		return variable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionContext createExpressionContext() {
		ExpressionContextImpl expressionContext = new ExpressionContextImpl();
		return expressionContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PropertyCallExpression createPropertyCallExpression() {
		PropertyCallExpressionImpl propertyCallExpression = new PropertyCallExpressionImpl();
		return propertyCallExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperationCallExpression createOperationCallExpression() {
		OperationCallExpressionImpl operationCallExpression = new OperationCallExpressionImpl();
		return operationCallExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionalExpression createConditionalExpression() {
		ConditionalExpressionImpl conditionalExpression = new ConditionalExpressionImpl();
		return conditionalExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalSpecification createIntervalSpecification() {
		IntervalSpecificationImpl intervalSpecification = new IntervalSpecificationImpl();
		return intervalSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TupleSpecification createTupleSpecification() {
		TupleSpecificationImpl tupleSpecification = new TupleSpecificationImpl();
		return tupleSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TupleItemValue createTupleItemValue() {
		TupleItemValueImpl tupleItemValue = new TupleItemValueImpl();
		return tupleItemValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ChoiceSpecification createChoiceSpecification() {
		ChoiceSpecificationImpl choiceSpecification = new ChoiceSpecificationImpl();
		return choiceSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollectionSpecification createCollectionSpecification() {
		CollectionSpecificationImpl collectionSpecification = new CollectionSpecificationImpl();
		return collectionSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ObsCallExpression createObsCallExpression() {
		ObsCallExpressionImpl obsCallExpression = new ObsCallExpressionImpl();
		return obsCallExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimeExpression createTimeExpression() {
		TimeExpressionImpl timeExpression = new TimeExpressionImpl();
		return timeExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstantExpression createInstantExpression() {
		InstantExpressionImpl instantExpression = new InstantExpressionImpl();
		return instantExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DurationExpression createDurationExpression() {
		DurationExpressionImpl durationExpression = new DurationExpressionImpl();
		return durationExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JitterExpression createJitterExpression() {
		JitterExpressionImpl jitterExpression = new JitterExpressionImpl();
		return jitterExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstantIntervalSpecification createInstantIntervalSpecification() {
		InstantIntervalSpecificationImpl instantIntervalSpecification = new InstantIntervalSpecificationImpl();
		return instantIntervalSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DurationIntervalSpecification createDurationIntervalSpecification() {
		DurationIntervalSpecificationImpl durationIntervalSpecification = new DurationIntervalSpecificationImpl();
		return durationIntervalSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariableDirectionKind createVariableDirectionKindFromString(EDataType eDataType, String initialValue) {
		VariableDirectionKind result = VariableDirectionKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVariableDirectionKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VSLDate createDateTimeFromString(EDataType eDataType, String initialValue) {
		return (VSLDate)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDateTimeToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double createRealFromString(EDataType eDataType, String initialValue) {
		return (Double)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRealToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VSLPackage getVSLPackage() {
		return (VSLPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static VSLPackage getPackage() {
		return VSLPackage.eINSTANCE;
	}

} //VSLFactoryImpl
