/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSLSwitch.java,v 1.2 2007/10/15 09:30:32 fnizou Exp $
 */
package VSL.util;

import VSL.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see VSL.VSLPackage
 * @generated
 */
public class VSLSwitch {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright 2007 Thales Research & Technology";

	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static VSLPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VSLSwitch() {
		if (modelPackage == null) {
			modelPackage = VSLPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case VSLPackage.SUBTYPE: {
				Subtype subtype = (Subtype)theEObject;
				Object result = caseSubtype(subtype);
				if (result == null) result = caseDataType(subtype);
				if (result == null) result = caseClassifier(subtype);
				if (result == null) result = caseNamespace(subtype);
				if (result == null) result = caseRedefinableElement(subtype);
				if (result == null) result = caseType(subtype);
				if (result == null) result = caseTemplateableElement(subtype);
				if (result == null) result = caseNamedElement(subtype);
				if (result == null) result = casePackageableElement(subtype);
				if (result == null) result = caseElement(subtype);
				if (result == null) result = caseParameterableElement(subtype);
				if (result == null) result = caseEModelElement(subtype);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.BOUNDED_SUBTYPE: {
				BoundedSubtype boundedSubtype = (BoundedSubtype)theEObject;
				Object result = caseBoundedSubtype(boundedSubtype);
				if (result == null) result = caseSubtype(boundedSubtype);
				if (result == null) result = caseDataType(boundedSubtype);
				if (result == null) result = caseClassifier(boundedSubtype);
				if (result == null) result = caseNamespace(boundedSubtype);
				if (result == null) result = caseRedefinableElement(boundedSubtype);
				if (result == null) result = caseType(boundedSubtype);
				if (result == null) result = caseTemplateableElement(boundedSubtype);
				if (result == null) result = caseNamedElement(boundedSubtype);
				if (result == null) result = casePackageableElement(boundedSubtype);
				if (result == null) result = caseElement(boundedSubtype);
				if (result == null) result = caseParameterableElement(boundedSubtype);
				if (result == null) result = caseEModelElement(boundedSubtype);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.COMPOSITE_TYPE: {
				CompositeType compositeType = (CompositeType)theEObject;
				Object result = caseCompositeType(compositeType);
				if (result == null) result = caseDataType(compositeType);
				if (result == null) result = caseClassifier(compositeType);
				if (result == null) result = caseNamespace(compositeType);
				if (result == null) result = caseRedefinableElement(compositeType);
				if (result == null) result = caseType(compositeType);
				if (result == null) result = caseTemplateableElement(compositeType);
				if (result == null) result = caseNamedElement(compositeType);
				if (result == null) result = casePackageableElement(compositeType);
				if (result == null) result = caseElement(compositeType);
				if (result == null) result = caseParameterableElement(compositeType);
				if (result == null) result = caseEModelElement(compositeType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.INTERVAL_TYPE: {
				IntervalType intervalType = (IntervalType)theEObject;
				Object result = caseIntervalType(intervalType);
				if (result == null) result = caseCompositeType(intervalType);
				if (result == null) result = caseDataType(intervalType);
				if (result == null) result = caseClassifier(intervalType);
				if (result == null) result = caseNamespace(intervalType);
				if (result == null) result = caseRedefinableElement(intervalType);
				if (result == null) result = caseType(intervalType);
				if (result == null) result = caseTemplateableElement(intervalType);
				if (result == null) result = caseNamedElement(intervalType);
				if (result == null) result = casePackageableElement(intervalType);
				if (result == null) result = caseElement(intervalType);
				if (result == null) result = caseParameterableElement(intervalType);
				if (result == null) result = caseEModelElement(intervalType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.COLLECTION_TYPE: {
				CollectionType collectionType = (CollectionType)theEObject;
				Object result = caseCollectionType(collectionType);
				if (result == null) result = caseCompositeType(collectionType);
				if (result == null) result = caseDataType(collectionType);
				if (result == null) result = caseClassifier(collectionType);
				if (result == null) result = caseNamespace(collectionType);
				if (result == null) result = caseRedefinableElement(collectionType);
				if (result == null) result = caseType(collectionType);
				if (result == null) result = caseTemplateableElement(collectionType);
				if (result == null) result = caseNamedElement(collectionType);
				if (result == null) result = casePackageableElement(collectionType);
				if (result == null) result = caseElement(collectionType);
				if (result == null) result = caseParameterableElement(collectionType);
				if (result == null) result = caseEModelElement(collectionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.TUPLE_TYPE: {
				TupleType tupleType = (TupleType)theEObject;
				Object result = caseTupleType(tupleType);
				if (result == null) result = caseCompositeType(tupleType);
				if (result == null) result = caseDataType(tupleType);
				if (result == null) result = caseClassifier(tupleType);
				if (result == null) result = caseNamespace(tupleType);
				if (result == null) result = caseRedefinableElement(tupleType);
				if (result == null) result = caseType(tupleType);
				if (result == null) result = caseTemplateableElement(tupleType);
				if (result == null) result = caseNamedElement(tupleType);
				if (result == null) result = casePackageableElement(tupleType);
				if (result == null) result = caseElement(tupleType);
				if (result == null) result = caseParameterableElement(tupleType);
				if (result == null) result = caseEModelElement(tupleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.CHOICE_TYPE: {
				ChoiceType choiceType = (ChoiceType)theEObject;
				Object result = caseChoiceType(choiceType);
				if (result == null) result = caseCompositeType(choiceType);
				if (result == null) result = caseDataType(choiceType);
				if (result == null) result = caseClassifier(choiceType);
				if (result == null) result = caseNamespace(choiceType);
				if (result == null) result = caseRedefinableElement(choiceType);
				if (result == null) result = caseType(choiceType);
				if (result == null) result = caseTemplateableElement(choiceType);
				if (result == null) result = caseNamedElement(choiceType);
				if (result == null) result = casePackageableElement(choiceType);
				if (result == null) result = caseElement(choiceType);
				if (result == null) result = caseParameterableElement(choiceType);
				if (result == null) result = caseEModelElement(choiceType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.ENUMERATION_SPECIFICATION: {
				EnumerationSpecification enumerationSpecification = (EnumerationSpecification)theEObject;
				Object result = caseEnumerationSpecification(enumerationSpecification);
				if (result == null) result = caseValueSpecification(enumerationSpecification);
				if (result == null) result = casePackageableElement(enumerationSpecification);
				if (result == null) result = caseTypedElement(enumerationSpecification);
				if (result == null) result = caseNamedElement(enumerationSpecification);
				if (result == null) result = caseParameterableElement(enumerationSpecification);
				if (result == null) result = caseElement(enumerationSpecification);
				if (result == null) result = caseEModelElement(enumerationSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.LITERAL_REAL: {
				LiteralReal literalReal = (LiteralReal)theEObject;
				Object result = caseLiteralReal(literalReal);
				if (result == null) result = caseLiteralSpecification(literalReal);
				if (result == null) result = caseValueSpecification(literalReal);
				if (result == null) result = casePackageableElement(literalReal);
				if (result == null) result = caseTypedElement(literalReal);
				if (result == null) result = caseNamedElement(literalReal);
				if (result == null) result = caseParameterableElement(literalReal);
				if (result == null) result = caseElement(literalReal);
				if (result == null) result = caseEModelElement(literalReal);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.LITERAL_DATE_TIME: {
				LiteralDateTime literalDateTime = (LiteralDateTime)theEObject;
				Object result = caseLiteralDateTime(literalDateTime);
				if (result == null) result = caseLiteralSpecification(literalDateTime);
				if (result == null) result = caseValueSpecification(literalDateTime);
				if (result == null) result = casePackageableElement(literalDateTime);
				if (result == null) result = caseTypedElement(literalDateTime);
				if (result == null) result = caseNamedElement(literalDateTime);
				if (result == null) result = caseParameterableElement(literalDateTime);
				if (result == null) result = caseElement(literalDateTime);
				if (result == null) result = caseEModelElement(literalDateTime);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.LITERAL_DEFAULT: {
				LiteralDefault literalDefault = (LiteralDefault)theEObject;
				Object result = caseLiteralDefault(literalDefault);
				if (result == null) result = caseLiteralSpecification(literalDefault);
				if (result == null) result = caseValueSpecification(literalDefault);
				if (result == null) result = casePackageableElement(literalDefault);
				if (result == null) result = caseTypedElement(literalDefault);
				if (result == null) result = caseNamedElement(literalDefault);
				if (result == null) result = caseParameterableElement(literalDefault);
				if (result == null) result = caseElement(literalDefault);
				if (result == null) result = caseEModelElement(literalDefault);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.VARIABLE_CALL_EXPRESSION: {
				VariableCallExpression variableCallExpression = (VariableCallExpression)theEObject;
				Object result = caseVariableCallExpression(variableCallExpression);
				if (result == null) result = caseExpression(variableCallExpression);
				if (result == null) result = caseValueSpecification(variableCallExpression);
				if (result == null) result = casePackageableElement(variableCallExpression);
				if (result == null) result = caseTypedElement(variableCallExpression);
				if (result == null) result = caseNamedElement(variableCallExpression);
				if (result == null) result = caseParameterableElement(variableCallExpression);
				if (result == null) result = caseElement(variableCallExpression);
				if (result == null) result = caseEModelElement(variableCallExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.VARIABLE: {
				Variable variable = (Variable)theEObject;
				Object result = caseVariable(variable);
				if (result == null) result = caseExpression(variable);
				if (result == null) result = caseValueSpecification(variable);
				if (result == null) result = casePackageableElement(variable);
				if (result == null) result = caseTypedElement(variable);
				if (result == null) result = caseNamedElement(variable);
				if (result == null) result = caseParameterableElement(variable);
				if (result == null) result = caseElement(variable);
				if (result == null) result = caseEModelElement(variable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.EXPRESSION_CONTEXT: {
				ExpressionContext expressionContext = (ExpressionContext)theEObject;
				Object result = caseExpressionContext(expressionContext);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.PROPERTY_CALL_EXPRESSION: {
				PropertyCallExpression propertyCallExpression = (PropertyCallExpression)theEObject;
				Object result = casePropertyCallExpression(propertyCallExpression);
				if (result == null) result = caseExpression(propertyCallExpression);
				if (result == null) result = caseValueSpecification(propertyCallExpression);
				if (result == null) result = casePackageableElement(propertyCallExpression);
				if (result == null) result = caseTypedElement(propertyCallExpression);
				if (result == null) result = caseNamedElement(propertyCallExpression);
				if (result == null) result = caseParameterableElement(propertyCallExpression);
				if (result == null) result = caseElement(propertyCallExpression);
				if (result == null) result = caseEModelElement(propertyCallExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.OPERATION_CALL_EXPRESSION: {
				OperationCallExpression operationCallExpression = (OperationCallExpression)theEObject;
				Object result = caseOperationCallExpression(operationCallExpression);
				if (result == null) result = caseExpression(operationCallExpression);
				if (result == null) result = caseValueSpecification(operationCallExpression);
				if (result == null) result = casePackageableElement(operationCallExpression);
				if (result == null) result = caseTypedElement(operationCallExpression);
				if (result == null) result = caseNamedElement(operationCallExpression);
				if (result == null) result = caseParameterableElement(operationCallExpression);
				if (result == null) result = caseElement(operationCallExpression);
				if (result == null) result = caseEModelElement(operationCallExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.CONDITIONAL_EXPRESSION: {
				ConditionalExpression conditionalExpression = (ConditionalExpression)theEObject;
				Object result = caseConditionalExpression(conditionalExpression);
				if (result == null) result = caseExpression(conditionalExpression);
				if (result == null) result = caseValueSpecification(conditionalExpression);
				if (result == null) result = casePackageableElement(conditionalExpression);
				if (result == null) result = caseTypedElement(conditionalExpression);
				if (result == null) result = caseNamedElement(conditionalExpression);
				if (result == null) result = caseParameterableElement(conditionalExpression);
				if (result == null) result = caseElement(conditionalExpression);
				if (result == null) result = caseEModelElement(conditionalExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.INTERVAL_SPECIFICATION: {
				IntervalSpecification intervalSpecification = (IntervalSpecification)theEObject;
				Object result = caseIntervalSpecification(intervalSpecification);
				if (result == null) result = caseValueSpecification(intervalSpecification);
				if (result == null) result = casePackageableElement(intervalSpecification);
				if (result == null) result = caseTypedElement(intervalSpecification);
				if (result == null) result = caseNamedElement(intervalSpecification);
				if (result == null) result = caseParameterableElement(intervalSpecification);
				if (result == null) result = caseElement(intervalSpecification);
				if (result == null) result = caseEModelElement(intervalSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.TUPLE_SPECIFICATION: {
				TupleSpecification tupleSpecification = (TupleSpecification)theEObject;
				Object result = caseTupleSpecification(tupleSpecification);
				if (result == null) result = caseValueSpecification(tupleSpecification);
				if (result == null) result = casePackageableElement(tupleSpecification);
				if (result == null) result = caseTypedElement(tupleSpecification);
				if (result == null) result = caseNamedElement(tupleSpecification);
				if (result == null) result = caseParameterableElement(tupleSpecification);
				if (result == null) result = caseElement(tupleSpecification);
				if (result == null) result = caseEModelElement(tupleSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.TUPLE_ITEM_VALUE: {
				TupleItemValue tupleItemValue = (TupleItemValue)theEObject;
				Object result = caseTupleItemValue(tupleItemValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.CHOICE_SPECIFICATION: {
				ChoiceSpecification choiceSpecification = (ChoiceSpecification)theEObject;
				Object result = caseChoiceSpecification(choiceSpecification);
				if (result == null) result = caseValueSpecification(choiceSpecification);
				if (result == null) result = casePackageableElement(choiceSpecification);
				if (result == null) result = caseTypedElement(choiceSpecification);
				if (result == null) result = caseNamedElement(choiceSpecification);
				if (result == null) result = caseParameterableElement(choiceSpecification);
				if (result == null) result = caseElement(choiceSpecification);
				if (result == null) result = caseEModelElement(choiceSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.COLLECTION_SPECIFICATION: {
				CollectionSpecification collectionSpecification = (CollectionSpecification)theEObject;
				Object result = caseCollectionSpecification(collectionSpecification);
				if (result == null) result = caseValueSpecification(collectionSpecification);
				if (result == null) result = casePackageableElement(collectionSpecification);
				if (result == null) result = caseTypedElement(collectionSpecification);
				if (result == null) result = caseNamedElement(collectionSpecification);
				if (result == null) result = caseParameterableElement(collectionSpecification);
				if (result == null) result = caseElement(collectionSpecification);
				if (result == null) result = caseEModelElement(collectionSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.OBS_CALL_EXPRESSION: {
				ObsCallExpression obsCallExpression = (ObsCallExpression)theEObject;
				Object result = caseObsCallExpression(obsCallExpression);
				if (result == null) result = caseValueSpecification(obsCallExpression);
				if (result == null) result = casePackageableElement(obsCallExpression);
				if (result == null) result = caseTypedElement(obsCallExpression);
				if (result == null) result = caseNamedElement(obsCallExpression);
				if (result == null) result = caseParameterableElement(obsCallExpression);
				if (result == null) result = caseElement(obsCallExpression);
				if (result == null) result = caseEModelElement(obsCallExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.TIME_EXPRESSION: {
				TimeExpression timeExpression = (TimeExpression)theEObject;
				Object result = caseTimeExpression(timeExpression);
				if (result == null) result = caseValueSpecification(timeExpression);
				if (result == null) result = casePackageableElement(timeExpression);
				if (result == null) result = caseTypedElement(timeExpression);
				if (result == null) result = caseNamedElement(timeExpression);
				if (result == null) result = caseParameterableElement(timeExpression);
				if (result == null) result = caseElement(timeExpression);
				if (result == null) result = caseEModelElement(timeExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.INSTANT_EXPRESSION: {
				InstantExpression instantExpression = (InstantExpression)theEObject;
				Object result = caseInstantExpression(instantExpression);
				if (result == null) result = caseTimeExpression(instantExpression);
				if (result == null) result = caseValueSpecification(instantExpression);
				if (result == null) result = casePackageableElement(instantExpression);
				if (result == null) result = caseTypedElement(instantExpression);
				if (result == null) result = caseNamedElement(instantExpression);
				if (result == null) result = caseParameterableElement(instantExpression);
				if (result == null) result = caseElement(instantExpression);
				if (result == null) result = caseEModelElement(instantExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.DURATION_EXPRESSION: {
				DurationExpression durationExpression = (DurationExpression)theEObject;
				Object result = caseDurationExpression(durationExpression);
				if (result == null) result = caseTimeExpression(durationExpression);
				if (result == null) result = caseValueSpecification(durationExpression);
				if (result == null) result = casePackageableElement(durationExpression);
				if (result == null) result = caseTypedElement(durationExpression);
				if (result == null) result = caseNamedElement(durationExpression);
				if (result == null) result = caseParameterableElement(durationExpression);
				if (result == null) result = caseElement(durationExpression);
				if (result == null) result = caseEModelElement(durationExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.JITTER_EXPRESSION: {
				JitterExpression jitterExpression = (JitterExpression)theEObject;
				Object result = caseJitterExpression(jitterExpression);
				if (result == null) result = caseDurationExpression(jitterExpression);
				if (result == null) result = caseTimeExpression(jitterExpression);
				if (result == null) result = caseValueSpecification(jitterExpression);
				if (result == null) result = casePackageableElement(jitterExpression);
				if (result == null) result = caseTypedElement(jitterExpression);
				if (result == null) result = caseNamedElement(jitterExpression);
				if (result == null) result = caseParameterableElement(jitterExpression);
				if (result == null) result = caseElement(jitterExpression);
				if (result == null) result = caseEModelElement(jitterExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.INSTANT_INTERVAL_SPECIFICATION: {
				InstantIntervalSpecification instantIntervalSpecification = (InstantIntervalSpecification)theEObject;
				Object result = caseInstantIntervalSpecification(instantIntervalSpecification);
				if (result == null) result = caseIntervalSpecification(instantIntervalSpecification);
				if (result == null) result = caseValueSpecification(instantIntervalSpecification);
				if (result == null) result = casePackageableElement(instantIntervalSpecification);
				if (result == null) result = caseTypedElement(instantIntervalSpecification);
				if (result == null) result = caseNamedElement(instantIntervalSpecification);
				if (result == null) result = caseParameterableElement(instantIntervalSpecification);
				if (result == null) result = caseElement(instantIntervalSpecification);
				if (result == null) result = caseEModelElement(instantIntervalSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case VSLPackage.DURATION_INTERVAL_SPECIFICATION: {
				DurationIntervalSpecification durationIntervalSpecification = (DurationIntervalSpecification)theEObject;
				Object result = caseDurationIntervalSpecification(durationIntervalSpecification);
				if (result == null) result = caseIntervalSpecification(durationIntervalSpecification);
				if (result == null) result = caseValueSpecification(durationIntervalSpecification);
				if (result == null) result = casePackageableElement(durationIntervalSpecification);
				if (result == null) result = caseTypedElement(durationIntervalSpecification);
				if (result == null) result = caseNamedElement(durationIntervalSpecification);
				if (result == null) result = caseParameterableElement(durationIntervalSpecification);
				if (result == null) result = caseElement(durationIntervalSpecification);
				if (result == null) result = caseEModelElement(durationIntervalSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Subtype</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Subtype</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSubtype(Subtype object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Bounded Subtype</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Bounded Subtype</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseBoundedSubtype(BoundedSubtype object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Composite Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Composite Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCompositeType(CompositeType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Interval Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Interval Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseIntervalType(IntervalType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Collection Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCollectionType(CollectionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Tuple Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Tuple Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTupleType(TupleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Choice Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Choice Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseChoiceType(ChoiceType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Enumeration Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Enumeration Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEnumerationSpecification(EnumerationSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Literal Real</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Literal Real</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLiteralReal(LiteralReal object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Literal Date Time</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Literal Date Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLiteralDateTime(LiteralDateTime object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Literal Default</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Literal Default</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLiteralDefault(LiteralDefault object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Variable Call Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Variable Call Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseVariableCallExpression(VariableCallExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseVariable(Variable object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Expression Context</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Expression Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExpressionContext(ExpressionContext object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Property Call Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Property Call Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePropertyCallExpression(PropertyCallExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Operation Call Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Operation Call Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOperationCallExpression(OperationCallExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Conditional Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Conditional Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseConditionalExpression(ConditionalExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Interval Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Interval Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseIntervalSpecification(IntervalSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Tuple Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Tuple Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTupleSpecification(TupleSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Tuple Item Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Tuple Item Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTupleItemValue(TupleItemValue object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Choice Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Choice Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseChoiceSpecification(ChoiceSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Collection Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Collection Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCollectionSpecification(CollectionSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Obs Call Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Obs Call Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseObsCallExpression(ObsCallExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Time Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Time Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTimeExpression(TimeExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Instant Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Instant Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseInstantExpression(InstantExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Duration Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Duration Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDurationExpression(DurationExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Jitter Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Jitter Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseJitterExpression(JitterExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Instant Interval Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Instant Interval Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseInstantIntervalSpecification(InstantIntervalSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Duration Interval Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Duration Interval Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDurationIntervalSpecification(DurationIntervalSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EModel Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EModel Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEModelElement(EModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseElement(Element object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNamedElement(NamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Namespace</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Namespace</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNamespace(Namespace object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Redefinable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Redefinable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRedefinableElement(RedefinableElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Parameterable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Parameterable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseParameterableElement(ParameterableElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Packageable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Packageable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePackageableElement(PackageableElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseType(Type object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Templateable Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Templateable Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTemplateableElement(TemplateableElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Classifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Classifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseClassifier(Classifier object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Data Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDataType(DataType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Typed Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Typed Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTypedElement(TypedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Value Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Value Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseValueSpecification(ValueSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Literal Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Literal Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLiteralSpecification(LiteralSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseExpression(Expression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //VSLSwitch
