/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: ObservationCollection.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */

package com.thalesgroup.nfp.rsa.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.UMLPackage;

import com.ibm.xtools.emf.index.search.IIndexSearchManager;
import com.ibm.xtools.emf.index.search.IndexContext;

/**
 * 
 * @author T0081227 Francois NIZOU - 20 aot 07
 * 
 */
public class ObservationCollection {

	protected HashMap<String, ArrayList<Observation>> observations = null;

	protected ArrayList<Observation> flatObservation = null;

	private Model model;

	public ObservationCollection(Model model) {
		this.model = model;

	}

	/**
	 * @param model
	 */
	private void init() {
		flatObservation = new ArrayList<Observation>();
		observations = new HashMap<String, ArrayList<Observation>>();
		EList allOwnedElements = model.allOwnedElements();
		for (Object object : allOwnedElements) {
			if (!(object instanceof Observation))
				continue;
			Observation observation = (Observation) object;
			String name = observation.getName();
			if (!observations.containsKey(name))
				observations.put(name, new ArrayList<Observation>());
			observations.get(name).add(observation);
			flatObservation.add(observation);
		}
	}

	/**
	 * 
	 * @param name
	 * @return all Observation from the model which name are name.
	 */
	ArrayList<Observation> getObservationsByName(String name) {
		if (observations == null)
			init();

		if (observations.containsKey(name))
			return observations.get(name);
		else
			return new ArrayList<Observation>();
	}

	/**
	 * 
	 * @param prefix
	 * @return all Observation from the model which name startwith prefix.
	 */
	ArrayList<Observation> getObservationsStartWith(String prefix) {
		ResourceSet resourceSet = model.eResource().getResourceSet();
		ArrayList<Resource> resources = new ArrayList<Resource>();
		resources.add(model.eResource());
		IndexContext indexContext = new IndexContext(resourceSet, resources);
		indexContext.getOptions().put(IndexContext.RESOLVE_PROXIES,
				Boolean.TRUE);
		Collection oes = null;
		try {
			oes = IIndexSearchManager.INSTANCE.findEObjects(indexContext,
					prefix + "*", false, null, UMLPackage.eINSTANCE
							.getObservation(), new NullProgressMonitor());
			return new ArrayList<Observation>(oes);

		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Note: operation Called on Observation are:
	 * <ul>
	 * <li>{@link NamedElement#getName()}</li>
	 * <li> and instanceof comparaison for TimeObservation or
	 * DurationObservation {@link Observation}</li>
	 * </ul>
	 * 
	 * @return all the Observation of the Model
	 */
	ArrayList<Observation> getObservations() {
		if (flatObservation == null)
			init();
		return flatObservation;
	}
}
