/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: SlotTreeViewEditionAction.java,v 1.2 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.popup.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Slot;

import com.ibm.xtools.uml.navigator.ModelServerElement;
import com.thalesgroup.nfp.rsa.model.RSAModel;

/**
 * 
 * @author T0081227 Francois NIZOU - 2 aot 07
 * 
 */
public class SlotTreeViewEditionAction implements IObjectActionDelegate {

	public SlotTreeViewEditionAction() {
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void run(IAction action) {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		ISelection selectedElement = activeWorkbenchWindow
				.getSelectionService().getSelection();

		IStructuredSelection structuredSel = (IStructuredSelection) selectedElement;
		ModelServerElement modelServerElement = (ModelServerElement) structuredSel
				.getFirstElement();
		Slot slot = (Slot) modelServerElement.getElement();
		RSAModel.instance().handleSlot(slot);
	}

	public void selectionChanged(IAction action, ISelection selection) {

	}

}
