/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: AddArrayEntryAction.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

import com.thalesgroup.nfp.rsa.model.RSAModel;

/**
 * This action is used to increase the size of a multi valued stereotype property.
 * @author T0081227 Francois NIZOU - 6 aot 07
 * 
 */
public class AddArrayEntryAction extends Action {

	private PropertySheetPage page;

	public AddArrayEntryAction(PropertySheetPage page) {
		this.page = page;
		this.setToolTipText("add an entry to an Array");
	}

	@Override
	public void run() {
		Tree tree = (Tree) page.getControl();
		TreeItem[] selection = tree.getSelection();
		TreeItem treeItem = selection[0];
		PropertySheetEntry data = (PropertySheetEntry)treeItem.getData();
		Object[] values = data.getValues();
		Object object = values[0];
		if (object instanceof MultiValuedPropertyPropertySource){
			MultiValuedPropertyPropertySource sel = (MultiValuedPropertyPropertySource)object;
			Element element = sel.getElement();
			Property property = sel.getProperty();
			Stereotype stereotype = sel.getStereotype();
			RSAModel.instance().addArrayEntry(element, stereotype, property);
		}
		
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		ISharedImages sharedImages = PlatformUI.getWorkbench()
        .getSharedImages();
		ImageDescriptor image = sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_UP);
		return image;
	}

}
