/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: ElementPropertySource.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/**
 * implementation of an IPropertySource to display Stereotypes treeview for an
 * UML element.
 * 
 * @author T0081227 Francois NIZOU - 6 aot 07
 * 
 */
public class ElementPropertySource implements IPropertySource {

	private Element element;

	public ElementPropertySource(Element element) {
		this.element = element;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		EList stereotypes = element.getAppliedStereotypes();
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[stereotypes
				.size()];
		for (int i = 0; i < descriptors.length; i++) {
			PropertyDescriptor propertyDescriptor = new PropertyDescriptor(i,
					((Stereotype) stereotypes.get(i)).getName());
			descriptors[i] = propertyDescriptor;
		}

		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		Integer i = (Integer) id;
		EList stereotypes = element.getAppliedStereotypes();
		Stereotype stereotype = (Stereotype) stereotypes.get(i);
		return new StereotypePropertySource(stereotype, element);
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

}
