/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: RemoveArrayEntryAction.java,v 1.4 2007/11/02 08:01:15 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

import com.thalesgroup.nfp.rsa.model.RSAModel;

/**
 * An action to remove a selected entry in a collection of tagged value.
 * 
 * @author T0081227 Francois NIZOU - 8 aot 07
 * 
 */
public class RemoveArrayEntryAction extends Action {

	private PropertySheetPage page;

	public RemoveArrayEntryAction(PropertySheetPage page) {
		this.page = page;
		this.setToolTipText("remove an array entry");
		ISharedImages sharedImages = PlatformUI.getWorkbench()
				.getSharedImages();
		ImageDescriptor image = sharedImages
				.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE);
		this.setImageDescriptor(image);
	}

	@Override
	public void run() {
		Tree tree = (Tree) page.getControl();
		TreeItem[] selection = tree.getSelection();
		TreeItem treeItem = selection[0];

		PropertySheetEntry data = (PropertySheetEntry) treeItem.getData();

		PropertySheetEntry data2 = (PropertySheetEntry) treeItem
				.getParentItem().getData();

		Object[] values = data2.getValues();

		Object value = values[0];
		if (!(value instanceof MultiValuedPropertyPropertySource))
			return;

		MultiValuedPropertyPropertySource parent = (MultiValuedPropertyPropertySource) value;

		Element element = parent.getElement();
		Property property = parent.getProperty();
		Stereotype stereotype = parent.getStereotype();

		String displayName = data.getDisplayName();
		int index = Integer.parseInt(displayName.substring(displayName
				.indexOf("[") + 1, displayName.indexOf("]")));

		RSAModel.instance().removeArrayEntry(element, stereotype, property,
				index);

	}

}
