/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */

package com.thalesgroup.vslviewer.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/**
 * This class is a singleton.
 * It computes the VSLSelectionConverter registered at the extensionpoint com.thalesgroup.vslview.SelectionConverter
 * if any.
 * @author T0081227 Francois NIZOU - 18 oct. 07 
 *
 */
public class ExtensionPoint {

	// The name of the field specifying the VSLSelectionConverter to use
	private static final String CLASS = "class";

	// the extension point id
	private static final String EXTENSION_POINT_ID = "com.thalesgroup.vslview.SelectionConverter";

	// The singleton instance
	protected static ExtensionPoint self = null;

	// the  computed singleton
	VSLSelectionConverter converter = null;

	// Protected for singleton
	protected ExtensionPoint() {
		// @see eclipse extension mecanisme for more information
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);

		if (point == null)
			return;
		IExtension[] extensions = point.getExtensions();

		for (int i = 0; i < extensions.length; i++) {
			IExtension extension = extensions[i];
			IConfigurationElement[] configurationElements = extension
					.getConfigurationElements();
			for (IConfigurationElement element : configurationElements) {
				try {
					VSLSelectionConverter o = (VSLSelectionConverter) element
							.createExecutableExtension(CLASS);
					if (o != null) {
						converter = o;
						return;
					}
				} catch (CoreException e) {
					e.printStackTrace();
				}
			}
		}
	};

	/**
	 * 
	 * @return singleton instance of this class
	 */
	public static ExtensionPoint instance() {
		if (self == null)
			self = new ExtensionPoint();
		return self;
	}

	/**
	 * 
	 * @return the registered converter if any
	 */
	public VSLSelectionConverter getConverter() {
		return converter;
	}

}
