/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */

package com.thalesgroup.vslviewer.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.ValueSpecification;

import com.thalesgroup.vslviewer.extension.ExtensionPoint;
import com.thalesgroup.vslviewer.extension.VSLSelectionConverter;
import com.thalesgroup.vslviewer.treeObject.VSLTreeNode;


/**
 * This class is the selection listener registered by the VSLView class. When
 * the selection change (method selectionChanged) it get the registered
 * converter to compute the VSL to be displayed and update the view.
 * 
 * @author T0081227 Francois NIZOU - 26 oct. 07
 * 
 */
public class SelectionListener implements ISelectionListener {

	private TreeViewer treeview;

	public SelectionListener(TreeViewer treeViewer) {
		this.treeview = treeViewer;
	}

	/**
	 * When the selection change, this method get the converter from the
	 * ExtensionPoint class and using the c onvert method, get a
	 * ValueSpecification. If this ValueSpecification is not null, it creates a
	 * VSLTreeNode and update the treeview with this tree as input.
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		VSLSelectionConverter converter = ExtensionPoint.instance()
				.getConverter();
		if (converter != null) {
			ValueSpecification vsl = converter.convert(selection);
			if (vsl != null) {
				VSLTreeNode root = VSLTreeNode.makeRoot(vsl);
				treeview.setInput(root);
				treeview.refresh();
				treeview.expandAll();
			} else {
				treeview.setInput(null);
				treeview.refresh();
			}
		}
	}

}
