/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales ATL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: ATLFacilities.java,v 1.4 2008/06/16 09:40:14 emaes Exp $
 */
package com.thalesgroup.atl;

import java.util.ArrayList;
import java.util.Iterator;

import org.atl.engine.repositories.emf4atl.ASMEMFModelElement;
import org.atl.engine.vm.nativelib.ASMCollection;
import org.atl.engine.vm.nativelib.ASMString;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.TypedElement;

import com.thalesgroup.atl.exception.ATLException;
import com.thalesgroup.java.log.Activator;
import com.thalesgroup.java.log.Log;

/**
 * Class that is offering facilities for using ATL
 * @author Eric MAES
 */
public class ATLFacilities {
	
	/**
	 * Convert a string expression coming from ATL to a java string expression
	 * @param atlString String expression coming from ATL
	 * @return java string expression
	 */
	public static String asmStringToString (ASMString atlString)
		throws ATLException
	{
		return atlString.cString();
	}
	
	public static ArrayList<String> asmStringCollectionToStringList (ASMCollection atlStringCollection) {
		ArrayList<String> retour = new ArrayList<String>();
		Iterator i = atlStringCollection.iterator();
		try {
			while (i.hasNext()) {
				Object next = i.next();
				if (next instanceof ASMString) {
					ASMString nextASMString = (ASMString) next;
					retour.add(asmStringToString(nextASMString));
				}
			}
		}
		catch (Exception exception) {
			Log.errorMessage(Activator.PLUGIN_ID, "Impossible to convert ASMCollection to a List of String", exception);
		}
		return retour;
	}
	
	/**
	 * Convert a model element coming from ATL to a java UML Element
	 * @param atlModelElement  Model element coming from ATL
	 * @return java UML Element
	 */
	public static Element asmModelElementToElement (ASMEMFModelElement atlModelElement)
		throws ATLException
	{
		Element retour = null;
		Object elementObject = atlModelElement.getObject();
		if (elementObject instanceof Element) {
			Element element = (Element) elementObject;
			retour = element;
		}
		else {
			String message = "An ATL element can't be interpreted as a UML Model Element";
			throw new ATLException(message);
		}
		return retour;
	}
	
	/**
	 * Convert a model element coming from ATL to a java UML TypedElement
	 * @param atlModelElement  Model element coming from ATL
	 * @return java UML TypedElement
	 */
	public static TypedElement asmModelElementToTypedElement (ASMEMFModelElement atlModelElement)
		throws ATLException
	{
		TypedElement retour = null;
		Object typedElementObject = atlModelElement.getObject();
		if (typedElementObject instanceof TypedElement) {
			TypedElement typedElement = (TypedElement) typedElementObject;
			retour = typedElement;
		}
		else {
			String message = "An ATL element can't be interpreted as a UML Model Element";
			throw new ATLException(message);
		}
		return retour;
	}
	
}
