/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales ATL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: ATLProblem.java,v 1.3 2008/06/16 09:40:14 emaes Exp $
 */
package com.thalesgroup.atl;


/**
 * Mapping of a PROBLEM!Problem element in Java
 * @author Nicolas Vienne
 * @version 0.0.3, 09/2007
 */
public class ATLProblem {
	
	public enum Severity {
		critic,
		error,
		warning
	}
	
	protected String location = null;
	protected String description = null;
	protected Severity severity = null;
	
	public ATLProblem() {
		location = "";
		description = "";
		severity = Severity.error;
	}
	
	public ATLProblem(ATLProblem p) {
		location = p.location;
		description = p.description;
		severity = p.severity;
	}
	
	public ATLProblem(Severity severity, String location, String description) {
		this.location = location;
		this.description = description;
		this.severity = severity;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public Severity getSeverity() {
		return severity;
	}

	public void setSeverity(Severity severity) {
		this.severity = severity;
	}
	
	@Override
	public String toString() {
		return "["+this.severity.toString()+ "] " + this.location + " : " + this.description;
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof ATLProblem) {
			ATLProblem pb = (ATLProblem) o;
			return this.severity == pb.getSeverity()
				&& this.location.equals(pb.getLocation())
				&& this.description.equals(pb.getDescription());
		} else {
			return false;
		}
	}

}
