/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales ATL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: ExtendedATLProblem.java,v 1.3 2008/06/16 09:40:14 emaes Exp $
 */
package com.thalesgroup.atl;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EEnumLiteralImpl;

/**
 * Mapping of a PROBLEM!Problem element in Java with added
 * ability to create the marker from an object element and
 * to create a marker for display in the Problems view 
 * @author Nicolas Vienne
 *
 */
public class ExtendedATLProblem extends ATLProblem {
	IMarker m = null;
	public static final String INFO_PREFIX = "INFO: ";
	
	public ExtendedATLProblem() {
		super();
	}
	public ExtendedATLProblem(EObject eobject) {
		super();
		fromProblemElement(eobject);
	}

	public IMarker createMarker(IResource resource) throws CoreException {
		IMarker marker = resource.createMarker(IMarker.PROBLEM);

		if (marker.exists()) {
			String descr = getDescription();
			if(getSeverity() == Severity.critic || 
					getSeverity() == Severity.error) {	
				marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
			} else if(getSeverity() == Severity.warning) {
				if(!descr.startsWith(INFO_PREFIX)) {
					marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING);
				} else {
					marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_INFO);
					descr = descr.substring(INFO_PREFIX.length());
				}
				
			}
			marker.setAttribute(IMarker.MESSAGE, descr);
			marker.setAttribute(IMarker.LOCATION, getLocation());
		}
		
		if(m != null) {
			removeMarker();
		}
		m = marker;
		return marker;
	}
	
	public void removeMarker() throws CoreException {
		if(m.exists()){
			m.delete();
		}
	}
	
	public void fromProblemElement(EObject eobject) {
		for(Object o2 : eobject.eClass().getEAttributes()) {
			EAttributeImpl a = (EAttributeImpl) o2;
			
			if(a.getName().equals("location")) {
				String s = (String) eobject.eGet(a);
				setLocation(s);
			}
			if(a.getName().equals("description")) {
				String s = (String)eobject.eGet(a);
				setDescription(s);
			}
			if(a.getName().equals("severity")) {
				EEnumLiteralImpl eli = (EEnumLiteralImpl) eobject.eGet(a);
				String s = eli.toString();
				if(s.equals("critic")) {
					setSeverity(Severity.critic);
				} else if (s.equals("warning")){
					setSeverity(Severity.warning);
				} else {
					setSeverity(Severity.error);
				}
			}
		}
	}

	@Override
	public boolean equals(Object o) {
		return super.equals(o);
	}

	@Override
	public String toString() {
		return super.toString();
	}
	
	@Override
	protected void finalize() throws Throwable {
//		removeMarker();
		super.finalize();
	}
}
