/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales MARTE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: LOGATLFacilities.java,v 1.2 2007/11/21 13:59:45 emaes Exp $
 */
package com.thalesgroup.atl.log;

import org.atl.engine.repositories.emf4atl.ASMEMFModelElement;
import org.atl.engine.vm.StackFrame;
import org.atl.engine.vm.nativelib.ASMBoolean;
import org.atl.engine.vm.nativelib.ASMString;

import com.thalesgroup.atl.ATLFacilities;
import com.thalesgroup.atl.ATLTransform;
import com.thalesgroup.java.log.Log;

/**
 * Class that is offering facilities for using display messages services in ATL transformations
 * @author Eric MAES
 */
public class LOGATLFacilities extends ATLFacilities {


	/**
	 * Operation to display debug messages using com.thalesgroup.java.log
	 * @param frame frame Necessary parameter for a use from ATL
	 * @param self element of the model
	 * @param message message to display
	 */
	public static ASMBoolean debugMessage(StackFrame frame, ASMEMFModelElement self, ASMString message) {
		try {
			Log.debugMessage("ATL", asmStringToString(message));
		}
		catch (Exception exception) {
			String errorMessage = "Bad argument for debugMessage operation : "+message.toString();
			Log.errorMessage(ATLTransform.PluginID, errorMessage, exception);
		}
		return new ASMBoolean(true);
	}
	
	/**
	 * Operation to display verbose messages using com.thalesgroup.java.log
	 * @param frame frame Necessary parameter for a use from ATL
	 * @param self element of the model
	 * @param message message to display
	 */
	public static ASMBoolean verboseMessage(StackFrame frame, ASMEMFModelElement self, ASMString message) {
		try {
			Log.verboseMessage("ATL", asmStringToString(message));
		}
		catch (Exception exception) {
			String errorMessage = "Bad argument for verboseMessage operation : "+message.toString();
			Log.errorMessage(ATLTransform.PluginID, errorMessage, exception);
		}
		return new ASMBoolean(true);
	}

	/**
	 * Operation to display demo messages using com.thalesgroup.java.log
	 * @param frame frame Necessary parameter for a use from ATL
	 * @param self element of the model
	 * @param message message to display
	 */
	public static ASMBoolean demoMessage(StackFrame frame, ASMEMFModelElement self, ASMString message) {
		try {
			Log.demoMessage("ATL", asmStringToString(message));
		}
		catch (Exception exception) {
			String errorMessage = "Bad argument for demoMessage operation : "+message.toString();
			Log.errorMessage(ATLTransform.PluginID, errorMessage, exception);
		}
		return new ASMBoolean(true);
	}

	/**
	 * Operation to display warning messages using com.thalesgroup.java.log
	 * @param frame frame Necessary parameter for a use from ATL
	 * @param self element of the model
	 * @param message message to display
	 */
	public static ASMBoolean warningMessage(StackFrame frame, ASMEMFModelElement self, ASMString message) {
		try {
			Log.warningMessage("ATL", asmStringToString(message));
		}
		catch (Exception exception) {
			String errorMessage = "Bad argument for warningMessage operation : "+message.toString();
			Log.errorMessage(ATLTransform.PluginID, errorMessage, exception);
		}
		return new ASMBoolean(true);
	}

	/**
	 * Operation to display error messages using com.thalesgroup.java.log
	 * @param frame frame Necessary parameter for a use from ATL
	 * @param self element of the model
	 * @param message message to display
	 */
	public static ASMBoolean errorMessage(StackFrame frame, ASMEMFModelElement self, ASMString message) {
		try {
			Log.errorMessage("ATL", asmStringToString(message));
		}
		catch (Exception exception) {
			String errorMessage = "Bad argument for errorMessage operation : "+message.toString();
			Log.errorMessage(ATLTransform.PluginID, errorMessage, exception);
		}
		return new ASMBoolean(true);
	}
	
}
