/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales MARTE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: MARTE.java,v 1.2 2007/11/21 13:59:45 emaes Exp $
 */
package com.thalesgroup.atl.marte;

/**
 * MARTE constants
 * @author Eric MAES
 */

public class MARTE {
	/*
	 * Profile Alloc
	 */
	// <<Allocated>>
	public String Allocated = "Alloc::Allocated";
	// <<ApplicationAllocationEnd>>
	public String ApplicationAllocationEnd = "Alloc::ApplicationAllocationEnd";
	public String ApplicationAllocationEnd_allocatedTo = "allocatedTo";
	// <<ExecutionPlatformAllocationEnd>>
	public String ExecutionPlatformAllocationEnd = "Alloc::ExecutionPlatformAllocationEnd";
	public String ExecutionPlatformAllocationEnd_allocatedFrom = "allocatedFrom";
	// Enum AllocationNature
	public String AllocationNature = "Alloc::AllocationNature";
	public String AllocationNature_spatialDistribution = "spatialDistribution";
	public String AllocationNature_timeScheduling = "timeScheduling";
	// Enum AllocationKind
	public String AllocationKind = "Alloc::AllocationKind";
	public String AllocationKind_structural = "structural";
	public String AllocationKind_behavioral = "behavioral";
	public String AllocationKind_hybrid = "hybrid";
	// <<Allocate>>
	public String Allocate = "Alloc::Allocate";
	public String Allocate_kind = "kind";
	public String Allocate_nature = "nature";
	public String Allocate_impliedConstraint = "impliedConstraint";
	// <<AllocateActivityGroup>>
	public String AllocateActivityGroup = "Alloc::AllocateActivityGroup";
	public String AllocateActivityGroup_isUnique = "isUnique";
	// <<ClockRefine>>
	public String ClockRefine = "Alloc::ClockRefine";
	public String ClockRefine_constraints = "constraints";
	/*
	 * Profile GCM
	 */
	// Enum DirectionKind
	public String DirectionKind = "GCM::DirectionKind";
	public String DirectionKind_in = "in";
	public String DirectionKind_out = "out";
	public String DirectionKind_inout = "inout";
	// <<FlowProperty>>
	public String FlowProperty = "GCM::FlowProperty";
	public String FlowProperty_direction = "direction";
	// <<FlowPort>>
	public String FlowPort = "GCM::FlowPort";
	public String FlowPort_isAtomic = "isAtomic";
	public String FlowPort_isConjugated = "isConjugated";
	public String FlowPort_direction = "direction";
	// <<MsgPort>>
	public String MsgPort = "GCM::MsgPort";
	public String MsgPort_isAtomic = "isAtomic";
	public String MsgPort_isConjugated = "isConjugated";
	public String MsgPort_direction = "direction";
	// <<FlowSendAction>>
	public String FlowSendAction = "GCM::FlowSendAction";
	// <<FlowSpecification>>
	public String FlowSpecification = "GCM::FlowSpecification";
	// <<ServiceSpecification>>
	public String ServiceSpecification = "GCM::ServiceSpecification";
	// <<SignalSpecification>>
	public String SignalSpecification = "GCM::SignalSpecification";
	public String SignalSpecification_direction = "direction";
	/*
	 * Profile GQAM
	 */
	// <<GaWorkloadBehavior>>
	public String GaWorkloadBehavior = "GQAM::GaWorkloadBehavior";
	public String GaWorkloadBehavior_behavior = "behavior";
	public String GaWorkloadBehavior_demand = "demand";
	// <<GaAnalysisContext>>
	public String GaAnalysisContext = "GQAM::GaAnalysisContext";
	public String GaAnalysisContext_contextParams = "contextParams";
	public String GaAnalysisContext_workload = "workload";
	public String GaAnalysisContext_platform = "platform";
	// <<GaResourcesPlatform>>
	public String GaResourcesPlatform = "GQAM::GaResourcesPlatform";
	public String GaResourcesPlatform_resources = "resources";
	// <<GaEventTrace>>
	public String GaEventTrace = "GQAM::GaEventTrace";
	public String GaEventTrace_content = "content";
	public String GaEventTrace_format = "format";
	public String GaEventTrace_location = "location";
	public String GaEventTrace_stream = "stream";
	// <<GaWorkloadEvent>>
	public String GaWorkloadEvent = "GQAM::GaWorkloadEvent";
	public String GaWorkloadEvent_pattern = "pattern";
	public String GaWorkloadEvent_generator = "generator";
	public String GaWorkloadEvent_trace = "trace";
	public String GaWorkloadEvent_timeEvent = "timeEvent";
	// <<GaWorkloadGenerator>>
	public String GaWorkloadGenerator = "GQAM::GaWorkloadGenerator";
	public String GaWorkloadGenerator_pop = "pop";
	// <<GaScenario>>
	public String GaScenario = "GQAM::GaScenario";
	public String GaScenario_root = "root";
	public String GaScenario_hostDemand = "hostDemand";
	public String GaScenario_hostDemandOps = "hostDemandOps";
	public String GaScenario_interOccT = "interOccT";
	public String GaScenario_throughput = "throughput";
	public String GaScenario_respT = "respT";
	public String GaScenario_utilization = "utilization";
	public String GaScenario_utilizationOnhost = "utilizationOnhost";
	public String GaScenario_steps = "steps";
	public String GaScenario_cause = "cause";
	public String GaScenario_timing = "timing";
	// <<GaStep>>
	public String GaStep = "GQAM::GaStep";
	public String GaStep_isAtomic = "isAtomic";
	public String GaStep_blockT = "blockT";
	public String GaStep_rep = "rep";
	public String GaStep_prob = "prob";
	public String GaStep_priority = "priority";
	public String GaStep_servCount = "servCount";
	public String GaStep_concurRes = "concurRes";
	public String GaStep_host = "host";
	public String GaStep_servDemand = "servDemand";
	public String GaStep_behavior = "behavior";
	// <<GaRequestedService>>
	public String GaRequestedService = "GQAM::GaRequestedService";
	// <<GaCommStep>>
	public String GaCommStep = "GQAM::GaCommStep";
	public String GaCommStep_msgSize = "msgSize";
	// <<GaAcqStep>>
	public String GaAcqStep = "GQAM::GaAcqStep";
	public String GaAcqStep_resUnits = "resUnits";
	public String GaAcqStep_acqRes = "acqRes";
	// <<GaRelStep>>
	public String GaRelStep = "GQAM::GaRelStep";
	public String GaRelStep_relRes = "relRes";
	public String GaRelStep_resUnits = "resUnits";
	// Enum LaxityKind
	public String LaxityKind = "GQAM::LaxityKind";
	public String LaxityKind_hard = "hard";
	public String LaxityKind_soft = "soft";
	public String LaxityKind_other = "other";
	// <<GaTimingObs>>
	public String GaTimingObs = "GQAM::GaTimingObs";
	public String GaTimingObs_laxity = "laxity";
	public String GaTimingObs_startEvent = "startEvent";
	public String GaTimingObs_endEvent = "endEvent";
	// <<GaLatencyObs>>
	public String GaLatencyObs = "GQAM::GaLatencyObs";
	public String GaLatencyObs_latency = "latency";
	public String GaLatencyObs_miss = "miss";
	public String GaLatencyObs_utility = "utility";
	public String GaLatencyObs_maxJitter = "maxJitter";
	// <<GaExecHost>>
	public String GaExecHost = "GQAM::GaExecHost";
	public String GaExecHost_commTxOvh = "commTxOvh";
	public String GaExecHost_commRcvOvh = "commRcvOvh";
	public String GaExecHost_cntxtSwT = "cntxtSwT";
	public String GaExecHost_clockOvh = "clockOvh";
	public String GaExecHost_memSize = "memSize";
	public String GaExecHost_utilization = "utilization";
	public String GaExecHost_throughput = "throughput";
	public String GaExecHost_schedPriRange = "schedPriRange";
	// <<GaCommHost>>
	public String GaCommHost = "GQAM::GaCommHost";
	public String GaCommHost_capacity = "capacity";
	public String GaCommHost_packetT = "packetT";
	public String GaCommHost_blockT = "blockT";
	public String GaCommHost_transmMode = "transmMode";
	public String GaCommHost_utilization = "utilization";
	public String GaCommHost_throughput = "throughput";
	// <<GaCommChannel>>
	public String GaCommChannel = "GQAM::GaCommChannel";
	public String GaCommChannel_packetSize = "packetSize";
	/*
	 * Profile GRM
	 */
	// <<Resource>>
	public String Resource = "GRM::Resource";
	public String Resource_resMult = "resMult";
	public String Resource_isProtected = "isProtected";
	public String Resource_isActive = "isActive";
	// <<StorageResource>>
	public String StorageResource = "GRM::StorageResource";
	public String StorageResource_elementSize = "elementSize";
	// <<CommunicationEndPoint>>
	public String CommunicationEndPoint = "GRM::CommunicationEndPoint";
	public String CommunicationEndPoint_packetSize = "packetSize";
	// <<SynchronizationResource>>
	public String SynchronizationResource = "GRM::SynchronizationResource";
	// <<ConcurrencyResource>>
	public String ConcurrencyResource = "GRM::ConcurrencyResource";
	// <<MutualExclusionResource>>
	public String MutualExclusionResource = "GRM::MutualExclusionResource";
	public String MutualExclusionResource_protectKind = "protectKind";
	public String MutualExclusionResource_ceiling = "ceiling";
	public String MutualExclusionResource_otherProtectProtocol = "otherProtectProtocol";
	public String MutualExclusionResource_scheduler = "scheduler";
	// <<SchedulableResource>>
	public String SchedulableResource = "GRM::SchedulableResource";
	public String SchedulableResource_schedParams = "schedParams";
	public String SchedulableResource_isActive = "isActive";
	public String SchedulableResource_dependentScheduler = "dependentScheduler";
	public String SchedulableResource_host = "host";
	// <<Scheduler>>
	public String Scheduler = "GRM::Scheduler";
	public String Scheduler_isPreemptible = "isPreemptible";
	public String Scheduler_schedPolicy = "schedPolicy";
	public String Scheduler_otherSchedPolicy = "otherSchedPolicy";
	public String Scheduler_schedule = "schedule";
	public String Scheduler_host = "host";
	public String Scheduler_processingUnits = "processingUnits";
	public String Scheduler_schedulableResources = "schedulableResources";
	public String Scheduler_protectedSharedResources = "protectedSharedResources";
	// <<SecondaryScheduler>>
	public String SecondaryScheduler = "GRM::SecondaryScheduler";
	public String SecondaryScheduler_virtualProcessingUnits = "virtualProcessingUnits";
	// <<ProcessingResource>>
	public String ProcessingResource = "GRM::ProcessingResource";
	public String ProcessingResource_speedFactor = "speedFactor";
	public String ProcessingResource_mainScheduler = "mainScheduler";
	// <<ComputingResource>>
	public String ComputingResource = "GRM::ComputingResource";
	// <<DeviceResource>>
	public String DeviceResource = "GRM::DeviceResource";
	// <<CommunicationMedia>>
	public String CommunicationMedia = "GRM::CommunicationMedia";
	public String CommunicationMedia_elementSize = "elementSize";
	// <<TimingResource>>
	public String TimingResource = "GRM::TimingResource";
	// <<ClockResource>>
	public String ClockResource = "GRM::ClockResource";
	// <<TimerResource>>
	public String TimerResource = "GRM::TimerResource";
	public String TimerResource_duration = "duration";
	public String TimerResource_isPeriodic = "isPeriodic";
	// <<GRService>>
	public String GRService = "GRM::GRService";
	public String GRService_owner = "owner";
	// <<Release>>
	public String Release = "GRM::Release";
	// <<Acquire>>
	public String Acquire = "GRM::Acquire";
	public String Acquire_isBlocking = "isBlocking";
	// <<ResourceUsage>>
	public String ResourceUsage = "GRM::ResourceUsage";
	public String ResourceUsage_usedResources = "usedResources";
	public String ResourceUsage_subUsages = "subUsages";
	public String ResourceUsage_execTime = "execTime";
	public String ResourceUsage_msgSize = "msgSize";
	public String ResourceUsage_allocatedMemory = "allocatedMemory";
	public String ResourceUsage_usedMemory = "usedMemory";
	public String ResourceUsage_powerPeak = "powerPeak";
	public String ResourceUsage_energy = "energy";
	/*
	 * Profile HRM
	 */
	// <<HwResourceService>>
	public String HwResourceService = "HRM::HwResourceService";
	public String HwResourceService_consumption = "consumption";
	public String HwResourceService_dissipation = "dissipation";
	// <<HwResource>>
	public String HwResource = "HRM::HwResource";
	public String HwResource_ownedHW = "ownedHW";
	public String HwResource_description = "description";
	public String HwResource_r_HW_Services = "r_HW_Services";
	public String HwResource_p_HW_Services = "p_HW_Services";
	public String HwResource_endPoints = "endPoints";
	public String HwResource_frequency = "frequency";
	// <<HwComputingResource>>
	public String HwComputingResource = "HRM::HwComputingResource";
	public String HwComputingResource_op_Frequencies = "op_Frequencies";
	// <<HwCommunicationResource>>
	public String HwCommunicationResource = "HRM::HwCommunicationResource";
	// <<HwMemory>>
	public String HwMemory = "HRM::HwMemory";
	public String HwMemory_timings = "timings";
	public String HwMemory_memorySize = "memorySize";
	public String HwMemory_addressSize = "addressSize";
	// <<HwTimingResource>>
	public String HwTimingResource = "HRM::HwTimingResource";
	// <<HwStorageManager>>
	public String HwStorageManager = "HRM::HwStorageManager";
	public String HwStorageManager_managedMemories = "managedMemories";
	// <<HwDevice>>
	public String HwDevice = "HRM::HwDevice";
	// Enum ISA_Type
	public String ISA_Type = "HRM::ISA_Type";
	public String ISA_Type_RISC = "RISC";
	public String ISA_Type_CISC = "CISC";
	public String ISA_Type_VLIW = "VLIW";
	public String ISA_Type_SIMD = "SIMD";
	public String ISA_Type_Other = "Other";
	public String ISA_Type_Undefined = "Undefined";
	// Enum PLD_Technology
	public String PLD_Technology = "HRM::PLD_Technology";
	public String PLD_Technology_SRAM = "SRAM";
	public String PLD_Technology_Antifuse = "Antifuse";
	public String PLD_Technology_Flash = "Flash";
	public String PLD_Technology_Other = "Other";
	public String PLD_Technology_Undefined = "Undefined";
	// Enum PLD_Class
	public String PLD_Class = "HRM::PLD_Class";
	public String PLD_Class_SymetricalArray = "SymetricalArray";
	public String PLD_Class_RowBased = "RowBased";
	public String PLD_Class_SeaOfGates = "SeaOfGates";
	public String PLD_Class_HierarchicalPLD = "HierarchicalPLD";
	public String PLD_Class_Other = "Other";
	public String PLD_Class_Undefined = "Undefined";
	// <<HwBranchPredictor>>
	public String HwBranchPredictor = "HRM::HwBranchPredictor";
	// <<HwISA>>
	public String HwISA = "HRM::HwISA";
	public String HwISA_family = "family";
	public String HwISA_inst_Width = "inst_Width";
	public String HwISA_type = "type";
	// <<HwProcessor>>
	public String HwProcessor = "HRM::HwProcessor";
	public String HwProcessor_architecture = "architecture";
	public String HwProcessor_mips = "mips";
	public String HwProcessor_ipc = "ipc";
	public String HwProcessor_nbCores = "nbCores";
	public String HwProcessor_nbPipelines = "nbPipelines";
	public String HwProcessor_nbStages = "nbStages";
	public String HwProcessor_nbALUs = "nbALUs";
	public String HwProcessor_nbFPUs = "nbFPUs";
	public String HwProcessor_predictors = "predictors";
	public String HwProcessor_ownedISAs = "ownedISAs";
	public String HwProcessor_caches = "caches";
	public String HwProcessor_ownedMMUs = "ownedMMUs";
	// <<HwASIC>>
	public String HwASIC = "HRM::HwASIC";
	// <<HwPLD>>
	public String HwPLD = "HRM::HwPLD";
	public String HwPLD_technology = "technology";
	public String HwPLD_organization = "organization";
	public String HwPLD_nbLUTs = "nbLUTs";
	public String HwPLD_nbLUT_Inputs = "nbLUT_Inputs";
	public String HwPLD_nbFlipFlops = "nbFlipFlops";
	public String HwPLD_blocksRAM = "blocksRAM";
	public String HwPLD_blocksComputing = "blocksComputing";
	// Enum ROM_Type
	public String ROM_Type = "HRM::ROM_Type";
	public String ROM_Type_MaskedROM = "MaskedROM";
	public String ROM_Type_EPROM = "EPROM";
	public String ROM_Type_OPT_EPROM = "OPT_EPROM";
	public String ROM_Type_EEPROM = "EEPROM";
	public String ROM_Type_Flash = "Flash";
	public String ROM_Type_Other = "Other";
	public String ROM_Type_Undefined = "Undefined";
	// Enum CacheType
	public String CacheType = "HRM::CacheType";
	public String CacheType_Data = "Data";
	public String CacheType_Instruction = "Instruction";
	public String CacheType_Unified = "Unified";
	public String CacheType_Other = "Other";
	public String CacheType_Undefined = "Undefined";
	// Enum WritePolicy
	public String WritePolicy = "HRM::WritePolicy";
	public String WritePolicy_WriteBack = "WriteBack";
	public String WritePolicy_WriteThrough = "WriteThrough";
	public String WritePolicy_Other = "Other";
	public String WritePolicy_Undefined = "Undefined";
	// Enum Repl_Policy
	public String Repl_Policy = "HRM::Repl_Policy";
	public String Repl_Policy_LRU = "LRU";
	public String Repl_Policy_NFU = "NFU";
	public String Repl_Policy_FIFO = "FIFO";
	public String Repl_Policy_Random = "Random";
	public String Repl_Policy_Other = "Other";
	public String Repl_Policy_Undefined = "Undefined";
	// <<HwCache>>
	public String HwCache = "HRM::HwCache";
	public String HwCache_level = "level";
	public String HwCache_type = "type";
	public String HwCache_structure = "structure";
	// <<HwRAM>>
	public String HwRAM = "HRM::HwRAM";
	public String HwRAM_organization = "organization";
	public String HwRAM_isSynchronous = "isSynchronous";
	public String HwRAM_isStatic = "isStatic";
	public String HwRAM_isNonVolatile = "isNonVolatile";
	// <<HwROM>>
	public String HwROM = "HRM::HwROM";
	public String HwROM_type = "type";
	public String HwROM_organization = "organization";
	// <<HwDrive>>
	public String HwDrive = "HRM::HwDrive";
	public String HwDrive_sectorSize = "sectorSize";
	public String HwDrive_buffer = "buffer";
	// <<HwDMA>>
	public String HwDMA = "HRM::HwDMA";
	public String HwDMA_nbChannels = "nbChannels";
	public String HwDMA_transferWidth = "transferWidth";
	public String HwDMA_drivenBy = "drivenBy";
	// <<HwArbiter>>
	public String HwArbiter = "HRM::HwArbiter";
	public String HwArbiter_controlledMedias = "controlledMedias";
	// <<HwMMU>>
	public String HwMMU = "HRM::HwMMU";
	public String HwMMU_virtualAddrSpace = "virtualAddrSpace";
	public String HwMMU_physicalAddrSpace = "physicalAddrSpace";
	public String HwMMU_memoryProtection = "memoryProtection";
	public String HwMMU_nbEntriesTLB = "nbEntriesTLB";
	public String HwMMU_ownedTLBs = "ownedTLBs";
	// <<HwMedia>>
	public String HwMedia = "HRM::HwMedia";
	public String HwMedia_bandwidth = "bandwidth";
	public String HwMedia_arbiters = "arbiters";
	// <<HwBus>>
	public String HwBus = "HRM::HwBus";
	public String HwBus_addressWidth = "addressWidth";
	public String HwBus_wordWidth = "wordWidth";
	public String HwBus_isSynchronous = "isSynchronous";
	public String HwBus_isSerial = "isSerial";
	// <<HwBridge>>
	public String HwBridge = "HRM::HwBridge";
	public String HwBridge_sides = "sides";
	// <<HwEndPoint>>
	public String HwEndPoint = "HRM::HwEndPoint";
	public String HwEndPoint_connectedTo = "connectedTo";
	// <<HwClock>>
	public String HwClock = "HRM::HwClock";
	public String HwClock_frequency = "frequency";
	// <<HwTimer>>
	public String HwTimer = "HRM::HwTimer";
	public String HwTimer_nbCounters = "nbCounters";
	public String HwTimer_counterWidth = "counterWidth";
	public String HwTimer_inputClock = "inputClock";
	// <<HwIO>>
	public String HwIO = "HRM::HwIO";
	// <<HwSupport>>
	public String HwSupport = "HRM::HwSupport";
	// Enum ConditionType
	public String ConditionType = "HRM::ConditionType";
	public String ConditionType_Temperature = "Temperature";
	public String ConditionType_Humidity = "Humidity";
	public String ConditionType_Altitude = "Altitude";
	public String ConditionType_Vibration = "Vibration";
	public String ConditionType_Shock = "Shock";
	public String ConditionType_Other = "Other";
	public String ConditionType_Undefined = "Undefined";
	// Enum ComponentKind
	public String ComponentKind = "HRM::ComponentKind";
	public String ComponentKind_Card = "Card";
	public String ComponentKind_Channel = "Channel";
	public String ComponentKind_Chip = "Chip";
	public String ComponentKind_Port = "Port";
	public String ComponentKind_Unit = "Unit";
	public String ComponentKind_Other = "Other";
	public String ComponentKind_Undefined = "Undefined";
	// Enum ComponentState
	public String ComponentState = "HRM::ComponentState";
	public String ComponentState_Operating = "Operating";
	public String ComponentState_Storage = "Storage";
	public String ComponentState_Other = "Other";
	public String ComponentState_Undefined = "Undefined";
	// <<HwComponent>>
	public String HwComponent = "HRM::HwComponent";
	public String HwComponent_subComponents = "subComponents";
	public String HwComponent_kind = "kind";
	public String HwComponent_dimensions = "dimensions";
	public String HwComponent_area = "area";
	public String HwComponent_grid = "grid";
	public String HwComponent_nbPins = "nbPins";
	public String HwComponent_r_Conditions = "r_Conditions";
	public String HwComponent_position = "position";
	public String HwComponent_weight = "weight";
	public String HwComponent_price = "price";
	public String HwComponent_staticConsumption = "staticConsumption";
	public String HwComponent_staticDissipation = "staticDissipation";
	// <<HwPowerSupply>>
	public String HwPowerSupply = "HRM::HwPowerSupply";
	public String HwPowerSupply_suppliedPower = "suppliedPower";
	public String HwPowerSupply_capacity = "capacity";
	// <<HwCoolingSupply>>
	public String HwCoolingSupply = "HRM::HwCoolingSupply";
	public String HwCoolingSupply_coolingPower = "coolingPower";
	/*
	 * Profile InternalMarteLibrary
	 */
	// Enum TimeNatureKind
	public String TimeNatureKind = "InternalMarteLibrary::TimeNatureKind";
	public String TimeNatureKind_discrete = "discrete";
	public String TimeNatureKind_dense = "dense";
	// Enum TimeInterpretationKind
	public String TimeInterpretationKind = "InternalMarteLibrary::TimeInterpretationKind";
	public String TimeInterpretationKind_duration = "duration";
	public String TimeInterpretationKind_instant = "instant";
	public String TimeInterpretationKind_any = "any";
	// Enum TimeStandardKind
	public String TimeStandardKind = "InternalMarteLibrary::TimeStandardKind";
	public String TimeStandardKind_TAI = "TAI";
	public String TimeStandardKind_UT0 = "UT0";
	public String TimeStandardKind_UT1 = "UT1";
	public String TimeStandardKind_UTC = "UTC";
	public String TimeStandardKind_Local = "Local";
	public String TimeStandardKind_TT = "TT";
	public String TimeStandardKind_TDB = "TDB";
	public String TimeStandardKind_TCG = "TCG";
	public String TimeStandardKind_TCB = "TCB";
	public String TimeStandardKind_Sideral = "Sideral";
	public String TimeStandardKind_GPS = "GPS";
	// Enum EventKind
	public String EventKind = "InternalMarteLibrary::EventKind";
	public String EventKind_start = "start";
	public String EventKind_finish = "finish";
	public String EventKind_send = "send";
	public String EventKind_receive = "receive";
	public String EventKind_consume = "consume";
	// Enum ProtectProtocolKind
	public String ProtectProtocolKind = "InternalMarteLibrary::ProtectProtocolKind";
	public String ProtectProtocolKind_FIFO = "FIFO";
	public String ProtectProtocolKind_NoPreemption = "NoPreemption";
	public String ProtectProtocolKind_PriorityCeiling = "PriorityCeiling";
	public String ProtectProtocolKind_PriorityInheritance = "PriorityInheritance";
	public String ProtectProtocolKind_StackBased = "StackBased";
	public String ProtectProtocolKind_Undef = "Undef";
	public String ProtectProtocolKind_Other = "Other";
	// Enum SchedPolicykind
	public String SchedPolicykind = "InternalMarteLibrary::SchedPolicykind";
	public String SchedPolicykind_EarliestDeadlineFirst = "EarliestDeadlineFirst";
	public String SchedPolicykind_FIFO = "FIFO";
	public String SchedPolicykind_FixedPriority = "FixedPriority";
	public String SchedPolicykind_LeastLaxityFirst = "LeastLaxityFirst";
	public String SchedPolicykind_RoundRobin = "RoundRobin";
	public String SchedPolicykind_TimeTableDriven = "TimeTableDriven";
	public String SchedPolicykind_Undef = "Undef";
	public String SchedPolicykind_Other = "Other";
	// Enum TransmModeKind
	public String TransmModeKind = "InternalMarteLibrary::TransmModeKind";
	public String TransmModeKind_simplex = "simplex";
	public String TransmModeKind_halfduplex = "half-duplex";
	public String TransmModeKind_fullduplex = "full-duplex";
	/*
	 * Profile NFPs
	 */
	// <<Unit>>
	public String Unit = "NFPs::Unit";
	public String Unit_baseUnit = "baseUnit";
	public String Unit_convFactor = "convFactor";
	public String Unit_offsetFactor = "offsetFactor";
	// <<Nfp>>
	public String Nfp = "NFPs::Nfp";
	// Enum ConstraintKind
	public String ConstraintKind = "NFPs::ConstraintKind";
	public String ConstraintKind_required = "required";
	public String ConstraintKind_offered = "offered";
	public String ConstraintKind_contract = "contract";
	// <<NfpConstraint>>
	public String NfpConstraint = "NFPs::NfpConstraint";
	public String NfpConstraint_kind = "kind";
	// <<NfpType>>
	public String NfpType = "NFPs::NfpType";
	public String NfpType_valueAttrib = "valueAttrib";
	public String NfpType_unitAttrib = "unitAttrib";
	public String NfpType_exprAttrib = "exprAttrib";
	/*
	 * Profile PAM
	 */
	// <<PaResPassStep>>
	public String PaResPassStep = "PAM::PaResPassStep";
	public String PaResPassStep_resUnits = "resUnits";
	public String PaResPassStep_resource = "resource";
	// <<PaStep>>
	public String PaStep = "PAM::PaStep";
	public String PaStep_noSync = "noSync";
	public String PaStep_extOpDemands = "extOpDemands";
	public String PaStep_extOpCount = "extOpCount";
	public String PaStep_behavDemands = "behavDemands";
	public String PaStep_behavCount = "behavCount";
	// <<PaRequestedService>>
	public String PaRequestedService = "PAM::PaRequestedService";
	// <<PaCommStep>>
	public String PaCommStep = "PAM::PaCommStep";
	public String PaCommStep_msgSize = "msgSize";
	public String PaCommStep_concurResource = "concurResource";
	// <<PaLogicalResource>>
	public String PaLogicalResource = "PAM::PaLogicalResource";
	public String PaLogicalResource_utilization = "utilization";
	public String PaLogicalResource_throughput = "throughput";
	public String PaLogicalResource_poolSize = "poolSize";
	// <<PaRunTInstance>>
	public String PaRunTInstance = "PAM::PaRunTInstance";
	public String PaRunTInstance_poolSize = "poolSize";
	public String PaRunTInstance_unbddPool = "unbddPool";
	public String PaRunTInstance_instance = "instance";
	public String PaRunTInstance_host = "host";
	public String PaRunTInstance_utilization = "utilization";
	public String PaRunTInstance_throughput = "throughput";
	/*
	 * Profile RSM
	 */
	// <<Shaped>>
	public String Shaped = "RSM::Shaped";
	public String Shaped_shape = "shape";
	// <<LinkTopology>>
	public String LinkTopology = "RSM::LinkTopology";
	// <<DefaultLink>>
	public String DefaultLink = "RSM::DefaultLink";
	// <<Reshape>>
	public String Reshape = "RSM::Reshape";
	public String Reshape_patternShape = "patternShape";
	public String Reshape_repetitionSpace = "repetitionSpace";
	// <<Tiler>>
	public String Tiler = "RSM::Tiler";
	public String Tiler_origin = "origin";
	public String Tiler_paving = "paving";
	public String Tiler_fitting = "fitting";
	public String Tiler_tiler = "tiler";
	// <<InterRepetition>>
	public String InterRepetition = "RSM::InterRepetition";
	public String InterRepetition_repetitionSpaceDependence = "repetitionSpaceDependence";
	public String InterRepetition_isModulo = "isModulo";
	// <<Distribute>>
	public String Distribute = "RSM::Distribute";
	public String Distribute_patternShape = "patternShape";
	public String Distribute_repetitionSpace = "repetitionSpace";
	public String Distribute_fromTiler = "fromTiler";
	public String Distribute_toTiler = "toTiler";
	public String Distribute_kind = "kind";
	public String Distribute_nature = "nature";
	/*
	 * Profile RTEMoCC
	 */
	// Enum PoolMgtPolicyKind
	public String PoolMgtPolicyKind = "RTEMoCC::PoolMgtPolicyKind";
	public String PoolMgtPolicyKind_infiniteWait = "infiniteWait";
	public String PoolMgtPolicyKind_timedWait = "timedWait";
	public String PoolMgtPolicyKind_dynamic = "dynamic";
	public String PoolMgtPolicyKind_exception = "exception";
	public String PoolMgtPolicyKind_other = "other";
	// <<RtUnit>>
	public String RtUnit = "RTEMoCC::RtUnit";
	public String RtUnit_isDynamic = "isDynamic";
	public String RtUnit_isMain = "isMain";
	public String RtUnit_poolSize = "poolSize";
	public String RtUnit_poolPolicy = "poolPolicy";
	public String RtUnit_poolWaitingTime = "poolWaitingTime";
	public String RtUnit_operationalMode = "operationalMode";
	public String RtUnit_main = "main";
	public String RtUnit_memorySize = "memorySize";
	// Enum CallConcurrencyKind
	public String CallConcurrencyKind = "RTEMoCC::CallConcurrencyKind";
	public String CallConcurrencyKind_sequential = "sequential";
	public String CallConcurrencyKind_guarded = "guarded";
	public String CallConcurrencyKind_concurrent = "concurrent";
	// <<PpUnit>>
	public String PpUnit = "RTEMoCC::PpUnit";
	public String PpUnit_concPolicy = "concPolicy";
	public String PpUnit_memorySize = "memorySize";
	// <<RtBehavior>>
	public String RtBehavior = "RTEMoCC::RtBehavior";
	public String RtBehavior_queueSchedPolicy = "queueSchedPolicy";
	public String RtBehavior_queueSize = "queueSize";
	public String RtBehavior_msgMaxSize = "msgMaxSize";
	// <<rtf>>
	public String rtf = "RTEMoCC::rtf";
	public String rtf_utility = "utility";
	public String rtf_occkind = "occkind";
	public String rtf_tRef = "tRef";
	public String rtf_relDl = "relDl";
	public String rtf_absDl = "absDl";
	public String rtf_boundDl = "boundDl";
	public String rtf_rdTime = "rdTime";
	public String rtf_miss = "miss";
	public String rtf_priority = "priority";
	// <<RtAction>>
	public String RtAction = "RTEMoCC::RtAction";
	public String RtAction_isAtomic = "isAtomic";
	public String RtAction_msgSize = "msgSize";
	public String RtAction_synchKind = "synchKind";
	// Enum SynchronisationKind
	public String SynchronisationKind = "RTEMoCC::SynchronisationKind";
	public String SynchronisationKind_synchronous = "synchronous";
	public String SynchronisationKind_asynchronous = "asynchronous";
	public String SynchronisationKind_delayedSynchronous = "delayedSynchronous";
	public String SynchronisationKind_rendezVous = "rendezVous";
	public String SynchronisationKind_other = "other";
	// Enum ExecutionKind
	public String ExecutionKind = "RTEMoCC::ExecutionKind";
	public String ExecutionKind_deferred = "deferred";
	public String ExecutionKind_remoteImmediate = "remoteImmediate";
	public String ExecutionKind_localImmediate = "localImmediate";
	// Enum ConcurrencyKind
	public String ConcurrencyKind = "RTEMoCC::ConcurrencyKind";
	public String ConcurrencyKind_reader = "reader";
	public String ConcurrencyKind_writer = "writer";
	public String ConcurrencyKind_parallel = "parallel";
	// <<RtService>>
	public String RtService = "RTEMoCC::RtService";
	public String RtService_concPolicy = "concPolicy";
	public String RtService_exeKind = "exeKind";
	public String RtService_synchKind = "synchKind";
	public String RtService_isAtomic = "isAtomic";
	// <<RteConnector>>
	public String RteConnector = "RTEMoCC::RteConnector";
	public String RteConnector_bandwidth = "bandwidth";
	public String RteConnector_packetT = "packetT";
	public String RteConnector_blockT = "blockT";
	public String RteConnector_transmMode = "transmMode";
	/*
	 * Profile SAM
	 */
	// Enum OptimallityCriterionKind
	public String OptimallityCriterionKind = "SAM::OptimallityCriterionKind";
	public String OptimallityCriterionKind_meetHardDeadlines = "meetHardDeadlines";
	public String OptimallityCriterionKind_minimizeMissedDeadline = "minimizeMissedDeadline";
	public String OptimallityCriterionKind_minimizeMeanTardiness = "minimizeMeanTardiness";
	public String OptimallityCriterionKind_undef = "undef";
	public String OptimallityCriterionKind_other = "other";
	// <<SaAnalysisContext>>
	public String SaAnalysisContext = "SAM::SaAnalysisContext";
	public String SaAnalysisContext_isSched = "isSched";
	public String SaAnalysisContext_optCriterion = "optCriterion";
	// <<SaEnd2EndFlow>>
	public String SaEnd2EndFlow = "SAM::SaEnd2EndFlow";
	public String SaEnd2EndFlow_isSched = "isSched";
	public String SaEnd2EndFlow_schSlack = "schSlack";
	public String SaEnd2EndFlow_end2EndT = "end2EndT";
	public String SaEnd2EndFlow_end2EndD = "end2EndD";
	public String SaEnd2EndFlow_timing = "timing";
	// <<SaCommStep>>
	public String SaCommStep = "SAM::SaCommStep";
	public String SaCommStep_deadline = "deadline";
	public String SaCommStep_spareCap = "spareCap";
	public String SaCommStep_schSlack = "schSlack";
	// <<SaStep>>
	public String SaStep = "SAM::SaStep";
	public String SaStep_deadline = "deadline";
	public String SaStep_spareCap = "spareCap";
	public String SaStep_schSlack = "schSlack";
	public String SaStep_preempT = "preempT";
	public String SaStep_readyT = "readyT";
	public String SaStep_delayT = "delayT";
	// <<SaSchedObs>>
	public String SaSchedObs = "SAM::SaSchedObs";
	public String SaSchedObs_suspensions = "suspensions";
	public String SaSchedObs_blockT = "blockT";
	public String SaSchedObs_overlaps = "overlaps";
	// <<SaSharedResource>>
	public String SaSharedResource = "SAM::SaSharedResource";
	public String SaSharedResource_capacity = "capacity";
	public String SaSharedResource_isPreemp = "isPreemp";
	public String SaSharedResource_isConsum = "isConsum";
	public String SaSharedResource_acquisiT = "acquisiT";
	public String SaSharedResource_releaseT = "releaseT";
	// <<SaCommHost>>
	public String SaCommHost = "SAM::SaCommHost";
	public String SaCommHost_isSched = "isSched";
	public String SaCommHost_schSlack = "schSlack";
	// <<SaExecHost>>
	public String SaExecHost = "SAM::SaExecHost";
	public String SaExecHost_isSched = "isSched";
	public String SaExecHost_schSlack = "schSlack";
	public String SaExecHost_schedUtiliz = "schedUtiliz";
	public String SaExecHost_ISRswitchT = "ISRswitchT";
	public String SaExecHost_schedPolicy = "schedPolicy";
	public String SaExecHost_isPreemptible = "isPreemptible";
	public String SaExecHost_ISRprioRange = "ISRprioRange";
	/*
	 * Profile SRM
	 */
	// <<SwResource>>
	public String SwResource = "SRM::SwResource";
	public String SwResource_identifierElements = "identifierElements";
	public String SwResource_stateElements = "stateElements";
	public String SwResource_memorySizeFootprint = "memorySizeFootprint";
	public String SwResource_createServices = "createServices";
	public String SwResource_deleteServices = "deleteServices";
	public String SwResource_initializeServices = "initializeServices";
	// <<SwAccessService>>
	public String SwAccessService = "SRM::SwAccessService";
	public String SwAccessService_isModifier = "isModifier";
	public String SwAccessService_accessedElement = "accessedElement";
	// <<EntryPoint>>
	public String EntryPoint = "SRM::EntryPoint";
	public String EntryPoint_isReentrant = "isReentrant";
	public String EntryPoint_routine = "routine";
	// Enum InterruptKind
	public String InterruptKind = "SRM::InterruptKind";
	public String InterruptKind_HardwareInterrupt = "HardwareInterrupt";
	public String InterruptKind_ProcessorDetectedException = "ProcessorDetectedException";
	public String InterruptKind_ProgrammedException = "ProgrammedException";
	public String InterruptKind_Undef = "Undef";
	public String InterruptKind_Other = "Other";
	// <<MemoryPartition>>
	public String MemoryPartition = "SRM::MemoryPartition";
	public String MemoryPartition_concurrentResources = "concurrentResources";
	public String MemoryPartition_memorySpaces = "memorySpaces";
	public String MemoryPartition_forkServices = "forkServices";
	public String MemoryPartition_exitServices = "exitServices";
	// <<SwTimerResource>>
	public String SwTimerResource = "SRM::SwTimerResource";
	public String SwTimerResource_DurationElements = "DurationElements";
	// <<SwConcurrentResource>>
	public String SwConcurrentResource = "SRM::SwConcurrentResource";
	public String SwConcurrentResource_type = "type";
	public String SwConcurrentResource_activationCapacity = "activationCapacity";
	public String SwConcurrentResource_entryPoints = "entryPoints";
	public String SwConcurrentResource_addressSpace = "addressSpace";
	public String SwConcurrentResource_periodElements = "periodElements";
	public String SwConcurrentResource_priorityElements = "priorityElements";
	public String SwConcurrentResource_stackSizeElements = "stackSizeElements";
	public String SwConcurrentResource_shareDataResources = "shareDataResources";
	public String SwConcurrentResource_messageResources = "messageResources";
	public String SwConcurrentResource_mutualExclusionResources = "mutualExclusionResources";
	public String SwConcurrentResource_notificationResources = "notificationResources";
	public String SwConcurrentResource_activateServices = "activateServices";
	public String SwConcurrentResource_enableConcurrencyServices = "enableConcurrencyServices";
	public String SwConcurrentResource_resumeServices = "resumeServices";
	public String SwConcurrentResource_suspendServices = "suspendServices";
	public String SwConcurrentResource_terminateServices = "terminateServices";
	public String SwConcurrentResource_disableConcurrencyServices = "disableConcurrencyServices";
	// <<InterruptResource>>
	public String InterruptResource = "SRM::InterruptResource";
	public String InterruptResource_kind = "kind";
	public String InterruptResource_isMaskable = "isMaskable";
	public String InterruptResource_vectorElements = "vectorElements";
	public String InterruptResource_maskElements = "maskElements";
	public String InterruptResource_routineConnect = "routineConnect";
	public String InterruptResource_routineDisconnect = "routineDisconnect";
	// <<Alarm>>
	public String Alarm = "SRM::Alarm";
	public String Alarm_isWatchdog = "isWatchdog";
	public String Alarm_timers = "timers";
	// <<SwSchedulableResource>>
	public String SwSchedulableResource = "SRM::SwSchedulableResource";
	public String SwSchedulableResource_isStaticSchedulingFeature = "isStaticSchedulingFeature";
	public String SwSchedulableResource_isPreemptable = "isPreemptable";
	public String SwSchedulableResource_deadlineElements = "deadlineElements";
	public String SwSchedulableResource_deadlineTypeElements = "deadlineTypeElements";
	public String SwSchedulableResource_timeSliceElements = "timeSliceElements";
	public String SwSchedulableResource_delayServices = "delayServices";
	public String SwSchedulableResource_joinServices = "joinServices";
	public String SwSchedulableResource_yieldServices = "yieldServices";
	public String SwSchedulableResource_scheduler = "scheduler";
	// <<SwInteractionResource>>
	public String SwInteractionResource = "SRM::SwInteractionResource";
	public String SwInteractionResource_isIntraMemoryPartitionInteraction = "isIntraMemoryPartitionInteraction";
	public String SwInteractionResource_waitingQueueCapacity = "waitingQueueCapacity";
	public String SwInteractionResource_waitingQueuePolicy = "waitingQueuePolicy";
	public String SwInteractionResource_waitingPolicyElements = "waitingPolicyElements";
	// Enum QueuePolicyKind
	public String QueuePolicyKind = "SRM::QueuePolicyKind";
	public String QueuePolicyKind_FIFO = "FIFO";
	public String QueuePolicyKind_LIFO = "LIFO";
	public String QueuePolicyKind_Priority = "Priority";
	public String QueuePolicyKind_Undef = "Undef";
	public String QueuePolicyKind_Other = "Other";
	// Enum MessageResourceKind
	public String MessageResourceKind = "SRM::MessageResourceKind";
	public String MessageResourceKind_MessageQueue = "MessageQueue";
	public String MessageResourceKind_Pipe = "Pipe";
	public String MessageResourceKind_Blackboard = "Blackboard";
	public String MessageResourceKind_Undef = "Undef";
	public String MessageResourceKind_Other = "Other";
	// Enum NotificationKind
	public String NotificationKind = "SRM::NotificationKind";
	public String NotificationKind_Memorized = "Memorized";
	public String NotificationKind_Bounded = "Bounded";
	public String NotificationKind_Memoryless = "Memoryless";
	public String NotificationKind_Undef = "Undef";
	public String NotificationKind_Other = "Other";
	// Enum NotificationResourceKind
	public String NotificationResourceKind = "SRM::NotificationResourceKind";
	public String NotificationResourceKind_Event = "Event";
	public String NotificationResourceKind_Barrier = "Barrier";
	public String NotificationResourceKind_Undef = "Undef";
	public String NotificationResourceKind_Other = "Other";
	// Enum MutualExclusionResourceKind
	public String MutualExclusionResourceKind = "SRM::MutualExclusionResourceKind";
	public String MutualExclusionResourceKind_BooleanSemaphore = "BooleanSemaphore";
	public String MutualExclusionResourceKind_CountSemaphore = "CountSemaphore";
	public String MutualExclusionResourceKind_Mutex = "Mutex";
	public String MutualExclusionResourceKind_Undef = "Undef";
	public String MutualExclusionResourceKind_Other = "Other";
	// <<SwCommunicationResource>>
	public String SwCommunicationResource = "SRM::SwCommunicationResource";
	// <<SharedDataComResource>>
	public String SharedDataComResource = "SRM::SharedDataComResource";
	public String SharedDataComResource_readServices = "readServices";
	public String SharedDataComResource_writeServices = "writeServices";
	// <<MessageComResource>>
	public String MessageComResource = "SRM::MessageComResource";
	public String MessageComResource_isFixedMessageSize = "isFixedMessageSize";
	public String MessageComResource_mechanism = "mechanism";
	public String MessageComResource_messageSizeElements = "messageSizeElements";
	public String MessageComResource_messageQueueCapacityElements = "messageQueueCapacityElements";
	public String MessageComResource_messageQueuePolicy = "messageQueuePolicy";
	public String MessageComResource_sendServices = "sendServices";
	public String MessageComResource_receiveServices = "receiveServices";
	// <<SwSynchronizationResource>>
	public String SwSynchronizationResource = "SRM::SwSynchronizationResource";
	// <<NotificationResource>>
	public String NotificationResource = "SRM::NotificationResource";
	public String NotificationResource_occurenceKind = "occurenceKind";
	public String NotificationResource_mechanism = "mechanism";
	public String NotificationResource_occurenceCountElements = "occurenceCountElements";
	public String NotificationResource_maskElements = "maskElements";
	public String NotificationResource_flushServices = "flushServices";
	public String NotificationResource_signalServices = "signalServices";
	public String NotificationResource_waitServices = "waitServices";
	public String NotificationResource_clearServices = "clearServices";
	// <<SwMutualExclusionResource>>
	public String SwMutualExclusionResource = "SRM::SwMutualExclusionResource";
	public String SwMutualExclusionResource_mechanism = "mechanism";
	public String SwMutualExclusionResource_concurrentAccessProtocol = "concurrentAccessProtocol";
	public String SwMutualExclusionResource_accessTokenElements = "accessTokenElements";
	public String SwMutualExclusionResource_releaseServices = "releaseServices";
	public String SwMutualExclusionResource_acquireServices = "acquireServices";
	// Enum ConcurrentAccessProtocolKind
	public String ConcurrentAccessProtocolKind = "SRM::ConcurrentAccessProtocolKind";
	public String ConcurrentAccessProtocolKind_PIP = "PIP";
	public String ConcurrentAccessProtocolKind_PCP = "PCP";
	public String ConcurrentAccessProtocolKind_NoPreemption = "NoPreemption";
	public String ConcurrentAccessProtocolKind_Other = "Other";
	public String ConcurrentAccessProtocolKind_Undef = "Undef";
	// <<DeviceBroker>>
	public String DeviceBroker = "SRM::DeviceBroker";
	public String DeviceBroker_accessPolicy = "accessPolicy";
	public String DeviceBroker_isBuffered = "isBuffered";
	public String DeviceBroker_devices = "devices";
	public String DeviceBroker_closeServices = "closeServices";
	public String DeviceBroker_controlServices = "controlServices";
	public String DeviceBroker_openServices = "openServices";
	public String DeviceBroker_readServices = "readServices";
	public String DeviceBroker_writeServices = "writeServices";
	// Enum AccessPolicyKind
	public String AccessPolicyKind = "SRM::AccessPolicyKind";
	public String AccessPolicyKind_Read = "Read";
	public String AccessPolicyKind_Write = "Write";
	public String AccessPolicyKind_ReadWrite = "ReadWrite";
	public String AccessPolicyKind_Undef = "Undef";
	public String AccessPolicyKind_Other = "Other";
	// <<MemoryBroker>>
	public String MemoryBroker = "SRM::MemoryBroker";
	public String MemoryBroker_accessPolicy = "accessPolicy";
	public String MemoryBroker_memories = "memories";
	public String MemoryBroker_memoryBlockAddressElements = "memoryBlockAddressElements";
	public String MemoryBroker_memoryBlockSizeElements = "memoryBlockSizeElements";
	public String MemoryBroker_lockServices = "lockServices";
	public String MemoryBroker_unlockServices = "unlockServices";
	public String MemoryBroker_mapServices = "mapServices";
	public String MemoryBroker_unMapServices = "unMapServices";
	/*
	 * Profile Time
	 */
	// <<TimedDomain>>
	public String TimedDomain = "Time::TimedDomain";
	// <<Clock>>
	public String Clock = "Time::Clock";
	public String Clock_standard = "standard";
	public String Clock_unit = "unit";
	public String Clock_type = "type";
	// <<ClockType>>
	public String ClockType = "Time::ClockType";
	public String ClockType_nature = "nature";
	public String ClockType_unitType = "unitType";
	public String ClockType_isLogical = "isLogical";
	public String ClockType_resolAttr = "resolAttr";
	public String ClockType_maxValAttr = "maxValAttr";
	public String ClockType_offsetAttr = "offsetAttr";
	public String ClockType_getTime = "getTime";
	public String ClockType_setTime = "setTime";
	public String ClockType_indexToValue = "indexToValue";
	// <<TimedValueSpecification>>
	public String TimedValueSpecification = "Time::TimedValueSpecification";
	public String TimedValueSpecification_interpretation = "interpretation";
	// <<TimedElement>>
	public String TimedElement = "Time::TimedElement";
	public String TimedElement_on = "on";
	// <<TimedConstraint>>
	public String TimedConstraint = "Time::TimedConstraint";
	public String TimedConstraint_interpretation = "interpretation";
	// <<ClockConstraint>>
	public String ClockConstraint = "Time::ClockConstraint";
	// <<TimedObservation>>
	public String TimedObservation = "Time::TimedObservation";
	// <<TimedInstantObservation>>
	public String TimedInstantObservation = "Time::TimedInstantObservation";
	public String TimedInstantObservation_obsKind = "obsKind";
	// <<TimedDurationObservation>>
	public String TimedDurationObservation = "Time::TimedDurationObservation";
	public String TimedDurationObservation_obsKind = "obsKind";
	// <<TimedEvent>>
	public String TimedEvent = "Time::TimedEvent";
	public String TimedEvent_repetition = "repetition";
	public String TimedEvent_every = "every";
	// <<TimedProcessing>>
	public String TimedProcessing = "Time::TimedProcessing";
	public String TimedProcessing_start = "start";
	public String TimedProcessing_finish = "finish";
	public String TimedProcessing_duration = "duration";
	/*
	 * Profile VSL
	 */
	// <<IntervalType>>
	public String IntervalType = "VSL::IntervalType";
	public String IntervalType_intervalAttrib = "intervalAttrib";
	// <<CollectionType>>
	public String CollectionType = "VSL::CollectionType";
	public String CollectionType_collectionAttrib = "collectionAttrib";
	// <<TupleType>>
	public String TupleType = "VSL::TupleType";
	public String TupleType_tupleAttrib = "tupleAttrib";
	// <<ChoiceType>>
	public String ChoiceType = "VSL::ChoiceType";
	public String ChoiceType_choiceType = "choiceType";
	public String ChoiceType_defaultAttrib = "defaultAttrib";
	// <<BoundedSubType>>
	public String BoundedSubType = "VSL::BoundedSubType";
	public String BoundedSubType_baseType = "baseType";
	public String BoundedSubType_minValue = "minValue";
	public String BoundedSubType_maxValue = "maxValue";
	public String BoundedSubType_isMinOpen = "isMinOpen";
	public String BoundedSubType_isMaxOpen = "isMaxOpen";
	// <<Var>>
	public String Var = "VSL::Var";
	public String Var_dir = "dir";
	// <<ExpressionContext>>
	public String ExpressionContext = "VSL::ExpressionContext";
	// Enum VariableDirectionKind
	public String VariableDirectionKind = "VSL::VariableDirectionKind";
	public String VariableDirectionKind_in = "in";
	public String VariableDirectionKind_out = "out";
	public String VariableDirectionKind_inout = "inout";

}
