/**
 * <copyright>
 * Thales ATL (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales MARTE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: MARTEImplementation.java,v 1.6 2008/06/24 12:34:18 sheywood Exp $
 */
package com.thalesgroup.atl.marte;

/**
 * Specificities of MARTE Implementation
 * @author Eric MAES
 */
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.thalesgroup.atl.exception.ATLException;

public abstract class MARTEImplementation {
	
	protected String MARTE_ATL_LIBRARY_PATH="/libraries/MARTE.asm";
	protected MARTE marte=null;
	protected IATLConstantsLoader atlConstantsLoader=null;
	
	public MARTEImplementation(String MARTE_ATL_LIBRARY_PATH, MARTE marte, IATLConstantsLoader atlConstantsLoader) {
		this.MARTE_ATL_LIBRARY_PATH = MARTE_ATL_LIBRARY_PATH;
		this.marte = marte;
		this.atlConstantsLoader = atlConstantsLoader;
	}
	
	public void Load() throws ATLException {
		if (atlConstantsLoader!=null) {
			atlConstantsLoader.Load();
		}
		else {
			throw new ATLException("ATL Constants Loader is not initialized");
		}
			
	}
	
	public MARTE getConstants() throws ATLException {
		if (marte != null) {
			return marte;
		}
		else {
			throw new ATLException("MARTE implementation is not initialized");
		}
	}
	
	public abstract String getLibraryPath() throws ATLException;
	
	public abstract IModelFacade getFacade(Element element) throws ATLException;
	
	public abstract ValueSpecification getPropertyValue(Element element, Property property, Object propertyValue) throws ATLException;
	
	public abstract boolean isRSA();
	
	public abstract boolean isPAPYRUS();
}
