/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: TaskItemProviderAdapterFactory.java,v 1.2 2008/06/16 13:56:00 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.task.provider;

import com.thalesgroup.marte.rapidrma.task.util.TaskAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TaskItemProviderAdapterFactory extends TaskAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TaskItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);		
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.Task} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskItemProvider taskItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.Task}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTaskAdapter() {
		if (taskItemProvider == null) {
			taskItemProvider = new TaskItemProvider(this);
		}

		return taskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntermediateDeadlineItemProvider intermediateDeadlineItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.IntermediateDeadline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIntermediateDeadlineAdapter() {
		if (intermediateDeadlineItemProvider == null) {
			intermediateDeadlineItemProvider = new IntermediateDeadlineItemProvider(this);
		}

		return intermediateDeadlineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NonPremptibleSectionItemProvider nonPremptibleSectionItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.NonPremptibleSection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNonPremptibleSectionAdapter() {
		if (nonPremptibleSectionItemProvider == null) {
			nonPremptibleSectionItemProvider = new NonPremptibleSectionItemProvider(this);
		}

		return nonPremptibleSectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.ResourceUsage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceUsageItemProvider resourceUsageItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.ResourceUsage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createResourceUsageAdapter() {
		if (resourceUsageItemProvider == null) {
			resourceUsageItemProvider = new ResourceUsageItemProvider(this);
		}

		return resourceUsageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.PeriodicServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicServerItemProvider periodicServerItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.PeriodicServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPeriodicServerAdapter() {
		if (periodicServerItemProvider == null) {
			periodicServerItemProvider = new PeriodicServerItemProvider(this);
		}

		return periodicServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.Deterministic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeterministicItemProvider deterministicItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.Deterministic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDeterministicAdapter() {
		if (deterministicItemProvider == null) {
			deterministicItemProvider = new DeterministicItemProvider(this);
		}

		return deterministicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.Uniform} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UniformItemProvider uniformItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.Uniform}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createUniformAdapter() {
		if (uniformItemProvider == null) {
			uniformItemProvider = new UniformItemProvider(this);
		}

		return uniformItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.Exponential} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExponentialItemProvider exponentialItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.Exponential}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createExponentialAdapter() {
		if (exponentialItemProvider == null) {
			exponentialItemProvider = new ExponentialItemProvider(this);
		}

		return exponentialItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link com.thalesgroup.marte.rapidrma.task.TaskGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskGraphItemProvider taskGraphItemProvider;

	/**
	 * This creates an adapter for a {@link com.thalesgroup.marte.rapidrma.task.TaskGraph}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTaskGraphAdapter() {
		if (taskGraphItemProvider == null) {
			taskGraphItemProvider = new TaskGraphItemProvider(this);
		}

		return taskGraphItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (taskItemProvider != null) taskItemProvider.dispose();
		if (intermediateDeadlineItemProvider != null) intermediateDeadlineItemProvider.dispose();
		if (nonPremptibleSectionItemProvider != null) nonPremptibleSectionItemProvider.dispose();
		if (resourceUsageItemProvider != null) resourceUsageItemProvider.dispose();
		if (periodicServerItemProvider != null) periodicServerItemProvider.dispose();
		if (deterministicItemProvider != null) deterministicItemProvider.dispose();
		if (uniformItemProvider != null) uniformItemProvider.dispose();
		if (exponentialItemProvider != null) exponentialItemProvider.dispose();
		if (taskGraphItemProvider != null) taskGraphItemProvider.dispose();
	}

}
