/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 * 
 */

/**
 * Console for displaying Log messages
 * @author Eric MAES
 */

package com.thalesgroup.java.log;

import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LogConsole extends MessageConsole {
	
		protected MessageConsoleStream okStream;
		
		protected MessageConsoleStream infoStream;
		protected Color infoColor = new Color(null,0,0,255);
		
		protected MessageConsoleStream warningStream;
		protected Color warningColor = new Color(null,255,0,0);
		
		protected MessageConsoleStream errorStream;
		protected Color errorColor = new Color(null,255,0,0);
		
		public LogConsole() {
			super("Thalesgroup Log Console",null);
			this.setWaterMarks(10000, 100000);
			okStream = this.newMessageStream();
			okStream.setActivateOnWrite(true);
			okStream.println("***********************************");
			okStream.println("***** Thalesgroup Log Console *****");
			okStream.println("***********************************");
			infoStream = this.newMessageStream();
			infoStream.setActivateOnWrite(true);
			infoStream.setColor(infoColor);
			warningStream = this.newMessageStream();
			warningStream.setActivateOnWrite(true);
			warningStream.setColor(warningColor);
			errorStream = this.newMessageStream();
			errorStream.setActivateOnWrite(true);
			errorStream.setColor(errorColor);
		}
		
		public void display (String text, int severity){
			MessageConsoleStream selectedStream = okStream;
			switch (severity) {
				case Status.OK : selectedStream = okStream; break;
				case Status.INFO : selectedStream = infoStream; break;
				case Status.WARNING : selectedStream = warningStream; break;
				case Status.ERROR : selectedStream = errorStream; break;
			}
			try {
				if (selectedStream.isClosed()) {
					Log.setDisplayConsole(false);
					String errorMessage = "Error writing in the Log Console : "+text.toString();
					Log.errorMessage(Activator.PLUGIN_ID, errorMessage, null);
				} else {
					selectedStream.println(text);
				}
			}
			catch (Exception exception) {
				Log.setDisplayConsole(false);
				String errorMessage = "Error writing in the Log Console : "+text.toString();
				Log.errorMessage(Activator.PLUGIN_ID, errorMessage, exception);
			}
		}
}
