/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 * 
 */

package com.thalesgroup.java.log;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**ac
 * Preference page to display Log options.
 * @author maes
 *
 */
public class LogPreferencePage extends FieldEditorPreferencePage  implements IWorkbenchPreferencePage {
	
	private static RadioGroupFieldEditor logProfile;
	public static final String LOG_PROFILE = "LogPreferencePage.logProfile";
	
	private static BooleanFieldEditor displayConsole;
	public static final String LOG_DISPLAY_CONSOLE = "LogPreferencePage.logDisplayConsole";
	private static BooleanFieldEditor displayErrorLog;
	public static final String LOG_DISPLAY_ERRORLOG = "LogPreferencePage.logDisplayErrorLog";
	private static BooleanFieldEditor displayFile;
	public static final String LOG_DISPLAY_FILE = "LogPreferencePage.logDisplayFile";
	private static DirectoryFieldEditor fileDirectory;
	public static final String LOG_FILE_DIRECTORY = "LogPreferencePage.logFileDirectory";
	private static StringFieldEditor fileName;
	public static final String LOG_FILE_NAME = "LogPreferencePage.logFileName";
	
	public static final String PROFILE_LABEL_USER = "USER";
	public static final String PROFILE_LABEL_DEVELOPPER = "DEVELOPPER";
	public static final String PROFILE_LABEL_DEBUGGER = "DEBUGGER";
	public static final String PROFILE_LABEL_DEMONSTRATOR = "DEMONSTRATOR";
	
	public LogPreferencePage() {
		super(GRID);
		IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
		setPreferenceStore(preferenceStore);
		setDescription("Set the Log preferences");
	}
	
	public void createFieldEditors() {
		
		String[][] labelsAndValues = new String[][] {
			     {PROFILE_LABEL_USER, Log.PROFILE_USER.toString()},
			     {PROFILE_LABEL_DEMONSTRATOR, Log.PROFILE_DEMONSTRATOR.toString()},
			     {PROFILE_LABEL_DEVELOPPER, Log.PROFILE_DEVELOPPER.toString()},
			     {PROFILE_LABEL_DEBUGGER, Log.PROFILE_DEBUGGER.toString()}
			     };
		
		logProfile = new RadioGroupFieldEditor(
				"LogPreferences.LogProfile",
				"Specify the desired log profile",
				1,
				labelsAndValues,
				getFieldEditorParent(),
				true);
	    logProfile.setPreferenceName(LOG_PROFILE);
		addField(logProfile);
		
		displayConsole = new BooleanFieldEditor(LOG_DISPLAY_CONSOLE,"Display log messages in console",getFieldEditorParent());
		addField(displayConsole);
		
		displayErrorLog = new BooleanFieldEditor(LOG_DISPLAY_ERRORLOG,"Display log messages in ErrorLog",getFieldEditorParent());
		addField(displayErrorLog);
		
		displayFile = new BooleanFieldEditor(LOG_DISPLAY_FILE,"Write log messages in a file",getFieldEditorParent());
		addField(displayFile);
		
		fileDirectory = new DirectoryFieldEditor(LOG_FILE_DIRECTORY,"Select the directory of the log file",getFieldEditorParent());
		addField(fileDirectory);
		
		fileName = new StringFieldEditor(LOG_FILE_NAME,"Name of the log file",getFieldEditorParent());
		addField(fileName);
	}
	
	public void init(IWorkbench workbench) {
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
	}
	
	public boolean performOK() {
		logProfile.store();
		Log.setFilePath(fileDirectory.getStringValue(),fileName.getStringValue());	
		return true;
	}
	
	public void propertyChange(PropertyChangeEvent event) {
		super.propertyChange(event);
		if (event.getSource() instanceof RadioGroupFieldEditor) {
			RadioGroupFieldEditor eventRadioGroupFieldEditor = (RadioGroupFieldEditor) event.getSource();
			if (eventRadioGroupFieldEditor.getPreferenceName() == LOG_PROFILE) {
				Log.config(new Integer(event.getNewValue().toString()).intValue());
			}
		}
		if (event.getSource() instanceof BooleanFieldEditor) {
			BooleanFieldEditor eventBooleanFieldEditor = (BooleanFieldEditor) event.getSource();
			if (eventBooleanFieldEditor.getPreferenceName() == LOG_DISPLAY_CONSOLE) {
				Log.setDisplayConsole(new Boolean(event.getNewValue().toString()).booleanValue());	
			}
			if (eventBooleanFieldEditor.getPreferenceName() == LOG_DISPLAY_ERRORLOG) {
				Log.setDisplayErrorLog(new Boolean(event.getNewValue().toString()).booleanValue());	
			}
			if (eventBooleanFieldEditor.getPreferenceName() == LOG_DISPLAY_FILE) {
				Log.setDisplayFile(new Boolean(event.getNewValue().toString()).booleanValue());	
			}
		}
	}

}
