/**
 * <copyright>
 * Thales ATL for MARTE with RSA (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales MARTE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: ATLConstantsLoader_MARTE4RSA.java,v 1.2 2007/11/21 13:59:59 emaes Exp $
 */
package com.thalesgroup.atl.marte.rsa;
import com.thalesgroup.atl.ATLTransform;
import com.thalesgroup.atl.marte.IATLConstantsLoader;

import org.atl.engine.vm.StackFrame;
import org.atl.engine.vm.nativelib.ASMModelElement;
import org.atl.engine.vm.nativelib.ASMString;
/** 
 * Constants loader of MARTE4RSA
 * Copyright 2007 Thales Research and Technology
 * Generated on Tue Oct 23 08:57:17 CEST 2007
 */
public class ATLConstantsLoader_MARTE4RSA implements IATLConstantsLoader {
  public static ASMString Allocated(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::Allocated");
  }
  public static ASMString ApplicationAllocationEnd(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::ApplicationAllocationEnd");
  }
  public static ASMString ApplicationAllocationEnd_allocatedTo(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("allocatedTo");
  }
  public static ASMString ExecutionPlatformAllocationEnd(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::ExecutionPlatformAllocationEnd");
  }
  public static ASMString ExecutionPlatformAllocationEnd_allocatedFrom(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("allocatedFrom");
  }
  public static ASMString AllocationNature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::AllocationNature");
  }
  public static ASMString AllocationNature_spatialDistribution(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("spatialDistribution");
  }
  public static ASMString AllocationNature_timeScheduling(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timeScheduling");
  }
  public static ASMString AllocationKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::AllocationKind");
  }
  public static ASMString AllocationKind_structural(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("structural");
  }
  public static ASMString AllocationKind_behavioral(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("behavioral");
  }
  public static ASMString AllocationKind_hybrid(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("hybrid");
  }
  public static ASMString Allocate(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::Allocate");
  }
  public static ASMString Allocate_kind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("kind");
  }
  public static ASMString Allocate_nature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nature");
  }
  public static ASMString Allocate_impliedConstraint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("impliedConstraint");
  }
  public static ASMString AllocateActivityGroup(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::AllocateActivityGroup");
  }
  public static ASMString AllocateActivityGroup_isUnique(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isUnique");
  }
  public static ASMString ClockRefine(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Alloc::ClockRefine");
  }
  public static ASMString ClockRefine_constraints(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("constraints");
  }
  public static ASMString DirectionKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::DirectionKind");
  }
  public static ASMString DirectionKind_in(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("in");
  }
  public static ASMString DirectionKind_out(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("out");
  }
  public static ASMString DirectionKind_inout(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("inout");
  }
  public static ASMString FlowProperty(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::FlowProperty");
  }
  public static ASMString FlowProperty_direction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("direction");
  }
  public static ASMString FlowPort(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::FlowPort");
  }
  public static ASMString FlowPort_isAtomic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isAtomic");
  }
  public static ASMString FlowPort_isConjugated(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isConjugated");
  }
  public static ASMString FlowPort_direction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("direction");
  }
  public static ASMString MsgPort(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::MsgPort");
  }
  public static ASMString MsgPort_isAtomic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isAtomic");
  }
  public static ASMString MsgPort_isConjugated(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isConjugated");
  }
  public static ASMString MsgPort_direction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("direction");
  }
  public static ASMString FlowSendAction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::FlowSendAction");
  }
  public static ASMString FlowSpecification(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::FlowSpecification");
  }
  public static ASMString ServiceSpecification(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::ServiceSpecification");
  }
  public static ASMString SignalSpecification(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GCM::SignalSpecification");
  }
  public static ASMString SignalSpecification_direction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("direction");
  }
  public static ASMString GaWorkloadBehavior(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaWorkloadBehavior");
  }
  public static ASMString GaWorkloadBehavior_behavior(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("behavior");
  }
  public static ASMString GaWorkloadBehavior_demand(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("demand");
  }
  public static ASMString GaAnalysisContext(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaAnalysisContext");
  }
  public static ASMString GaAnalysisContext_contextParams(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("contextParams");
  }
  public static ASMString GaAnalysisContext_workload(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("workload");
  }
  public static ASMString GaAnalysisContext_platform(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("platform");
  }
  public static ASMString GaResourcesPlatform(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaResourcesPlatform");
  }
  public static ASMString GaResourcesPlatform_resources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resources");
  }
  public static ASMString GaEventTrace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaEventTrace");
  }
  public static ASMString GaEventTrace_content(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("content");
  }
  public static ASMString GaEventTrace_format(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("format");
  }
  public static ASMString GaEventTrace_location(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("location");
  }
  public static ASMString GaEventTrace_stream(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("stream");
  }
  public static ASMString GaWorkloadEvent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaWorkloadEvent");
  }
  public static ASMString GaWorkloadEvent_pattern(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("pattern");
  }
  public static ASMString GaWorkloadEvent_generator(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("generator");
  }
  public static ASMString GaWorkloadEvent_trace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("trace");
  }
  public static ASMString GaWorkloadEvent_timeEvent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timeEvent");
  }
  public static ASMString GaWorkloadGenerator(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaWorkloadGenerator");
  }
  public static ASMString GaWorkloadGenerator_pop(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("pop");
  }
  public static ASMString GaScenario(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaScenario");
  }
  public static ASMString GaScenario_root(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("root");
  }
  public static ASMString GaScenario_hostDemand(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("hostDemand");
  }
  public static ASMString GaScenario_hostDemandOps(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("hostDemandOps");
  }
  public static ASMString GaScenario_interOccT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("interOccT");
  }
  public static ASMString GaScenario_throughput(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("throughput");
  }
  public static ASMString GaScenario_respT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("respT");
  }
  public static ASMString GaScenario_utilization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilization");
  }
  public static ASMString GaScenario_utilizationOnhost(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilizationOnhost");
  }
  public static ASMString GaScenario_steps(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("steps");
  }
  public static ASMString GaScenario_cause(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("cause");
  }
  public static ASMString GaScenario_timing(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timing");
  }
  public static ASMString GaStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaStep");
  }
  public static ASMString GaStep_isAtomic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isAtomic");
  }
  public static ASMString GaStep_blockT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blockT");
  }
  public static ASMString GaStep_rep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("rep");
  }
  public static ASMString GaStep_prob(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("prob");
  }
  public static ASMString GaStep_priority(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("priority");
  }
  public static ASMString GaStep_servCount(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("servCount");
  }
  public static ASMString GaStep_concurRes(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concurRes");
  }
  public static ASMString GaStep_host(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("host");
  }
  public static ASMString GaStep_servDemand(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("servDemand");
  }
  public static ASMString GaStep_behavior(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("behavior");
  }
  public static ASMString GaRequestedService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaRequestedService");
  }
  public static ASMString GaCommStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaCommStep");
  }
  public static ASMString GaCommStep_msgSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("msgSize");
  }
  public static ASMString GaAcqStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaAcqStep");
  }
  public static ASMString GaAcqStep_resUnits(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resUnits");
  }
  public static ASMString GaAcqStep_acqRes(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("acqRes");
  }
  public static ASMString GaRelStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaRelStep");
  }
  public static ASMString GaRelStep_relRes(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("relRes");
  }
  public static ASMString GaRelStep_resUnits(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resUnits");
  }
  public static ASMString LaxityKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::LaxityKind");
  }
  public static ASMString LaxityKind_hard(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("hard");
  }
  public static ASMString LaxityKind_soft(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("soft");
  }
  public static ASMString LaxityKind_other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("other");
  }
  public static ASMString GaTimingObs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaTimingObs");
  }
  public static ASMString GaTimingObs_laxity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("laxity");
  }
  public static ASMString GaTimingObs_startEvent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("startEvent");
  }
  public static ASMString GaTimingObs_endEvent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("endEvent");
  }
  public static ASMString GaLatencyObs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaLatencyObs");
  }
  public static ASMString GaLatencyObs_latency(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("latency");
  }
  public static ASMString GaLatencyObs_miss(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("miss");
  }
  public static ASMString GaLatencyObs_utility(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utility");
  }
  public static ASMString GaLatencyObs_maxJitter(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("maxJitter");
  }
  public static ASMString GaExecHost(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaExecHost");
  }
  public static ASMString GaExecHost_commTxOvh(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("commTxOvh");
  }
  public static ASMString GaExecHost_commRcvOvh(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("commRcvOvh");
  }
  public static ASMString GaExecHost_cntxtSwT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("cntxtSwT");
  }
  public static ASMString GaExecHost_clockOvh(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("clockOvh");
  }
  public static ASMString GaExecHost_memSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memSize");
  }
  public static ASMString GaExecHost_utilization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilization");
  }
  public static ASMString GaExecHost_throughput(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("throughput");
  }
  public static ASMString GaExecHost_schedPriRange(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedPriRange");
  }
  public static ASMString GaCommHost(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaCommHost");
  }
  public static ASMString GaCommHost_capacity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("capacity");
  }
  public static ASMString GaCommHost_packetT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("packetT");
  }
  public static ASMString GaCommHost_blockT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blockT");
  }
  public static ASMString GaCommHost_transmMode(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("transmMode");
  }
  public static ASMString GaCommHost_utilization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilization");
  }
  public static ASMString GaCommHost_throughput(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("throughput");
  }
  public static ASMString GaCommChannel(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GQAM::GaCommChannel");
  }
  public static ASMString GaCommChannel_packetSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("packetSize");
  }
  public static ASMString Resource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::Resource");
  }
  public static ASMString Resource_resMult(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resMult");
  }
  public static ASMString Resource_isProtected(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isProtected");
  }
  public static ASMString Resource_isActive(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isActive");
  }
  public static ASMString StorageResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::StorageResource");
  }
  public static ASMString StorageResource_elementSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("elementSize");
  }
  public static ASMString CommunicationEndPoint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::CommunicationEndPoint");
  }
  public static ASMString CommunicationEndPoint_packetSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("packetSize");
  }
  public static ASMString SynchronizationResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::SynchronizationResource");
  }
  public static ASMString ConcurrencyResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::ConcurrencyResource");
  }
  public static ASMString MutualExclusionResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::MutualExclusionResource");
  }
  public static ASMString MutualExclusionResource_protectKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("protectKind");
  }
  public static ASMString MutualExclusionResource_ceiling(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ceiling");
  }
  public static ASMString MutualExclusionResource_otherProtectProtocol(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("otherProtectProtocol");
  }
  public static ASMString MutualExclusionResource_scheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("scheduler");
  }
  public static ASMString SchedulableResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::SchedulableResource");
  }
  public static ASMString SchedulableResource_schedParams(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedParams");
  }
  public static ASMString SchedulableResource_isActive(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isActive");
  }
  public static ASMString SchedulableResource_dependentScheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dependentScheduler");
  }
  public static ASMString SchedulableResource_host(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("host");
  }
  public static ASMString Scheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::Scheduler");
  }
  public static ASMString Scheduler_isPreemptible(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isPreemptible");
  }
  public static ASMString Scheduler_schedPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedPolicy");
  }
  public static ASMString Scheduler_otherSchedPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("otherSchedPolicy");
  }
  public static ASMString Scheduler_schedule(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedule");
  }
  public static ASMString Scheduler_host(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("host");
  }
  public static ASMString Scheduler_processingUnits(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("processingUnits");
  }
  public static ASMString Scheduler_schedulableResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedulableResources");
  }
  public static ASMString Scheduler_protectedSharedResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("protectedSharedResources");
  }
  public static ASMString SecondaryScheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::SecondaryScheduler");
  }
  public static ASMString SecondaryScheduler_virtualProcessingUnits(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("virtualProcessingUnits");
  }
  public static ASMString ProcessingResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::ProcessingResource");
  }
  public static ASMString ProcessingResource_speedFactor(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("speedFactor");
  }
  public static ASMString ProcessingResource_mainScheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mainScheduler");
  }
  public static ASMString ComputingResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::ComputingResource");
  }
  public static ASMString DeviceResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::DeviceResource");
  }
  public static ASMString CommunicationMedia(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::CommunicationMedia");
  }
  public static ASMString CommunicationMedia_elementSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("elementSize");
  }
  public static ASMString TimingResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::TimingResource");
  }
  public static ASMString ClockResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::ClockResource");
  }
  public static ASMString TimerResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::TimerResource");
  }
  public static ASMString TimerResource_duration(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("duration");
  }
  public static ASMString TimerResource_isPeriodic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isPeriodic");
  }
  public static ASMString GRService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::GRService");
  }
  public static ASMString GRService_owner(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("owner");
  }
  public static ASMString Release(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::Release");
  }
  public static ASMString Acquire(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::Acquire");
  }
  public static ASMString Acquire_isBlocking(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isBlocking");
  }
  public static ASMString ResourceUsage(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GRM::ResourceUsage");
  }
  public static ASMString ResourceUsage_usedResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("usedResources");
  }
  public static ASMString ResourceUsage_subUsages(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("subUsages");
  }
  public static ASMString ResourceUsage_execTime(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("execTime");
  }
  public static ASMString ResourceUsage_msgSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("msgSize");
  }
  public static ASMString ResourceUsage_allocatedMemory(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("allocatedMemory");
  }
  public static ASMString ResourceUsage_usedMemory(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("usedMemory");
  }
  public static ASMString ResourceUsage_powerPeak(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("powerPeak");
  }
  public static ASMString ResourceUsage_energy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("energy");
  }
  public static ASMString HwResourceService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwResourceService");
  }
  public static ASMString HwResourceService_consumption(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("consumption");
  }
  public static ASMString HwResourceService_dissipation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dissipation");
  }
  public static ASMString HwResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwResource");
  }
  public static ASMString HwResource_ownedHW(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ownedHW");
  }
  public static ASMString HwResource_description(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("description");
  }
  public static ASMString HwResource_r_HW_Services(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("r_HW_Services");
  }
  public static ASMString HwResource_p_HW_Services(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("p_HW_Services");
  }
  public static ASMString HwResource_endPoints(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("endPoints");
  }
  public static ASMString HwResource_frequency(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("frequency");
  }
  public static ASMString HwComputingResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwComputingResource");
  }
  public static ASMString HwComputingResource_op_Frequencies(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("op_Frequencies");
  }
  public static ASMString HwCommunicationResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwCommunicationResource");
  }
  public static ASMString HwMemory(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwMemory");
  }
  public static ASMString HwMemory_timings(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timings");
  }
  public static ASMString HwMemory_memorySize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memorySize");
  }
  public static ASMString HwMemory_addressSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("addressSize");
  }
  public static ASMString HwTimingResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwTimingResource");
  }
  public static ASMString HwStorageManager(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwStorageManager");
  }
  public static ASMString HwStorageManager_managedMemories(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("managedMemories");
  }
  public static ASMString HwDevice(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwDevice");
  }
  public static ASMString ISA_Type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::ISA_Type");
  }
  public static ASMString ISA_Type_RISC(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RISC");
  }
  public static ASMString ISA_Type_CISC(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("CISC");
  }
  public static ASMString ISA_Type_VLIW(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VLIW");
  }
  public static ASMString ISA_Type_SIMD(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SIMD");
  }
  public static ASMString ISA_Type_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ISA_Type_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString PLD_Technology(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::PLD_Technology");
  }
  public static ASMString PLD_Technology_SRAM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRAM");
  }
  public static ASMString PLD_Technology_Antifuse(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Antifuse");
  }
  public static ASMString PLD_Technology_Flash(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Flash");
  }
  public static ASMString PLD_Technology_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString PLD_Technology_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString PLD_Class(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::PLD_Class");
  }
  public static ASMString PLD_Class_SymetricalArray(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SymetricalArray");
  }
  public static ASMString PLD_Class_RowBased(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RowBased");
  }
  public static ASMString PLD_Class_SeaOfGates(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SeaOfGates");
  }
  public static ASMString PLD_Class_HierarchicalPLD(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HierarchicalPLD");
  }
  public static ASMString PLD_Class_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString PLD_Class_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString HwBranchPredictor(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwBranchPredictor");
  }
  public static ASMString HwISA(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwISA");
  }
  public static ASMString HwISA_family(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("family");
  }
  public static ASMString HwISA_inst_Width(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("inst_Width");
  }
  public static ASMString HwISA_type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("type");
  }
  public static ASMString HwProcessor(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwProcessor");
  }
  public static ASMString HwProcessor_architecture(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("architecture");
  }
  public static ASMString HwProcessor_mips(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mips");
  }
  public static ASMString HwProcessor_ipc(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ipc");
  }
  public static ASMString HwProcessor_nbCores(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbCores");
  }
  public static ASMString HwProcessor_nbPipelines(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbPipelines");
  }
  public static ASMString HwProcessor_nbStages(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbStages");
  }
  public static ASMString HwProcessor_nbALUs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbALUs");
  }
  public static ASMString HwProcessor_nbFPUs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbFPUs");
  }
  public static ASMString HwProcessor_predictors(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("predictors");
  }
  public static ASMString HwProcessor_ownedISAs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ownedISAs");
  }
  public static ASMString HwProcessor_caches(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("caches");
  }
  public static ASMString HwProcessor_ownedMMUs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ownedMMUs");
  }
  public static ASMString HwASIC(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwASIC");
  }
  public static ASMString HwPLD(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwPLD");
  }
  public static ASMString HwPLD_technology(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("technology");
  }
  public static ASMString HwPLD_organization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("organization");
  }
  public static ASMString HwPLD_nbLUTs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbLUTs");
  }
  public static ASMString HwPLD_nbLUT_Inputs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbLUT_Inputs");
  }
  public static ASMString HwPLD_nbFlipFlops(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbFlipFlops");
  }
  public static ASMString HwPLD_blocksRAM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blocksRAM");
  }
  public static ASMString HwPLD_blocksComputing(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blocksComputing");
  }
  public static ASMString ROM_Type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::ROM_Type");
  }
  public static ASMString ROM_Type_MaskedROM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("MaskedROM");
  }
  public static ASMString ROM_Type_EPROM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("EPROM");
  }
  public static ASMString ROM_Type_OPT_EPROM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("OPT_EPROM");
  }
  public static ASMString ROM_Type_EEPROM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("EEPROM");
  }
  public static ASMString ROM_Type_Flash(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Flash");
  }
  public static ASMString ROM_Type_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ROM_Type_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString CacheType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::CacheType");
  }
  public static ASMString CacheType_Data(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Data");
  }
  public static ASMString CacheType_Instruction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Instruction");
  }
  public static ASMString CacheType_Unified(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Unified");
  }
  public static ASMString CacheType_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString CacheType_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString WritePolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::WritePolicy");
  }
  public static ASMString WritePolicy_WriteBack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("WriteBack");
  }
  public static ASMString WritePolicy_WriteThrough(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("WriteThrough");
  }
  public static ASMString WritePolicy_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString WritePolicy_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString Repl_Policy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::Repl_Policy");
  }
  public static ASMString Repl_Policy_LRU(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("LRU");
  }
  public static ASMString Repl_Policy_NFU(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFU");
  }
  public static ASMString Repl_Policy_FIFO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("FIFO");
  }
  public static ASMString Repl_Policy_Random(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Random");
  }
  public static ASMString Repl_Policy_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString Repl_Policy_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString HwCache(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwCache");
  }
  public static ASMString HwCache_level(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("level");
  }
  public static ASMString HwCache_type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("type");
  }
  public static ASMString HwCache_structure(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("structure");
  }
  public static ASMString HwRAM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwRAM");
  }
  public static ASMString HwRAM_organization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("organization");
  }
  public static ASMString HwRAM_isSynchronous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSynchronous");
  }
  public static ASMString HwRAM_isStatic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isStatic");
  }
  public static ASMString HwRAM_isNonVolatile(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isNonVolatile");
  }
  public static ASMString HwROM(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwROM");
  }
  public static ASMString HwROM_type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("type");
  }
  public static ASMString HwROM_organization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("organization");
  }
  public static ASMString HwDrive(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwDrive");
  }
  public static ASMString HwDrive_sectorSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("sectorSize");
  }
  public static ASMString HwDrive_buffer(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("buffer");
  }
  public static ASMString HwDMA(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwDMA");
  }
  public static ASMString HwDMA_nbChannels(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbChannels");
  }
  public static ASMString HwDMA_transferWidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("transferWidth");
  }
  public static ASMString HwDMA_drivenBy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("drivenBy");
  }
  public static ASMString HwArbiter(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwArbiter");
  }
  public static ASMString HwArbiter_controlledMedias(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("controlledMedias");
  }
  public static ASMString HwMMU(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwMMU");
  }
  public static ASMString HwMMU_virtualAddrSpace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("virtualAddrSpace");
  }
  public static ASMString HwMMU_physicalAddrSpace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("physicalAddrSpace");
  }
  public static ASMString HwMMU_memoryProtection(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memoryProtection");
  }
  public static ASMString HwMMU_nbEntriesTLB(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbEntriesTLB");
  }
  public static ASMString HwMMU_ownedTLBs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ownedTLBs");
  }
  public static ASMString HwMedia(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwMedia");
  }
  public static ASMString HwMedia_bandwidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("bandwidth");
  }
  public static ASMString HwMedia_arbiters(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("arbiters");
  }
  public static ASMString HwBus(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwBus");
  }
  public static ASMString HwBus_addressWidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("addressWidth");
  }
  public static ASMString HwBus_wordWidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("wordWidth");
  }
  public static ASMString HwBus_isSynchronous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSynchronous");
  }
  public static ASMString HwBus_isSerial(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSerial");
  }
  public static ASMString HwBridge(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwBridge");
  }
  public static ASMString HwBridge_sides(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("sides");
  }
  public static ASMString HwEndPoint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwEndPoint");
  }
  public static ASMString HwEndPoint_connectedTo(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("connectedTo");
  }
  public static ASMString HwClock(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwClock");
  }
  public static ASMString HwClock_frequency(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("frequency");
  }
  public static ASMString HwTimer(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwTimer");
  }
  public static ASMString HwTimer_nbCounters(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbCounters");
  }
  public static ASMString HwTimer_counterWidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("counterWidth");
  }
  public static ASMString HwTimer_inputClock(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("inputClock");
  }
  public static ASMString HwIO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwIO");
  }
  public static ASMString HwSupport(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwSupport");
  }
  public static ASMString ConditionType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::ConditionType");
  }
  public static ASMString ConditionType_Temperature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Temperature");
  }
  public static ASMString ConditionType_Humidity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Humidity");
  }
  public static ASMString ConditionType_Altitude(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Altitude");
  }
  public static ASMString ConditionType_Vibration(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Vibration");
  }
  public static ASMString ConditionType_Shock(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Shock");
  }
  public static ASMString ConditionType_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ConditionType_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString ComponentKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::ComponentKind");
  }
  public static ASMString ComponentKind_Card(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Card");
  }
  public static ASMString ComponentKind_Channel(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Channel");
  }
  public static ASMString ComponentKind_Chip(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Chip");
  }
  public static ASMString ComponentKind_Port(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Port");
  }
  public static ASMString ComponentKind_Unit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Unit");
  }
  public static ASMString ComponentKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ComponentKind_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString ComponentState(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::ComponentState");
  }
  public static ASMString ComponentState_Operating(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Operating");
  }
  public static ASMString ComponentState_Storage(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Storage");
  }
  public static ASMString ComponentState_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ComponentState_Undefined(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undefined");
  }
  public static ASMString HwComponent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwComponent");
  }
  public static ASMString HwComponent_subComponents(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("subComponents");
  }
  public static ASMString HwComponent_kind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("kind");
  }
  public static ASMString HwComponent_dimensions(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dimensions");
  }
  public static ASMString HwComponent_area(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("area");
  }
  public static ASMString HwComponent_grid(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("grid");
  }
  public static ASMString HwComponent_nbPins(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nbPins");
  }
  public static ASMString HwComponent_r_Conditions(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("r_Conditions");
  }
  public static ASMString HwComponent_position(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("position");
  }
  public static ASMString HwComponent_weight(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("weight");
  }
  public static ASMString HwComponent_price(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("price");
  }
  public static ASMString HwComponent_staticConsumption(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("staticConsumption");
  }
  public static ASMString HwComponent_staticDissipation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("staticDissipation");
  }
  public static ASMString HwPowerSupply(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwPowerSupply");
  }
  public static ASMString HwPowerSupply_suppliedPower(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("suppliedPower");
  }
  public static ASMString HwPowerSupply_capacity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("capacity");
  }
  public static ASMString HwCoolingSupply(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HRM::HwCoolingSupply");
  }
  public static ASMString HwCoolingSupply_coolingPower(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("coolingPower");
  }
  public static ASMString TimeNatureKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::TimeNatureKind");
  }
  public static ASMString TimeNatureKind_discrete(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("discrete");
  }
  public static ASMString TimeNatureKind_dense(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dense");
  }
  public static ASMString TimeInterpretationKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::TimeInterpretationKind");
  }
  public static ASMString TimeInterpretationKind_duration(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("duration");
  }
  public static ASMString TimeInterpretationKind_instant(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("instant");
  }
  public static ASMString TimeInterpretationKind_any(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("any");
  }
  public static ASMString TimeStandardKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::TimeStandardKind");
  }
  public static ASMString TimeStandardKind_TAI(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TAI");
  }
  public static ASMString TimeStandardKind_UT0(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("UT0");
  }
  public static ASMString TimeStandardKind_UT1(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("UT1");
  }
  public static ASMString TimeStandardKind_UTC(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("UTC");
  }
  public static ASMString TimeStandardKind_Local(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Local");
  }
  public static ASMString TimeStandardKind_TT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TT");
  }
  public static ASMString TimeStandardKind_TDB(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TDB");
  }
  public static ASMString TimeStandardKind_TCG(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TCG");
  }
  public static ASMString TimeStandardKind_TCB(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TCB");
  }
  public static ASMString TimeStandardKind_Sideral(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Sideral");
  }
  public static ASMString TimeStandardKind_GPS(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("GPS");
  }
  public static ASMString EventKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::EventKind");
  }
  public static ASMString EventKind_start(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("start");
  }
  public static ASMString EventKind_finish(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("finish");
  }
  public static ASMString EventKind_send(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("send");
  }
  public static ASMString EventKind_receive(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("receive");
  }
  public static ASMString EventKind_consume(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("consume");
  }
  public static ASMString ProtectProtocolKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::ProtectProtocolKind");
  }
  public static ASMString ProtectProtocolKind_FIFO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("FIFO");
  }
  public static ASMString ProtectProtocolKind_NoPreemption(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NoPreemption");
  }
  public static ASMString ProtectProtocolKind_PriorityCeiling(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PriorityCeiling");
  }
  public static ASMString ProtectProtocolKind_PriorityInheritance(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PriorityInheritance");
  }
  public static ASMString ProtectProtocolKind_StackBased(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("StackBased");
  }
  public static ASMString ProtectProtocolKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString ProtectProtocolKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString SchedPolicyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::SchedPolicyKind");
  }
  public static ASMString SchedPolicyKind_EarliestDeadlineFirst(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("EarliestDeadlineFirst");
  }
  public static ASMString SchedPolicyKind_FIFO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("FIFO");
  }
  public static ASMString SchedPolicyKind_FixedPriority(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("FixedPriority");
  }
  public static ASMString SchedPolicyKind_LeastLaxityFirst(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("LeastLaxityFirst");
  }
  public static ASMString SchedPolicyKind_RoundRobin(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RoundRobin");
  }
  public static ASMString SchedPolicyKind_TimeTableDriven(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("TimeTableDriven");
  }
  public static ASMString SchedPolicyKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString SchedPolicyKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString TransmModeKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("InternalMarteLibrary::TransmModeKind");
  }
  public static ASMString TransmModeKind_simplex(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("simplex");
  }
  public static ASMString TransmModeKind_halfduplex(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("half-duplex");
  }
  public static ASMString TransmModeKind_fullduplex(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("full-duplex");
  }
  public static ASMString Unit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFPs::Unit");
  }
  public static ASMString Unit_baseUnit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("baseUnit");
  }
  public static ASMString Unit_convFactor(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("convFactor");
  }
  public static ASMString Unit_offsetFactor(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("offsetFactor");
  }
  public static ASMString Nfp(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFPs::Nfp");
  }
  public static ASMString ConstraintKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFPs::ConstraintKind");
  }
  public static ASMString ConstraintKind_required(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("required");
  }
  public static ASMString ConstraintKind_offered(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("offered");
  }
  public static ASMString ConstraintKind_contract(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("contract");
  }
  public static ASMString NfpConstraint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFPs::NfpConstraint");
  }
  public static ASMString NfpConstraint_kind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("kind");
  }
  public static ASMString NfpType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NFPs::NfpType");
  }
  public static ASMString NfpType_valueAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("valueAttrib");
  }
  public static ASMString NfpType_unitAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unitAttrib");
  }
  public static ASMString NfpType_exprAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("exprAttrib");
  }
  public static ASMString PaResPassStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaResPassStep");
  }
  public static ASMString PaResPassStep_resUnits(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resUnits");
  }
  public static ASMString PaResPassStep_resource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resource");
  }
  public static ASMString PaStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaStep");
  }
  public static ASMString PaStep_noSync(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("noSync");
  }
  public static ASMString PaStep_extOpDemands(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("extOpDemands");
  }
  public static ASMString PaStep_extOpCount(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("extOpCount");
  }
  public static ASMString PaStep_behavDemands(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("behavDemands");
  }
  public static ASMString PaStep_behavCount(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("behavCount");
  }
  public static ASMString PaRequestedService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaRequestedService");
  }
  public static ASMString PaCommStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaCommStep");
  }
  public static ASMString PaCommStep_msgSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("msgSize");
  }
  public static ASMString PaCommStep_concurResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concurResource");
  }
  public static ASMString PaLogicalResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaLogicalResource");
  }
  public static ASMString PaLogicalResource_utilization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilization");
  }
  public static ASMString PaLogicalResource_throughput(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("throughput");
  }
  public static ASMString PaLogicalResource_poolSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("poolSize");
  }
  public static ASMString PaRunTInstance(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PAM::PaRunTInstance");
  }
  public static ASMString PaRunTInstance_poolSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("poolSize");
  }
  public static ASMString PaRunTInstance_unbddPool(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unbddPool");
  }
  public static ASMString PaRunTInstance_instance(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("instance");
  }
  public static ASMString PaRunTInstance_host(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("host");
  }
  public static ASMString PaRunTInstance_utilization(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utilization");
  }
  public static ASMString PaRunTInstance_throughput(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("throughput");
  }
  public static ASMString Shaped(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::Shaped");
  }
  public static ASMString Shaped_shape(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("shape");
  }
  public static ASMString LinkTopology(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::LinkTopology");
  }
  public static ASMString DefaultLink(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::DefaultLink");
  }
  public static ASMString Reshape(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::Reshape");
  }
  public static ASMString Reshape_patternShape(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("patternShape");
  }
  public static ASMString Reshape_repetitionSpace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("repetitionSpace");
  }
  public static ASMString Tiler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::Tiler");
  }
  public static ASMString Tiler_origin(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("origin");
  }
  public static ASMString Tiler_paving(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("paving");
  }
  public static ASMString Tiler_fitting(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("fitting");
  }
  public static ASMString Tiler_tiler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("tiler");
  }
  public static ASMString InterRepetition(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::InterRepetition");
  }
  public static ASMString InterRepetition_repetitionSpaceDependence(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("repetitionSpaceDependence");
  }
  public static ASMString InterRepetition_isModulo(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isModulo");
  }
  public static ASMString Distribute(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RSM::Distribute");
  }
  public static ASMString Distribute_patternShape(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("patternShape");
  }
  public static ASMString Distribute_repetitionSpace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("repetitionSpace");
  }
  public static ASMString Distribute_fromTiler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("fromTiler");
  }
  public static ASMString Distribute_toTiler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("toTiler");
  }
  public static ASMString Distribute_kind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("kind");
  }
  public static ASMString Distribute_nature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nature");
  }
  public static ASMString PoolMgtPolicyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::PoolMgtPolicyKind");
  }
  public static ASMString PoolMgtPolicyKind_infiniteWait(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("infiniteWait");
  }
  public static ASMString PoolMgtPolicyKind_timedWait(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timedWait");
  }
  public static ASMString PoolMgtPolicyKind_dynamic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dynamic");
  }
  public static ASMString PoolMgtPolicyKind_exception(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("exception");
  }
  public static ASMString PoolMgtPolicyKind_other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("other");
  }
  public static ASMString RtUnit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::RtUnit");
  }
  public static ASMString RtUnit_isDynamic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isDynamic");
  }
  public static ASMString RtUnit_isMain(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isMain");
  }
  public static ASMString RtUnit_poolSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("poolSize");
  }
  public static ASMString RtUnit_poolPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("poolPolicy");
  }
  public static ASMString RtUnit_poolWaitingTime(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("poolWaitingTime");
  }
  public static ASMString RtUnit_operationalMode(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("operationalMode");
  }
  public static ASMString RtUnit_main(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("main");
  }
  public static ASMString RtUnit_memorySize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memorySize");
  }
  public static ASMString CallConcurrencyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::CallConcurrencyKind");
  }
  public static ASMString CallConcurrencyKind_sequential(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("sequential");
  }
  public static ASMString CallConcurrencyKind_guarded(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("guarded");
  }
  public static ASMString CallConcurrencyKind_concurrent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concurrent");
  }
  public static ASMString PpUnit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::PpUnit");
  }
  public static ASMString PpUnit_concPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concPolicy");
  }
  public static ASMString PpUnit_memorySize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memorySize");
  }
  public static ASMString RtBehavior(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::RtBehavior");
  }
  public static ASMString RtBehavior_queueSchedPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("queueSchedPolicy");
  }
  public static ASMString RtBehavior_queueSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("queueSize");
  }
  public static ASMString RtBehavior_msgMaxSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("msgMaxSize");
  }
  public static ASMString rtf(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::rtf");
  }
  public static ASMString rtf_utility(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("utility");
  }
  public static ASMString rtf_occkind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("occkind");
  }
  public static ASMString rtf_tRef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("tRef");
  }
  public static ASMString rtf_relDl(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("relDl");
  }
  public static ASMString rtf_absDl(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("absDl");
  }
  public static ASMString rtf_boundDl(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("boundDl");
  }
  public static ASMString rtf_rdTime(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("rdTime");
  }
  public static ASMString rtf_miss(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("miss");
  }
  public static ASMString rtf_priority(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("priority");
  }
  public static ASMString RtAction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::RtAction");
  }
  public static ASMString RtAction_isAtomic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isAtomic");
  }
  public static ASMString RtAction_msgSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("msgSize");
  }
  public static ASMString RtAction_synchKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("synchKind");
  }
  public static ASMString SynchronisationKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::SynchronisationKind");
  }
  public static ASMString SynchronisationKind_synchronous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("synchronous");
  }
  public static ASMString SynchronisationKind_asynchronous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("asynchronous");
  }
  public static ASMString SynchronisationKind_delayedSynchronous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("delayedSynchronous");
  }
  public static ASMString SynchronisationKind_rendezVous(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("rendezVous");
  }
  public static ASMString SynchronisationKind_other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("other");
  }
  public static ASMString ExecutionKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::ExecutionKind");
  }
  public static ASMString ExecutionKind_deferred(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deferred");
  }
  public static ASMString ExecutionKind_remoteImmediate(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("remoteImmediate");
  }
  public static ASMString ExecutionKind_localImmediate(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("localImmediate");
  }
  public static ASMString ConcurrencyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::ConcurrencyKind");
  }
  public static ASMString ConcurrencyKind_reader(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("reader");
  }
  public static ASMString ConcurrencyKind_writer(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("writer");
  }
  public static ASMString ConcurrencyKind_parallel(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("parallel");
  }
  public static ASMString RtService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::RtService");
  }
  public static ASMString RtService_concPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concPolicy");
  }
  public static ASMString RtService_exeKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("exeKind");
  }
  public static ASMString RtService_synchKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("synchKind");
  }
  public static ASMString RtService_isAtomic(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isAtomic");
  }
  public static ASMString RteConnector(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("RTEMoCC::RteConnector");
  }
  public static ASMString RteConnector_bandwidth(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("bandwidth");
  }
  public static ASMString RteConnector_packetT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("packetT");
  }
  public static ASMString RteConnector_blockT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blockT");
  }
  public static ASMString RteConnector_transmMode(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("transmMode");
  }
  public static ASMString OptimallityCriterionKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::OptimallityCriterionKind");
  }
  public static ASMString OptimallityCriterionKind_meetHardDeadlines(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("meetHardDeadlines");
  }
  public static ASMString OptimallityCriterionKind_minimizeMissedDeadline(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("minimizeMissedDeadline");
  }
  public static ASMString OptimallityCriterionKind_minimizeMeanTardiness(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("minimizeMeanTardiness");
  }
  public static ASMString OptimallityCriterionKind_undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("undef");
  }
  public static ASMString OptimallityCriterionKind_other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("other");
  }
  public static ASMString SaAnalysisContext(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaAnalysisContext");
  }
  public static ASMString SaAnalysisContext_isSched(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSched");
  }
  public static ASMString SaAnalysisContext_optCriterion(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("optCriterion");
  }
  public static ASMString SaEnd2EndFlow(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaEnd2EndFlow");
  }
  public static ASMString SaEnd2EndFlow_isSched(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSched");
  }
  public static ASMString SaEnd2EndFlow_schSlack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schSlack");
  }
  public static ASMString SaEnd2EndFlow_end2EndT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("end2EndT");
  }
  public static ASMString SaEnd2EndFlow_end2EndD(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("end2EndD");
  }
  public static ASMString SaEnd2EndFlow_timing(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timing");
  }
  public static ASMString SaCommStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaCommStep");
  }
  public static ASMString SaCommStep_deadline(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deadline");
  }
  public static ASMString SaCommStep_spareCap(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("spareCap");
  }
  public static ASMString SaCommStep_schSlack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schSlack");
  }
  public static ASMString SaStep(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaStep");
  }
  public static ASMString SaStep_deadline(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deadline");
  }
  public static ASMString SaStep_spareCap(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("spareCap");
  }
  public static ASMString SaStep_schSlack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schSlack");
  }
  public static ASMString SaStep_preempT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("preempT");
  }
  public static ASMString SaStep_readyT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("readyT");
  }
  public static ASMString SaStep_delayT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("delayT");
  }
  public static ASMString SaSchedObs(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaSchedObs");
  }
  public static ASMString SaSchedObs_suspensions(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("suspensions");
  }
  public static ASMString SaSchedObs_blockT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("blockT");
  }
  public static ASMString SaSchedObs_overlaps(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("overlaps");
  }
  public static ASMString SaSharedResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaSharedResource");
  }
  public static ASMString SaSharedResource_capacity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("capacity");
  }
  public static ASMString SaSharedResource_isPreemp(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isPreemp");
  }
  public static ASMString SaSharedResource_isConsum(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isConsum");
  }
  public static ASMString SaSharedResource_acquisiT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("acquisiT");
  }
  public static ASMString SaSharedResource_releaseT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("releaseT");
  }
  public static ASMString SaCommHost(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaCommHost");
  }
  public static ASMString SaCommHost_isSched(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSched");
  }
  public static ASMString SaCommHost_schSlack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schSlack");
  }
  public static ASMString SaExecHost(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SAM::SaExecHost");
  }
  public static ASMString SaExecHost_isSched(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isSched");
  }
  public static ASMString SaExecHost_schSlack(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schSlack");
  }
  public static ASMString SaExecHost_schedUtiliz(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedUtiliz");
  }
  public static ASMString SaExecHost_ISRswitchT(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ISRswitchT");
  }
  public static ASMString SaExecHost_schedPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("schedPolicy");
  }
  public static ASMString SaExecHost_isPreemptible(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isPreemptible");
  }
  public static ASMString SaExecHost_ISRprioRange(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ISRprioRange");
  }
  public static ASMString SwResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwResource");
  }
  public static ASMString SwResource_identifierElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("identifierElements");
  }
  public static ASMString SwResource_stateElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("stateElements");
  }
  public static ASMString SwResource_memorySizeFootprint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memorySizeFootprint");
  }
  public static ASMString SwResource_createServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("createServices");
  }
  public static ASMString SwResource_deleteServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deleteServices");
  }
  public static ASMString SwResource_initializeServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("initializeServices");
  }
  public static ASMString SwAccessService(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwAccessService");
  }
  public static ASMString SwAccessService_isModifier(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isModifier");
  }
  public static ASMString SwAccessService_accessedElement(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("accessedElement");
  }
  public static ASMString EntryPoint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::EntryPoint");
  }
  public static ASMString EntryPoint_isReentrant(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isReentrant");
  }
  public static ASMString EntryPoint_routine(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("routine");
  }
  public static ASMString InterruptKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::InterruptKind");
  }
  public static ASMString InterruptKind_HardwareInterrupt(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("HardwareInterrupt");
  }
  public static ASMString InterruptKind_ProcessorDetectedException(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ProcessorDetectedException");
  }
  public static ASMString InterruptKind_ProgrammedException(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ProgrammedException");
  }
  public static ASMString InterruptKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString InterruptKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString MemoryPartition(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::MemoryPartition");
  }
  public static ASMString MemoryPartition_concurrentResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concurrentResources");
  }
  public static ASMString MemoryPartition_memorySpaces(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memorySpaces");
  }
  public static ASMString MemoryPartition_forkServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("forkServices");
  }
  public static ASMString MemoryPartition_exitServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("exitServices");
  }
  public static ASMString SwTimerResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwTimerResource");
  }
  public static ASMString SwTimerResource_DurationElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("DurationElements");
  }
  public static ASMString SwConcurrentResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwConcurrentResource");
  }
  public static ASMString SwConcurrentResource_type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("type");
  }
  public static ASMString SwConcurrentResource_activationCapacity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("activationCapacity");
  }
  public static ASMString SwConcurrentResource_entryPoints(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("entryPoints");
  }
  public static ASMString SwConcurrentResource_addressSpace(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("addressSpace");
  }
  public static ASMString SwConcurrentResource_periodElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("periodElements");
  }
  public static ASMString SwConcurrentResource_priorityElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("priorityElements");
  }
  public static ASMString SwConcurrentResource_stackSizeElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("stackSizeElements");
  }
  public static ASMString SwConcurrentResource_shareDataResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("shareDataResources");
  }
  public static ASMString SwConcurrentResource_messageResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("messageResources");
  }
  public static ASMString SwConcurrentResource_mutualExclusionResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mutualExclusionResources");
  }
  public static ASMString SwConcurrentResource_notificationResources(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("notificationResources");
  }
  public static ASMString SwConcurrentResource_activateServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("activateServices");
  }
  public static ASMString SwConcurrentResource_enableConcurrencyServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("enableConcurrencyServices");
  }
  public static ASMString SwConcurrentResource_resumeServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resumeServices");
  }
  public static ASMString SwConcurrentResource_suspendServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("suspendServices");
  }
  public static ASMString SwConcurrentResource_terminateServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("terminateServices");
  }
  public static ASMString SwConcurrentResource_disableConcurrencyServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("disableConcurrencyServices");
  }
  public static ASMString InterruptResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::InterruptResource");
  }
  public static ASMString InterruptResource_kind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("kind");
  }
  public static ASMString InterruptResource_isMaskable(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isMaskable");
  }
  public static ASMString InterruptResource_vectorElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("vectorElements");
  }
  public static ASMString InterruptResource_maskElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("maskElements");
  }
  public static ASMString InterruptResource_routineConnect(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("routineConnect");
  }
  public static ASMString InterruptResource_routineDisconnect(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("routineDisconnect");
  }
  public static ASMString Alarm(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::Alarm");
  }
  public static ASMString Alarm_isWatchdog(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isWatchdog");
  }
  public static ASMString Alarm_timers(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timers");
  }
  public static ASMString SwSchedulableResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwSchedulableResource");
  }
  public static ASMString SwSchedulableResource_isStaticSchedulingFeature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isStaticSchedulingFeature");
  }
  public static ASMString SwSchedulableResource_isPreemptable(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isPreemptable");
  }
  public static ASMString SwSchedulableResource_deadlineElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deadlineElements");
  }
  public static ASMString SwSchedulableResource_deadlineTypeElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("deadlineTypeElements");
  }
  public static ASMString SwSchedulableResource_timeSliceElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("timeSliceElements");
  }
  public static ASMString SwSchedulableResource_delayServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("delayServices");
  }
  public static ASMString SwSchedulableResource_joinServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("joinServices");
  }
  public static ASMString SwSchedulableResource_yieldServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("yieldServices");
  }
  public static ASMString SwSchedulableResource_scheduler(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("scheduler");
  }
  public static ASMString SwInteractionResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwInteractionResource");
  }
  public static ASMString SwInteractionResource_isIntraMemoryPartitionInteraction(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isIntraMemoryPartitionInteraction");
  }
  public static ASMString SwInteractionResource_waitingQueueCapacity(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("waitingQueueCapacity");
  }
  public static ASMString SwInteractionResource_waitingQueuePolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("waitingQueuePolicy");
  }
  public static ASMString SwInteractionResource_waitingPolicyElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("waitingPolicyElements");
  }
  public static ASMString QueuePolicyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::QueuePolicyKind");
  }
  public static ASMString QueuePolicyKind_FIFO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("FIFO");
  }
  public static ASMString QueuePolicyKind_LIFO(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("LIFO");
  }
  public static ASMString QueuePolicyKind_Priority(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Priority");
  }
  public static ASMString QueuePolicyKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString QueuePolicyKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString MessageResourceKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::MessageResourceKind");
  }
  public static ASMString MessageResourceKind_MessageQueue(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("MessageQueue");
  }
  public static ASMString MessageResourceKind_Pipe(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Pipe");
  }
  public static ASMString MessageResourceKind_Blackboard(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Blackboard");
  }
  public static ASMString MessageResourceKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString MessageResourceKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString NotificationKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::NotificationKind");
  }
  public static ASMString NotificationKind_Memorized(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Memorized");
  }
  public static ASMString NotificationKind_Bounded(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Bounded");
  }
  public static ASMString NotificationKind_Memoryless(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Memoryless");
  }
  public static ASMString NotificationKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString NotificationKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString NotificationResourceKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::NotificationResourceKind");
  }
  public static ASMString NotificationResourceKind_Event(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Event");
  }
  public static ASMString NotificationResourceKind_Barrier(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Barrier");
  }
  public static ASMString NotificationResourceKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString NotificationResourceKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString MutualExclusionResourceKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::MutualExclusionResourceKind");
  }
  public static ASMString MutualExclusionResourceKind_BooleanSemaphore(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("BooleanSemaphore");
  }
  public static ASMString MutualExclusionResourceKind_CountSemaphore(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("CountSemaphore");
  }
  public static ASMString MutualExclusionResourceKind_Mutex(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Mutex");
  }
  public static ASMString MutualExclusionResourceKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString MutualExclusionResourceKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString SwCommunicationResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwCommunicationResource");
  }
  public static ASMString SharedDataComResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SharedDataComResource");
  }
  public static ASMString SharedDataComResource_readServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("readServices");
  }
  public static ASMString SharedDataComResource_writeServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("writeServices");
  }
  public static ASMString MessageComResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::MessageComResource");
  }
  public static ASMString MessageComResource_isFixedMessageSize(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isFixedMessageSize");
  }
  public static ASMString MessageComResource_mechanism(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mechanism");
  }
  public static ASMString MessageComResource_messageSizeElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("messageSizeElements");
  }
  public static ASMString MessageComResource_messageQueueCapacityElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("messageQueueCapacityElements");
  }
  public static ASMString MessageComResource_messageQueuePolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("messageQueuePolicy");
  }
  public static ASMString MessageComResource_sendServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("sendServices");
  }
  public static ASMString MessageComResource_receiveServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("receiveServices");
  }
  public static ASMString SwSynchronizationResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwSynchronizationResource");
  }
  public static ASMString NotificationResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::NotificationResource");
  }
  public static ASMString NotificationResource_occurenceKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("occurenceKind");
  }
  public static ASMString NotificationResource_mechanism(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mechanism");
  }
  public static ASMString NotificationResource_occurenceCountElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("occurenceCountElements");
  }
  public static ASMString NotificationResource_maskElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("maskElements");
  }
  public static ASMString NotificationResource_flushServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("flushServices");
  }
  public static ASMString NotificationResource_signalServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("signalServices");
  }
  public static ASMString NotificationResource_waitServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("waitServices");
  }
  public static ASMString NotificationResource_clearServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("clearServices");
  }
  public static ASMString SwMutualExclusionResource(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::SwMutualExclusionResource");
  }
  public static ASMString SwMutualExclusionResource_mechanism(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mechanism");
  }
  public static ASMString SwMutualExclusionResource_concurrentAccessProtocol(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("concurrentAccessProtocol");
  }
  public static ASMString SwMutualExclusionResource_accessTokenElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("accessTokenElements");
  }
  public static ASMString SwMutualExclusionResource_releaseServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("releaseServices");
  }
  public static ASMString SwMutualExclusionResource_acquireServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("acquireServices");
  }
  public static ASMString ConcurrentAccessProtocolKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::ConcurrentAccessProtocolKind");
  }
  public static ASMString ConcurrentAccessProtocolKind_PIP(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PIP");
  }
  public static ASMString ConcurrentAccessProtocolKind_PCP(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("PCP");
  }
  public static ASMString ConcurrentAccessProtocolKind_NoPreemption(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("NoPreemption");
  }
  public static ASMString ConcurrentAccessProtocolKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString ConcurrentAccessProtocolKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString DeviceBroker(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::DeviceBroker");
  }
  public static ASMString DeviceBroker_accessPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("accessPolicy");
  }
  public static ASMString DeviceBroker_isBuffered(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isBuffered");
  }
  public static ASMString DeviceBroker_devices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("devices");
  }
  public static ASMString DeviceBroker_closeServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("closeServices");
  }
  public static ASMString DeviceBroker_controlServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("controlServices");
  }
  public static ASMString DeviceBroker_openServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("openServices");
  }
  public static ASMString DeviceBroker_readServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("readServices");
  }
  public static ASMString DeviceBroker_writeServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("writeServices");
  }
  public static ASMString AccessPolicyKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::AccessPolicyKind");
  }
  public static ASMString AccessPolicyKind_Read(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Read");
  }
  public static ASMString AccessPolicyKind_Write(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Write");
  }
  public static ASMString AccessPolicyKind_ReadWrite(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("ReadWrite");
  }
  public static ASMString AccessPolicyKind_Undef(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Undef");
  }
  public static ASMString AccessPolicyKind_Other(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Other");
  }
  public static ASMString MemoryBroker(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("SRM::MemoryBroker");
  }
  public static ASMString MemoryBroker_accessPolicy(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("accessPolicy");
  }
  public static ASMString MemoryBroker_memories(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memories");
  }
  public static ASMString MemoryBroker_memoryBlockAddressElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memoryBlockAddressElements");
  }
  public static ASMString MemoryBroker_memoryBlockSizeElements(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("memoryBlockSizeElements");
  }
  public static ASMString MemoryBroker_lockServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("lockServices");
  }
  public static ASMString MemoryBroker_unlockServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unlockServices");
  }
  public static ASMString MemoryBroker_mapServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("mapServices");
  }
  public static ASMString MemoryBroker_unMapServices(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unMapServices");
  }
  public static ASMString TimedDomain(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedDomain");
  }
  public static ASMString Clock(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::Clock");
  }
  public static ASMString Clock_standard(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("standard");
  }
  public static ASMString Clock_unit(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unit");
  }
  public static ASMString Clock_type(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("type");
  }
  public static ASMString ClockType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::ClockType");
  }
  public static ASMString ClockType_nature(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("nature");
  }
  public static ASMString ClockType_unitType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("unitType");
  }
  public static ASMString ClockType_isLogical(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isLogical");
  }
  public static ASMString ClockType_resolAttr(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("resolAttr");
  }
  public static ASMString ClockType_maxValAttr(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("maxValAttr");
  }
  public static ASMString ClockType_offsetAttr(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("offsetAttr");
  }
  public static ASMString ClockType_getTime(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("getTime");
  }
  public static ASMString ClockType_setTime(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("setTime");
  }
  public static ASMString ClockType_indexToValue(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("indexToValue");
  }
  public static ASMString TimedValueSpecification(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedValueSpecification");
  }
  public static ASMString TimedValueSpecification_interpretation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("interpretation");
  }
  public static ASMString TimedElement(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedElement");
  }
  public static ASMString TimedElement_on(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("on");
  }
  public static ASMString TimedConstraint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedConstraint");
  }
  public static ASMString TimedConstraint_interpretation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("interpretation");
  }
  public static ASMString ClockConstraint(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::ClockConstraint");
  }
  public static ASMString TimedObservation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedObservation");
  }
  public static ASMString TimedInstantObservation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedInstantObservation");
  }
  public static ASMString TimedInstantObservation_obsKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("obsKind");
  }
  public static ASMString TimedDurationObservation(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedDurationObservation");
  }
  public static ASMString TimedDurationObservation_obsKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("obsKind");
  }
  public static ASMString TimedEvent(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedEvent");
  }
  public static ASMString TimedEvent_repetition(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("repetition");
  }
  public static ASMString TimedEvent_every(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("every");
  }
  public static ASMString TimedProcessing(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("Time::TimedProcessing");
  }
  public static ASMString TimedProcessing_start(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("start");
  }
  public static ASMString TimedProcessing_finish(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("finish");
  }
  public static ASMString TimedProcessing_duration(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("duration");
  }
  public static ASMString IntervalType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::IntervalType");
  }
  public static ASMString IntervalType_intervalAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("intervalAttrib");
  }
  public static ASMString CollectionType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::CollectionType");
  }
  public static ASMString CollectionType_collectionAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("collectionAttrib");
  }
  public static ASMString TupleType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::TupleType");
  }
  public static ASMString TupleType_tupleAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("tupleAttrib");
  }
  public static ASMString ChoiceType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::ChoiceType");
  }
  public static ASMString ChoiceType_choiceType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("choiceType");
  }
  public static ASMString ChoiceType_defaultAttrib(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("defaultAttrib");
  }
  public static ASMString BoundedSubType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::BoundedSubType");
  }
  public static ASMString BoundedSubType_baseType(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("baseType");
  }
  public static ASMString BoundedSubType_minValue(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("minValue");
  }
  public static ASMString BoundedSubType_maxValue(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("maxValue");
  }
  public static ASMString BoundedSubType_isMinOpen(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isMinOpen");
  }
  public static ASMString BoundedSubType_isMaxOpen(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("isMaxOpen");
  }
  public static ASMString Var(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::Var");
  }
  public static ASMString Var_dir(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("dir");
  }
  public static ASMString ExpressionContext(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::ExpressionContext");
  }
  public static ASMString VariableDirectionKind(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("VSL::VariableDirectionKind");
  }
  public static ASMString VariableDirectionKind_in(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("in");
  }
  public static ASMString VariableDirectionKind_out(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("out");
  }
  public static ASMString VariableDirectionKind_inout(  StackFrame stackFrame,  ASMModelElement self){
    return new ASMString("inout");
  }
  /** 
 * Constants loader of ATLConstantsLoader_MARTE4RSA
 */
  public void Load(){
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Allocated");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ApplicationAllocationEnd");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ApplicationAllocationEnd_allocatedTo");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionPlatformAllocationEnd");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionPlatformAllocationEnd_allocatedFrom");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationNature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationNature_spatialDistribution");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationNature_timeScheduling");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationKind_structural");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationKind_behavioral");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocationKind_hybrid");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Allocate");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Allocate_kind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Allocate_nature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Allocate_impliedConstraint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocateActivityGroup");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AllocateActivityGroup_isUnique");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockRefine");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockRefine_constraints");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DirectionKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DirectionKind_in");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DirectionKind_out");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DirectionKind_inout");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowProperty");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowProperty_direction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowPort");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowPort_isAtomic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowPort_isConjugated");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowPort_direction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MsgPort");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MsgPort_isAtomic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MsgPort_isConjugated");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MsgPort_direction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowSendAction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"FlowSpecification");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ServiceSpecification");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SignalSpecification");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SignalSpecification_direction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadBehavior");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadBehavior_behavior");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadBehavior_demand");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAnalysisContext");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAnalysisContext_contextParams");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAnalysisContext_workload");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAnalysisContext_platform");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaResourcesPlatform");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaResourcesPlatform_resources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaEventTrace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaEventTrace_content");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaEventTrace_format");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaEventTrace_location");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaEventTrace_stream");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadEvent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadEvent_pattern");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadEvent_generator");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadEvent_trace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadEvent_timeEvent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadGenerator");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaWorkloadGenerator_pop");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_root");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_hostDemand");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_hostDemandOps");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_interOccT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_throughput");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_respT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_utilization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_utilizationOnhost");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_steps");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_cause");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaScenario_timing");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_isAtomic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_blockT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_rep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_prob");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_priority");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_servCount");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_concurRes");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_host");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_servDemand");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaStep_behavior");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaRequestedService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommStep_msgSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAcqStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAcqStep_resUnits");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaAcqStep_acqRes");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaRelStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaRelStep_relRes");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaRelStep_resUnits");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"LaxityKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"LaxityKind_hard");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"LaxityKind_soft");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"LaxityKind_other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaTimingObs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaTimingObs_laxity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaTimingObs_startEvent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaTimingObs_endEvent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaLatencyObs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaLatencyObs_latency");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaLatencyObs_miss");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaLatencyObs_utility");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaLatencyObs_maxJitter");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_commTxOvh");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_commRcvOvh");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_cntxtSwT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_clockOvh");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_memSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_utilization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_throughput");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaExecHost_schedPriRange");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_capacity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_packetT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_blockT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_transmMode");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_utilization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommHost_throughput");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommChannel");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GaCommChannel_packetSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Resource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Resource_resMult");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Resource_isProtected");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Resource_isActive");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"StorageResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"StorageResource_elementSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CommunicationEndPoint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CommunicationEndPoint_packetSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronizationResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrencyResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResource_protectKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResource_ceiling");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResource_otherProtectProtocol");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResource_scheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedulableResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedulableResource_schedParams");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedulableResource_isActive");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedulableResource_dependentScheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedulableResource_host");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_isPreemptible");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_schedPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_otherSchedPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_schedule");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_host");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_processingUnits");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_schedulableResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Scheduler_protectedSharedResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SecondaryScheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SecondaryScheduler_virtualProcessingUnits");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProcessingResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProcessingResource_speedFactor");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProcessingResource_mainScheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComputingResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CommunicationMedia");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CommunicationMedia_elementSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimingResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimerResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimerResource_duration");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimerResource_isPeriodic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GRService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"GRService_owner");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Release");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Acquire");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Acquire_isBlocking");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_usedResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_subUsages");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_execTime");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_msgSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_allocatedMemory");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_usedMemory");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_powerPeak");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ResourceUsage_energy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResourceService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResourceService_consumption");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResourceService_dissipation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_ownedHW");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_description");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_r_HW_Services");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_p_HW_Services");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_endPoints");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwResource_frequency");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComputingResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComputingResource_op_Frequencies");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCommunicationResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMemory");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMemory_timings");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMemory_memorySize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMemory_addressSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwTimingResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwStorageManager");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwStorageManager_managedMemories");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDevice");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_RISC");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_CISC");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_VLIW");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_SIMD");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ISA_Type_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology_SRAM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology_Antifuse");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology_Flash");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Technology_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_SymetricalArray");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_RowBased");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_SeaOfGates");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_HierarchicalPLD");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PLD_Class_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBranchPredictor");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwISA");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwISA_family");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwISA_inst_Width");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwISA_type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_architecture");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_mips");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_ipc");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_nbCores");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_nbPipelines");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_nbStages");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_nbALUs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_nbFPUs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_predictors");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_ownedISAs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_caches");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwProcessor_ownedMMUs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwASIC");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_technology");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_organization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_nbLUTs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_nbLUT_Inputs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_nbFlipFlops");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_blocksRAM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPLD_blocksComputing");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_MaskedROM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_EPROM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_OPT_EPROM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_EEPROM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_Flash");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ROM_Type_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType_Data");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType_Instruction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType_Unified");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CacheType_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"WritePolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"WritePolicy_WriteBack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"WritePolicy_WriteThrough");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"WritePolicy_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"WritePolicy_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_LRU");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_NFU");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_FIFO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_Random");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Repl_Policy_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCache");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCache_level");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCache_type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCache_structure");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwRAM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwRAM_organization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwRAM_isSynchronous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwRAM_isStatic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwRAM_isNonVolatile");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwROM");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwROM_type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwROM_organization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDrive");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDrive_sectorSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDrive_buffer");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDMA");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDMA_nbChannels");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDMA_transferWidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwDMA_drivenBy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwArbiter");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwArbiter_controlledMedias");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU_virtualAddrSpace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU_physicalAddrSpace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU_memoryProtection");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU_nbEntriesTLB");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMMU_ownedTLBs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMedia");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMedia_bandwidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwMedia_arbiters");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBus");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBus_addressWidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBus_wordWidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBus_isSynchronous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBus_isSerial");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBridge");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwBridge_sides");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwEndPoint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwEndPoint_connectedTo");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwClock");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwClock_frequency");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwTimer");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwTimer_nbCounters");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwTimer_counterWidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwTimer_inputClock");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwIO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwSupport");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Temperature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Humidity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Altitude");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Vibration");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Shock");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConditionType_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Card");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Channel");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Chip");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Port");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Unit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentKind_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentState");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentState_Operating");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentState_Storage");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentState_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ComponentState_Undefined");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_subComponents");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_kind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_dimensions");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_area");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_grid");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_nbPins");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_r_Conditions");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_position");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_weight");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_price");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_staticConsumption");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwComponent_staticDissipation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPowerSupply");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPowerSupply_suppliedPower");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwPowerSupply_capacity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCoolingSupply");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"HwCoolingSupply_coolingPower");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeNatureKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeNatureKind_discrete");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeNatureKind_dense");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeInterpretationKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeInterpretationKind_duration");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeInterpretationKind_instant");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeInterpretationKind_any");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_TAI");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_UT0");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_UT1");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_UTC");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_Local");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_TT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_TDB");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_TCG");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_TCB");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_Sideral");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimeStandardKind_GPS");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind_start");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind_finish");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind_send");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind_receive");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EventKind_consume");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_FIFO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_NoPreemption");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_PriorityCeiling");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_PriorityInheritance");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_StackBased");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ProtectProtocolKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_EarliestDeadlineFirst");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_FIFO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_FixedPriority");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_LeastLaxityFirst");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_RoundRobin");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_TimeTableDriven");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SchedPolicyKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TransmModeKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TransmModeKind_simplex");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TransmModeKind_halfduplex");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TransmModeKind_fullduplex");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Unit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Unit_baseUnit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Unit_convFactor");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Unit_offsetFactor");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Nfp");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConstraintKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConstraintKind_required");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConstraintKind_offered");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConstraintKind_contract");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpConstraint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpConstraint_kind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpType_valueAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpType_unitAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NfpType_exprAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaResPassStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaResPassStep_resUnits");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaResPassStep_resource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep_noSync");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep_extOpDemands");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep_extOpCount");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep_behavDemands");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaStep_behavCount");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRequestedService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaCommStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaCommStep_msgSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaCommStep_concurResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaLogicalResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaLogicalResource_utilization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaLogicalResource_throughput");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaLogicalResource_poolSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_poolSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_unbddPool");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_instance");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_host");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_utilization");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PaRunTInstance_throughput");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Shaped");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Shaped_shape");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"LinkTopology");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DefaultLink");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Reshape");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Reshape_patternShape");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Reshape_repetitionSpace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Tiler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Tiler_origin");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Tiler_paving");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Tiler_fitting");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Tiler_tiler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterRepetition");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterRepetition_repetitionSpaceDependence");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterRepetition_isModulo");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_patternShape");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_repetitionSpace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_fromTiler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_toTiler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_kind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Distribute_nature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind_infiniteWait");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind_timedWait");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind_dynamic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind_exception");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PoolMgtPolicyKind_other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_isDynamic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_isMain");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_poolSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_poolPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_poolWaitingTime");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_operationalMode");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_main");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtUnit_memorySize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CallConcurrencyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CallConcurrencyKind_sequential");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CallConcurrencyKind_guarded");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CallConcurrencyKind_concurrent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PpUnit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PpUnit_concPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"PpUnit_memorySize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtBehavior");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtBehavior_queueSchedPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtBehavior_queueSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtBehavior_msgMaxSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_utility");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_occkind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_tRef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_relDl");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_absDl");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_boundDl");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_rdTime");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_miss");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"rtf_priority");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtAction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtAction_isAtomic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtAction_msgSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtAction_synchKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind_synchronous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind_asynchronous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind_delayedSynchronous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind_rendezVous");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SynchronisationKind_other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionKind_deferred");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionKind_remoteImmediate");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExecutionKind_localImmediate");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrencyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrencyKind_reader");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrencyKind_writer");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrencyKind_parallel");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtService_concPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtService_exeKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtService_synchKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RtService_isAtomic");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RteConnector");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RteConnector_bandwidth");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RteConnector_packetT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RteConnector_blockT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"RteConnector_transmMode");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind_meetHardDeadlines");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind_minimizeMissedDeadline");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind_minimizeMeanTardiness");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind_undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"OptimallityCriterionKind_other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaAnalysisContext");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaAnalysisContext_isSched");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaAnalysisContext_optCriterion");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow_isSched");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow_schSlack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow_end2EndT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow_end2EndD");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaEnd2EndFlow_timing");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommStep_deadline");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommStep_spareCap");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommStep_schSlack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_deadline");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_spareCap");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_schSlack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_preempT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_readyT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaStep_delayT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSchedObs");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSchedObs_suspensions");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSchedObs_blockT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSchedObs_overlaps");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource_capacity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource_isPreemp");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource_isConsum");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource_acquisiT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaSharedResource_releaseT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommHost");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommHost_isSched");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaCommHost_schSlack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_isSched");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_schSlack");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_schedUtiliz");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_ISRswitchT");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_schedPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_isPreemptible");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SaExecHost_ISRprioRange");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_identifierElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_stateElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_memorySizeFootprint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_createServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_deleteServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwResource_initializeServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwAccessService");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwAccessService_isModifier");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwAccessService_accessedElement");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EntryPoint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EntryPoint_isReentrant");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"EntryPoint_routine");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind_HardwareInterrupt");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind_ProcessorDetectedException");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind_ProgrammedException");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryPartition");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryPartition_concurrentResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryPartition_memorySpaces");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryPartition_forkServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryPartition_exitServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwTimerResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwTimerResource_DurationElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_activationCapacity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_entryPoints");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_addressSpace");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_periodElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_priorityElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_stackSizeElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_shareDataResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_messageResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_mutualExclusionResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_notificationResources");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_activateServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_enableConcurrencyServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_resumeServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_suspendServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_terminateServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwConcurrentResource_disableConcurrencyServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_kind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_isMaskable");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_vectorElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_maskElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_routineConnect");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"InterruptResource_routineDisconnect");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Alarm");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Alarm_isWatchdog");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Alarm_timers");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_isStaticSchedulingFeature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_isPreemptable");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_deadlineElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_deadlineTypeElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_timeSliceElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_delayServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_joinServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_yieldServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSchedulableResource_scheduler");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwInteractionResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwInteractionResource_isIntraMemoryPartitionInteraction");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwInteractionResource_waitingQueueCapacity");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwInteractionResource_waitingQueuePolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwInteractionResource_waitingPolicyElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind_FIFO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind_LIFO");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind_Priority");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"QueuePolicyKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind_MessageQueue");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind_Pipe");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind_Blackboard");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageResourceKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind_Memorized");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind_Bounded");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind_Memoryless");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResourceKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResourceKind_Event");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResourceKind_Barrier");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResourceKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResourceKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind_BooleanSemaphore");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind_CountSemaphore");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind_Mutex");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MutualExclusionResourceKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwCommunicationResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SharedDataComResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SharedDataComResource_readServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SharedDataComResource_writeServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_isFixedMessageSize");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_mechanism");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_messageSizeElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_messageQueueCapacityElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_messageQueuePolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_sendServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MessageComResource_receiveServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwSynchronizationResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_occurenceKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_mechanism");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_occurenceCountElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_maskElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_flushServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_signalServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_waitServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"NotificationResource_clearServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource_mechanism");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource_concurrentAccessProtocol");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource_accessTokenElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource_releaseServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"SwMutualExclusionResource_acquireServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind_PIP");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind_PCP");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind_NoPreemption");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ConcurrentAccessProtocolKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_accessPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_isBuffered");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_devices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_closeServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_controlServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_openServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_readServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"DeviceBroker_writeServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind_Read");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind_Write");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind_ReadWrite");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind_Undef");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"AccessPolicyKind_Other");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_accessPolicy");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_memories");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_memoryBlockAddressElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_memoryBlockSizeElements");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_lockServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_unlockServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_mapServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"MemoryBroker_unMapServices");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedDomain");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Clock");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Clock_standard");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Clock_unit");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Clock_type");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_nature");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_unitType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_isLogical");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_resolAttr");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_maxValAttr");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_offsetAttr");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_getTime");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_setTime");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockType_indexToValue");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedValueSpecification");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedValueSpecification_interpretation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedElement");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedElement_on");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedConstraint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedConstraint_interpretation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ClockConstraint");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedObservation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedInstantObservation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedInstantObservation_obsKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedDurationObservation");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedDurationObservation_obsKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedEvent");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedEvent_repetition");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedEvent_every");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedProcessing");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedProcessing_start");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedProcessing_finish");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TimedProcessing_duration");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"IntervalType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"IntervalType_intervalAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CollectionType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"CollectionType_collectionAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TupleType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"TupleType_tupleAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ChoiceType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ChoiceType_choiceType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ChoiceType_defaultAttrib");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType_baseType");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType_minValue");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType_maxValue");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType_isMinOpen");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"BoundedSubType_isMaxOpen");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Var");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"Var_dir");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"ExpressionContext");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"VariableDirectionKind");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"VariableDirectionKind_in");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"VariableDirectionKind_out");
    ATLTransform.addCustomOperationToVM(ATLConstantsLoader_MARTE4RSA.class,"VariableDirectionKind_inout");
  }
}
