/**
 * <copyright>
 * Thales ATL for MARTE with RSA (Copyright (c) THALES 2007 All rights reserved)
 * is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published
 * in http://www.eclipse.org/legal/epl-v10.html
 * Thales MARTE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: MARTEImplementation_RSA.java,v 1.4 2008/06/16 13:56:02 sdemathieu Exp $
 */
package com.thalesgroup.atl.marte.rsa;

/**
 * RSA MARTE Implementation specificities
 * @author Eric MAES
 */

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.thalesgroup.atl.exception.ATLException;
import com.thalesgroup.atl.marte.MARTEFacilities;
import com.thalesgroup.atl.marte.MARTEImplementation;
import com.thalesgroup.nfp.rsa.facade.RSAModelFacade;

public class MARTEImplementation_RSA extends MARTEImplementation {

	
	public MARTEImplementation_RSA() {
		super("/libraries/MARTE4RSA.asm", new MARTE4RSA(), new ATLConstantsLoader_MARTE4RSA());
	}
	
	public boolean isRSA() {
		return (true);
	}
	
	public boolean isPAPYRUS() {
		return (false);
	}
	
	public String getLibraryPath() throws ATLException {
		return (this.MARTE_ATL_LIBRARY_PATH);
	}
	
	public IModelFacade getFacade(Element element) throws ATLException {
		// SD 30/11/07
		// return (new RSAModelFacade(element.getModel(),element));
		return RSAModelFacade.getInstance(element.getModel(), element);
	}
	

	public ValueSpecification getPropertyValue(Element element, Property property, Object propertyValue)
		throws ATLException
	{
		ValueSpecification retour = null;
		if (propertyValue instanceof DynamicEObjectImpl) {
			DynamicEObjectImpl propertyValueDynamicEObjectImpl = (DynamicEObjectImpl) propertyValue;
			EClass propertyValueEClass = propertyValueDynamicEObjectImpl.eClass();
			EStructuralFeature vslEStructuralFeature = propertyValueEClass.getEStructuralFeature("value");
			Object vs = propertyValueDynamicEObjectImpl.eGet(vslEStructuralFeature);
			if (vs instanceof String) {
				vs = MARTEFacilities.marteGetValueSpecification(element,property,vs.toString());
			}
			if (vs instanceof ValueSpecification) {
				retour = (ValueSpecification) vs;
			}
			else {
				String message = "Error getting the Property value of "+vs.toString();
				throw new ATLException(message);
			}
		}
		if (propertyValue instanceof EList) {
			EList propertyValues = (EList) propertyValue;
			Iterator pV = propertyValues.iterator();
			if (pV.hasNext()) {
				Object pVValue = pV.next();
				retour = getPropertyValue(element,property,pVValue);
				if (pV.hasNext()) {
					String message = "The propertyValue is a list with more than one element";
					throw new ATLException(message);
				}
			}
		}
		return(retour);
	}

}
