/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 * </copyright>
 *
 * $Id: AlgorithmKind.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Algorithm Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getAlgorithmKind()
 * @model
 * @generated
 */
public final class AlgorithmKind extends AbstractEnumerator {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The '<em><b>RM PCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RM PCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RM_PCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RM_PCP = 0;

	/**
	 * The '<em><b>RM SBP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RM SBP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RM_SBP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RM_SBP = 1;

	/**
	 * The '<em><b>RM BIP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RM BIP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RM_BIP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RM_BIP = 2;

	/**
	 * The '<em><b>RM DASPCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RM DASPCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RM_DASPCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RM_DASPCP = 3;

	/**
	 * The '<em><b>DM PCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DM PCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DM_PCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DM_PCP = 4;

	/**
	 * The '<em><b>DM SBP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DM SBP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DM_SBP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DM_SBP = 5;

	/**
	 * The '<em><b>DM BIP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DM BIP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DM_BIP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DM_BIP = 6;

	/**
	 * The '<em><b>DM DASPCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DM DASPCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DM_DASPCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DM_DASPCP = 7;

	/**
	 * The '<em><b>Cyclic Executive</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Cyclic Executive</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CYCLIC_EXECUTIVE_LITERAL
	 * @model name="CyclicExecutive"
	 * @generated
	 * @ordered
	 */
	public static final int CYCLIC_EXECUTIVE = 8;

	/**
	 * The '<em><b>ROSA RM PCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROSA RM PCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROSA_RM_PCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROSA_RM_PCP = 9;

	/**
	 * The '<em><b>ROSA DM PCP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROSA DM PCP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROSA_DM_PCP_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROSA_DM_PCP = 10;

	/**
	 * The '<em><b>RM PCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RM_PCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind RM_PCP_LITERAL = new AlgorithmKind(RM_PCP, "RM_PCP", "RM_PCP");

	/**
	 * The '<em><b>RM SBP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RM_SBP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind RM_SBP_LITERAL = new AlgorithmKind(RM_SBP, "RM_SBP", "RM_SBP");

	/**
	 * The '<em><b>RM BIP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RM_BIP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind RM_BIP_LITERAL = new AlgorithmKind(RM_BIP, "RM_BIP", "RM_BIP");

	/**
	 * The '<em><b>RM DASPCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RM_DASPCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind RM_DASPCP_LITERAL = new AlgorithmKind(RM_DASPCP, "RM_DASPCP", "RM_DASPCP");

	/**
	 * The '<em><b>DM PCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DM_PCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind DM_PCP_LITERAL = new AlgorithmKind(DM_PCP, "DM_PCP", "DM_PCP");

	/**
	 * The '<em><b>DM SBP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DM_SBP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind DM_SBP_LITERAL = new AlgorithmKind(DM_SBP, "DM_SBP", "DM_SBP");

	/**
	 * The '<em><b>DM BIP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DM_BIP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind DM_BIP_LITERAL = new AlgorithmKind(DM_BIP, "DM_BIP", "DM_BIP");

	/**
	 * The '<em><b>DM DASPCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DM_DASPCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind DM_DASPCP_LITERAL = new AlgorithmKind(DM_DASPCP, "DM_DASPCP", "DM_DASPCP");

	/**
	 * The '<em><b>Cyclic Executive</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CYCLIC_EXECUTIVE
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind CYCLIC_EXECUTIVE_LITERAL = new AlgorithmKind(CYCLIC_EXECUTIVE, "CyclicExecutive", "CyclicExecutive");

	/**
	 * The '<em><b>ROSA RM PCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROSA_RM_PCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind ROSA_RM_PCP_LITERAL = new AlgorithmKind(ROSA_RM_PCP, "ROSA_RM_PCP", "ROSA_RM_PCP");

	/**
	 * The '<em><b>ROSA DM PCP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROSA_DM_PCP
	 * @generated
	 * @ordered
	 */
	public static final AlgorithmKind ROSA_DM_PCP_LITERAL = new AlgorithmKind(ROSA_DM_PCP, "ROSA_DM_PCP", "ROSA_DM_PCP");

	/**
	 * An array of all the '<em><b>Algorithm Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final AlgorithmKind[] VALUES_ARRAY =
		new AlgorithmKind[] {
			RM_PCP_LITERAL,
			RM_SBP_LITERAL,
			RM_BIP_LITERAL,
			RM_DASPCP_LITERAL,
			DM_PCP_LITERAL,
			DM_SBP_LITERAL,
			DM_BIP_LITERAL,
			DM_DASPCP_LITERAL,
			CYCLIC_EXECUTIVE_LITERAL,
			ROSA_RM_PCP_LITERAL,
			ROSA_DM_PCP_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Algorithm Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Algorithm Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AlgorithmKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AlgorithmKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Algorithm Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AlgorithmKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AlgorithmKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Algorithm Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AlgorithmKind get(int value) {
		switch (value) {
			case RM_PCP: return RM_PCP_LITERAL;
			case RM_SBP: return RM_SBP_LITERAL;
			case RM_BIP: return RM_BIP_LITERAL;
			case RM_DASPCP: return RM_DASPCP_LITERAL;
			case DM_PCP: return DM_PCP_LITERAL;
			case DM_SBP: return DM_SBP_LITERAL;
			case DM_BIP: return DM_BIP_LITERAL;
			case DM_DASPCP: return DM_DASPCP_LITERAL;
			case CYCLIC_EXECUTIVE: return CYCLIC_EXECUTIVE_LITERAL;
			case ROSA_RM_PCP: return ROSA_RM_PCP_LITERAL;
			case ROSA_DM_PCP: return ROSA_DM_PCP_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private AlgorithmKind(int value, String name, String literal) {
		super(value, name, literal);
	}

} //AlgorithmKind
