/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: AnalysisKind.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Analysis Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getAnalysisKind()
 * @model
 * @generated
 */
public final class AnalysisKind extends AbstractEnumerator {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * The '<em><b>Single Node</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Single Node</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SINGLE_NODE_LITERAL
	 * @model name="singleNode"
	 * @generated
	 * @ordered
	 */
	public static final int SINGLE_NODE = 0;

	/**
	 * The '<em><b>Multiple Node</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Multiple Node</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MULTIPLE_NODE_LITERAL
	 * @model name="multipleNode"
	 * @generated
	 * @ordered
	 */
	public static final int MULTIPLE_NODE = 1;

	/**
	 * The '<em><b>End To End</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>End To End</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #END_TO_END_LITERAL
	 * @model name="endToEnd"
	 * @generated
	 * @ordered
	 */
	public static final int END_TO_END = 2;

	/**
	 * The '<em><b>Single Node</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SINGLE_NODE
	 * @generated
	 * @ordered
	 */
	public static final AnalysisKind SINGLE_NODE_LITERAL = new AnalysisKind(SINGLE_NODE, "singleNode", "singleNode");

	/**
	 * The '<em><b>Multiple Node</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MULTIPLE_NODE
	 * @generated
	 * @ordered
	 */
	public static final AnalysisKind MULTIPLE_NODE_LITERAL = new AnalysisKind(MULTIPLE_NODE, "multipleNode", "multipleNode");

	/**
	 * The '<em><b>End To End</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #END_TO_END
	 * @generated
	 * @ordered
	 */
	public static final AnalysisKind END_TO_END_LITERAL = new AnalysisKind(END_TO_END, "endToEnd", "endToEnd");

	/**
	 * An array of all the '<em><b>Analysis Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final AnalysisKind[] VALUES_ARRAY =
		new AnalysisKind[] {
			SINGLE_NODE_LITERAL,
			MULTIPLE_NODE_LITERAL,
			END_TO_END_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Analysis Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Analysis Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AnalysisKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AnalysisKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Analysis Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AnalysisKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			AnalysisKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Analysis Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AnalysisKind get(int value) {
		switch (value) {
			case SINGLE_NODE: return SINGLE_NODE_LITERAL;
			case MULTIPLE_NODE: return MULTIPLE_NODE_LITERAL;
			case END_TO_END: return END_TO_END_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private AnalysisKind(int value, String name, String literal) {
		super(value, name, literal);
	}

} //AnalysisKind
