/**
 * <copyright>
 * THALES MARTE TO RAPIDRMA (Copyright (c) THALES 2008 All rights reserved) is free software; you can redistribute it and/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html 
 *  
 * THALES MARTE TO RAPIDRMA is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details.
 *
 * </copyright>
 *
 * $Id: Database.java,v 1.2 2008/06/16 13:56:08 sdemathieu Exp $
 */
package com.thalesgroup.marte.rapidrma.database;

import com.thalesgroup.marte.rapidrma.resource.ResourceGraph;

import com.thalesgroup.marte.rapidrma.task.TaskGraph;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Database</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getName <em>Name</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getAlgorithm <em>Algorithm</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getTaskGraphSize <em>Task Graph Size</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getPrority <em>Prority</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getPriorityMapping <em>Priority Mapping</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getAnalysis <em>Analysis</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getTask <em>Task</em>}</li>
 *   <li>{@link com.thalesgroup.marte.rapidrma.database.Database#getResource <em>Resource</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase()
 * @model
 * @generated
 */
public interface Database extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright 2007 Thales Research & Technology";

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Name()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Algorithm</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.database.AlgorithmKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Algorithm</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Algorithm</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.AlgorithmKind
	 * @see #setAlgorithm(AlgorithmKind)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Algorithm()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	AlgorithmKind getAlgorithm();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getAlgorithm <em>Algorithm</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Algorithm</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.AlgorithmKind
	 * @see #getAlgorithm()
	 * @generated
	 */
	void setAlgorithm(AlgorithmKind value);

	/**
	 * Returns the value of the '<em><b>Task Graph Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Task Graph Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Task Graph Size</em>' attribute.
	 * @see #setTaskGraphSize(int)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_TaskGraphSize()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getTaskGraphSize();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getTaskGraphSize <em>Task Graph Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Task Graph Size</em>' attribute.
	 * @see #getTaskGraphSize()
	 * @generated
	 */
	void setTaskGraphSize(int value);

	/**
	 * Returns the value of the '<em><b>Prority</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.database.PriorityKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Prority</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Prority</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityKind
	 * @see #setPrority(PriorityKind)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Prority()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	PriorityKind getPrority();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getPrority <em>Prority</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Prority</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityKind
	 * @see #getPrority()
	 * @generated
	 */
	void setPrority(PriorityKind value);

	/**
	 * Returns the value of the '<em><b>Priority Mapping</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.database.PriorityMappingKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Priority Mapping</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Priority Mapping</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityMappingKind
	 * @see #setPriorityMapping(PriorityMappingKind)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_PriorityMapping()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	PriorityMappingKind getPriorityMapping();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getPriorityMapping <em>Priority Mapping</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Priority Mapping</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.PriorityMappingKind
	 * @see #getPriorityMapping()
	 * @generated
	 */
	void setPriorityMapping(PriorityMappingKind value);

	/**
	 * Returns the value of the '<em><b>Analysis</b></em>' attribute.
	 * The literals are from the enumeration {@link com.thalesgroup.marte.rapidrma.database.AnalysisKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Analysis</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Analysis</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.AnalysisKind
	 * @see #setAnalysis(AnalysisKind)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Analysis()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	AnalysisKind getAnalysis();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getAnalysis <em>Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Analysis</em>' attribute.
	 * @see com.thalesgroup.marte.rapidrma.database.AnalysisKind
	 * @see #getAnalysis()
	 * @generated
	 */
	void setAnalysis(AnalysisKind value);

	/**
	 * Returns the value of the '<em><b>Task</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb <em>Db</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Task</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Task</em>' reference.
	 * @see #setTask(TaskGraph)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Task()
	 * @see com.thalesgroup.marte.rapidrma.task.TaskGraph#getDb
	 * @model opposite="db" ordered="false"
	 * @generated
	 */
	TaskGraph getTask();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getTask <em>Task</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Task</em>' reference.
	 * @see #getTask()
	 * @generated
	 */
	void setTask(TaskGraph value);

	/**
	 * Returns the value of the '<em><b>Resource</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getDb <em>Db</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Resource</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Resource</em>' reference.
	 * @see #setResource(ResourceGraph)
	 * @see com.thalesgroup.marte.rapidrma.database.DatabasePackage#getDatabase_Resource()
	 * @see com.thalesgroup.marte.rapidrma.resource.ResourceGraph#getDb
	 * @model opposite="db" ordered="false"
	 * @generated
	 */
	ResourceGraph getResource();

	/**
	 * Sets the value of the '{@link com.thalesgroup.marte.rapidrma.database.Database#getResource <em>Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Resource</em>' reference.
	 * @see #getResource()
	 * @generated
	 */
	void setResource(ResourceGraph value);

} // Database